export default [
    // site Employe ritirement
    {
        name: "site-Employee-retirement",
        path: "/site-Employee-retirement",
        component: () => import("@/components/site/Retirement/RetirementComponent"),
        meta: {
            breadcrumb: [
                { title: "Form" },
                { title: "site-Employee-retirement", active: true }
            ],
            pageTitle: "site-Employee-retirement"
        }
    },
    {
        name: "site-employee-birthday-list",
        path: "/site-employee-birthday-list",
        component: () => import("@/components/site/employee/birthday/BirthdayMasterComponent"),
        meta: {
            breadcrumb: [
                { title: "Form" },
                { title: "site-Employee-retirement", active: true }
            ],
            pageTitle: "site-Employee-retirement"
        }
    },

    {
        name: "site-fine-management",
        path: "/site-fine-management",
        component: () => import("@/components/site/student/fine/StudentFineComponent"),
        meta: {
            breadcrumb: [
                { title: "Form" },
                { title: "site-Student-Fine", active: true }
            ],
            pageTitle: "site-Student-Fine"
        }
    },

    // holiday-on-duty-settings
    {
        name: "holiday-on-duty-settings",
        path: "/holiday-on-duty-settings",
        component: () => import("@/components/site/HolidayOnDuty/MasterComponent"),
        meta: {
            breadcrumb: [
                { title: "Form" },
                { title: "holiday-on-duty-settings", active: true }
            ],
            pageTitle: "holiday-on-duty-settings"
        }
    },

    // payroll
    {
        name: "site-payroll-setting",
        path: "/site-payroll-setting",
        component: () => import("@/components/site/payroll/MasterComponent"),
        meta: {
            breadcrumb: [
                { title: "Form" },
                { title: "site-payroll-setting", active: true }
            ],
            pageTitle: "site-payroll-setting"
        }
    },
    {
        name: "site-payroll-report",
        path: "/site-payroll-report",
        component: () => import("@/components/site/payroll/PayrollReportComponent"),
        meta: {
            breadcrumb: [
                { title: "Form" },
                { title: "site-payroll-report", active: true }
            ],
            pageTitle: "site-payroll-report"
        }
    },
    {
        name: "employee-master-component",
        path: "/site/employee/employee-attach-form",
        component: () => import("@/components/site/employee/MasterComponent"),
        meta: {
            breadcrumb: [
                { title: "Form" },
                { title: "Employees", active: true }
            ],
            pageTitle: "Employees"
        }
    },
    {
        name: "site-student-attach-form",
        path: "/student/list",
        component: () =>
            import("@/components/student/SiteStudentFormMasterComponent"),
        meta: {
            breadcrumb: [
                { title: "Form" },
                { title: "Students", active: true }
            ],
            pageTitle: "Students"
        }
    },
    {
        name: "site-student-details",
        path: "/student/view/:id",
        props: true,
        component: () => import("@/components/site/student/details/DetailsComponent"),
        meta: {
            breadcrumb: [
                { title: "Home", url: "/" },
                { title: "Home", active: true }
            ],
            pageTitle: "Student"
        }
    },
    {
        name: "site-student-attendance-master-component",
        path: "/site/student/attendance/master",
        component: () =>
            import("@/components/site/student/attendance/masterComponent"),
        meta: {
            breadcrumb: [
                { title: "Attendance" },
                { title: "Student Attendance", active: true }
            ],
            pageTitle: "Student Attendance"
        }
    },

    {
        name: "site-student-attendance-manual",
        path: "/site/student/attendance/manual",
        component: () =>
            import(
                "@/components/site/employee-panel/student-attendance/PeriodAttendanceComponent"
            ),
        meta: {
            breadcrumb: [
                { title: "Attendance" },
                { title: "Periodic Attendance", active: true }
            ],
            pageTitle: "Periodic Attendance"
        }
    },
    {
        name: "site-live-meeting-index",
        path: "/site/live/meeting/list",
        component: () =>
            import(
                "@/components/site/employee-panel/live/LiveMeetingComponent"
            ),
        meta: {
            breadcrumb: [
                { title: "Attendance" },
                { title: "Periodic Attendance", active: true }
            ],
            pageTitle: "Periodic Attendance"
        }
    },
    {
        name: "site-live-meeting-invitation",
        path: "/site/live/meeting/invitation/:meetingId",
        props: true,
        component: () =>
            import("@/components/site/employee-panel/live/InvitationComponent"),
        meta: {
            breadcrumb: [
                { title: "Attendance" },
                { title: "Periodic Attendance", active: true }
            ],
            pageTitle: "Periodic Attendance"
        }
    },
    {
        name: "site-live-meeting-routine-invitation",
        path: "/site/live/meeting/routine-invitation/:meetingId",
        props: true,
        component: () =>
            import(
                "@/components/site/employee-panel/live/RoutineInvitationComponent"
            ),
        meta: {
            breadcrumb: [
                { title: "Attendance" },
                { title: "Routine Allocation", active: true }
            ],
            pageTitle: "Routine Allocation"
        }
    },

    {
        name: "site-employee-individual-attendance-master",
        path: "/site/employee/attendance/employee-individual-attendance-master",
        component: () =>
            import(
                "@/components/site/employee-panel/attendance/EmployeeAttendanceMasterComponent"
            ),
        meta: {
            breadcrumb: [
                { title: "Attendance" },
                { title: "Individual Attendance", active: true }
            ],
            pageTitle: "Individual Attendance"
        }
    },
    {
        name: "site-shift-details-list",
        path: "/site/shift-details/list",
        component: () =>
            import("@/components/site/time-table/ShiftSettingComponent"),
        meta: {
            breadcrumb: [
                { title: "Settings" },
                { title: "Time Setting" },
                { title: "Shift Details", active: true }
            ],
            pageTitle: "Shift Details"
        }
    },
    // {
    //     name: "subject-exam-marks-setting",
    //     path: "/site/subject-group-condition-setting/subject-exam-marks-setting",
    //     component: () =>
    //         import(
    //             "@/components/site/exam/exam-setting/SiteSubjectExamMarksSettingMaster"
    //         ),
    //     meta: {
    //         breadcrumb: [
    //             { title: "Exam-Settings" },
    //             { title: "Subject Exam Settings", active: true },
    //         ],
    //         pageTitle: "Subject Exam Settings"
    //     }
    // },
    {
        name: "subject-group-condition-master",
        path: "/site/subject-group-condition-setting/list",
        component: () =>
            import(
                "@/components/site/subject-group-condition/SubjectGroupConditionMasterComponent"
            ),
        meta: {
            breadcrumb: [
                { title: "Settings" },
                { title: "Academic Settings" },
                { title: "Subject Group Condition", active: true }
            ],
            pageTitle: "Subject Group Condition"
        }
    },

    {
        name: "site-shift-class-group-section-setting-master",
        path: "/site/shift-class-group-section-setting/master",
        component: () =>
            import("@/components/site/class-section/masterComponent"),
        meta: {
            breadcrumb: [
                { title: "Settings" },
                { title: "Academic Settings" },
                { title: "Class Section Setup", active: true }
            ],
            pageTitle: "Class Section Setup"
        }
    },
    {
        name: "site-student-attendance-report-master",
        path: "/site/student/attendance/report/master",
        component: () =>
            import(
                "@/components/site/student/attendance/report/masterComponent"
            ),
        meta: {
            breadcrumb: [
                { title: "Attendance" },
                { title: "Studence Attendance report", active: true }
            ],
            pageTitle: "Studence Attendance report"
        }
    },
    {
        name: "site-employee-attendance-master",
        path: "/site/employee/attendance/master",
        component: () =>
            import("@/components/site/employee/attendance/masterComponent"),
        meta: {
            breadcrumb: [
                { title: "Attendance" },
                { title: "Employee Attendance", active: true }
            ],
            pageTitle: "Employee Attendance"
        }
    },
    // {
    //     name: "site-employee-attendance-message",
    //     path: "/site/employee/attendance/me",
    //     component: () =>
    //         import("@/components/site/employee/attendance/masterComponent"),
    //     meta: {
    //         breadcrumb: [
    //             { title: "Attendance" },
    //             { title: "Employee Attendance", active: true }
    //         ],
    //         pageTitle: "Employee Attendance"
    //     }
    // },
    {
        name: "site-calendar-master",
        path: "/site/calendar-view",
        component: () =>
            import(
                "@/components/site/employee/calendar/EmployeeCalendarMasterComponent"
            ),
        meta: {
            breadcrumb: [
                { title: "Timetable" },
                { title: "Calendar Management" },
                { title: "Calendar View", active: true }
            ],
            pageTitle: "Calendar View"
        }
    },
    {
        name: "site-calendar-index",
        path: "/site/calendar/",
        component: () =>
            import(
                "@/components/site/AcademicCalendar/academicCalenderMasterComponent"
            ),
        meta: {
            breadcrumb: [
                { title: "Timetable" },
                { title: "Calendar Management" },
                { title: "Academic Calendar", active: true }
            ],
            pageTitle: "Academic Calendar"
        },
        children: [
            {
                name: "site-academic-calendar-monthly-view",
                path: "monthly-view",
                component: () =>
                    import(
                        "@/components/site/AcademicCalendar/academicCalendarComponent"
                    ),
                meta: {
                    breadcrumb: [
                        { title: "Timetable" },
                        { title: "Calendar Management" },
                        { title: "Academic Calendar" },
                        { title: "Monthly Calendar", active: true }
                    ],
                    pageTitle: "Monthly Calendar"
                }
            },
            {
                name: "site-academic-calendar-yearly-view",
                path: "yearly-view",
                component: () =>
                    import(
                        "@/components/site/AcademicCalendar/academicYearlyCalendarComponent"
                    ),
                meta: {
                    breadcrumb: [
                        { title: "Timetable" },
                        { title: "Calendar Management" },
                        { title: "Academic Calendar" },
                        { title: "Yearly Calendar", active: true }
                    ],
                    pageTitle: "Yearly Calendar"
                }
            },
            {
                name: "site-academic-calendar-list-view",
                path: "list-view",
                component: () =>
                    import(
                        "@/components/site/AcademicCalendar/academicCalendarEventListComponent"
                    ),
                meta: {
                    breadcrumb: [
                        { title: "Timetable" },
                        { title: "Calendar Management" },
                        { title: "Academic Calendar", active: true },
                        { title: "List", active: true }
                    ],
                    pageTitle: "Academic Calendar List"
                }
            }
        ]
    },
    {
        name: "site-sms-master",
        path: "/site/sms/master",
        component: () =>
            import("@/components/site/communication/sms/MasterComponent"),
        meta: {
            breadcrumb: [
                { title: "Timetable" },
                { title: "Communication" },
                { title: "Admin SMS", active: true }
            ],
            pageTitle: "Admin SMS"
        }
    },
    {
        name: "site-notice-master",
        path: "/site/notice/master",
        component: () =>
            import("@/components/site/communication/notice/MasterComponent"),
        meta: {
            breadcrumb: [
                { title: "Timetable" },
                { title: "Communication" },
                { title: "Admin Notice", active: true }
            ],
            pageTitle: "Admin Notice"
        }
    },
    {
        name: "site-notice-edit",
        path: "/site/notice/edit/:id",
        props: true,
        component: () =>
            import("@/components/site/communication/notice/NewNoticeComponent"),
        meta: {
            breadcrumb: [
                { title: "Home", url: "/" },
                { title: "Home", active: true }
            ],
            pageTitle: "Notice Update"
        }
    },
    {
        name: "site-option-master",
        path: "/site/option/view-and-form",
        component: () => import("@/components/site/options/masterComponent"),
        meta: {
            breadcrumb: [
                { title: "Settings" },
                { title: "Individual Office Manager", active: true }
            ],
            pageTitle: "Individual Office Manager"
        }
    },
    {
        name: "site-web-setting-master",
        path: "/site/web/setting",
        component: () =>
            import("@/components/site/web/setting/MasterComponent"),
        meta: {
            breadcrumb: [
                { title: "Settings" },
                { title: "Web Setting", active: true }
            ],
            pageTitle: "Web Setting Master"
        },
        children: [
            {
                name: "site-web-setting-event-list",
                path: "master",
                component: () =>
                    import(
                        "@/components/site/web/setting/event/EventListComponent"
                    ),
                meta: {
                    breadcrumb: [
                        { title: "Settings" },
                        { title: "Web Setting" },
                        { title: "Web Setting Event List", active: true }
                    ],
                    pageTitle: "Web Setting Event List"
                }
            },
            {
                name: "site-web-setting-event-new",
                path: "event/new",
                component: () =>
                    import(
                        "@/components/site/web/setting/event/NewEventComponent"
                    ),
                meta: {
                    breadcrumb: [
                        { title: "Settings" },
                        { title: "Web Setting" },
                        { title: "Web Setting Event", active: true }
                    ],
                    pageTitle: "Web Setting Event"
                }
            },
            {
                name: "site-web-setting-event-edit",
                path: "event/edit/:eventId",
                props: true,
                component: () =>
                    import(
                        "@/components/site/web/setting/event/NewEventComponent"
                    ),
                meta: {
                    breadcrumb: [
                        { title: "Settings" },
                        { title: "Web Setting" },
                        { title: "Web Setting Event Edit", active: true }
                    ],
                    pageTitle: "Web Setting Event Edit"
                }
            },
            {
                name: "site-web-setting-about-us-list",
                path: "about/list",
                component: () =>
                    import(
                        "@/components/site/web/setting/about/AboutUsListComponent"
                    ),
                meta: {
                    breadcrumb: [
                        { title: "Settings" },
                        { title: "Web Setting" },
                        { title: "Web Setting About Us List", active: true }
                    ],
                    pageTitle: "Web Setting About Us List"
                }
            },
            {
                name: "site-web-setting-about-us-new",
                path: "about/new",
                component: () =>
                    import("@/components/site/web/setting/about/NewComponent"),
                meta: {
                    breadcrumb: [
                        { title: "Settings" },
                        { title: "Web Setting" },
                        { title: "Web Setting About Us", active: true }
                    ],
                    pageTitle: "Web Setting About Us"
                }
            },
            {
                name: "site-web-setting-about-us-edit",
                path: "about/edit/:aboutId",
                props: true,
                component: () =>
                    import("@/components/site/web/setting/about/NewComponent"),
                meta: {
                    breadcrumb: [
                        { title: "Settings" },
                        { title: "Web Setting" },
                        { title: "Web Setting About Us Edit", active: true }
                    ],
                    pageTitle: "Web Setting About Us Edit"
                }
            },
            {
                name: "site-web-setting-message-list",
                path: "message/list",
                component: () =>
                    import(
                        "@/components/site/web/setting/message/MessageListComponent"
                    ),
                meta: {
                    breadcrumb: [
                        { title: "Settings" },
                        { title: "Web Setting" },
                        { title: "Web Setting Message List", active: true }
                    ],
                    pageTitle: "Web Setting Message List"
                }
            },
            {
                name: "site-web-setting-message-new",
                path: "message/new",
                component: () =>
                    import(
                        "@/components/site/web/setting/message/MessageComponent"
                    ),
                meta: {
                    breadcrumb: [
                        { title: "Settings" },
                        { title: "Web Setting" },
                        { title: "Web Setting Message", active: true }
                    ],
                    pageTitle: "Web Setting Message"
                }
            },
            {
                name: "site-web-setting-message-edit",
                path: "message/edit/:messageId",
                props: true,
                component: () =>
                    import(
                        "@/components/site/web/setting/message/MessageComponent"
                    ),
                meta: {
                    breadcrumb: [
                        { title: "Settings" },
                        { title: "Web Setting" },
                        { title: "Web Setting Message Edit", active: true }
                    ],
                    pageTitle: "Web Setting Message Edit"
                }
            },
            {
                name: "site-web-setting-class-room-list",
                path: "class-room/list",
                component: () =>
                    import(
                        "@/components/site/web/setting/classroom/ClassRoomListComponent"
                    ),
                meta: {
                    breadcrumb: [
                        { title: "Settings" },
                        { title: "Web Setting" },
                        { title: "Web Setting Class Room List", active: true }
                    ],
                    pageTitle: "Web Setting Class Room List"
                }
            },
            {
                name: "site-web-setting-class-room-new",
                path: "class-room/new",
                component: () =>
                    import(
                        "@/components/site/web/setting/classroom/ClassRoomComponent"
                    ),
                meta: {
                    breadcrumb: [
                        { title: "Settings" },
                        { title: "Web Setting" },
                        { title: "Web Setting Class Room", active: true }
                    ],
                    pageTitle: "Web Setting Class Room"
                }
            },
            {
                name: "site-web-setting-class-room-edit",
                path: "class-room/edit/:classroomId",
                props: true,
                component: () =>
                    import(
                        "@/components/site/web/setting/classroom/ClassRoomComponent"
                    ),
                meta: {
                    breadcrumb: [
                        { title: "Settings" },
                        { title: "Web Setting" },
                        { title: "Web Setting Class Room Edit", active: true }
                    ],
                    pageTitle: "Web Setting Class Room Edit"
                }
            },
            {
                name: "site-web-setting-web-menu",
                path: "web-menu",
                props: true,
                component: () =>
                    import(
                        "@/components/site/web/setting/menu/WebMenuComponent"
                    ),
                meta: {
                    breadcrumb: [
                        { title: "Settings" },
                        { title: "Web Setting" },
                        { title: "Web Setting Web Menu", active: true }
                    ],
                    pageTitle: "Web Setting Web Menu"
                }
            },
            {
                name: "site-web-setting-social-icon-set",
                path: "social-icon",
                props: true,
                component: () =>
                    import(
                        "@/components/site/web/setting/socialicon/SocialIconSettingComponent"
                    ),
                meta: {
                    breadcrumb: [
                        { title: "Settings" },
                        { title: "Social Icon" },
                        { title: "Social Icon Set", active: true }
                    ],
                    pageTitle: "Social Icon Set"
                }
            },
            {
                name: "site-web-setting-web-menu-by-parent",
                path: "web-menu/:parentId",
                props: true,
                component: () =>
                    import(
                        "@/components/site/web/setting/menu/WebMenuComponent"
                    ),
                meta: {
                    breadcrumb: [
                        { title: "Settings" },
                        { title: "Web Setting" },
                        { title: "Web Setting Web Menu", active: true }
                    ],
                    pageTitle: "Web Setting Web Menu"
                }
            },
            {
                name: "site-web-setting-citizen-charter",
                path: "citizen-charter",
                component: () =>
                    import(
                        "@/components/site/web/setting/menu/WebMenuComponent"
                    ),
                meta: {
                    breadcrumb: [{ title: "Settings" }],
                    pageTitle: "Web Setting Citizen Charter"
                }
            },
            {
                name: "site-web-setting-citizen-charter-new",
                path: "citizen-charter-new",
                component: () =>
                    import(
                        "@/components/site/web/setting/classroom/ClassRoomComponent"
                    ),
                meta: {
                    breadcrumb: [{ title: "Settings" }],
                    pageTitle: "Web Setting New Citizen Charter"
                }
            },
            {
                name: "site-header-setting-component",
                path: "header-design",
                component: () =>
                    import(
                        "@/components/site/web/setting/home-page/SiteHeaderSettingComponent"
                    ),
                meta: {
                    breadcrumb: [{ title: "Home Page" }],
                    pageTitle: "Header Setting"
                }
            },
            {
                name: "site-web-setting-video",
                path: "website-video/new",
                component: () =>
                    import(
                        "@/components/site/web/setting/video/VideoComponent"
                    ),
                meta: {
                    breadcrumb: [
                        { title: "Settings" },
                        { title: "Web Setting" },
                        { title: "Video", active: true }
                    ],
                    pageTitle: "Web Setting Video"
                }
            },
            {
                name: "site-web-setting-video-list",
                path: "website-video/list",
                component: () =>
                    import(
                        "@/components/site/web/setting/video/VideoListComponent"
                    ),
                meta: {
                    breadcrumb: [
                        { title: "Settings" },
                        { title: "Web Setting" },
                        { title: "Video List", active: true }
                    ],
                    pageTitle: "Web Setting Video List"
                }
            },
            {
                name: "site-web-setting-video-edit",
                path: "website-video/edit/:videoId",
                props: true,
                component: () =>
                    import(
                        "@/components/site/web/setting/video/VideoComponent"
                    ),
                meta: {
                    breadcrumb: [
                        { title: "Settings" },
                        { title: "Web Setting" },
                        { title: "Video Edit", active: true }
                    ],
                    pageTitle: "Web Setting Video Update"
                }
            },



        ]
    },

    {
        name: "site-period-type-setting",
        path: "/site/academic/period-type/setting",
        component: () =>
            import("@/components/site/academic/PeriodTypeSettingComponent"),
        meta: {
            breadcrumb: [
                { title: "Settings" },
                { title: "Academic Settings", url: "/" },
                { title: "Period Type Setting", active: true }
            ],
            pageTitle: "Period Type Setting"
        }
    },
    {
        name: "site-academic-setting-replication",
        path: "/site/site-academic-setting-replication/view",
        component: () =>
            import(
                "@/components/site/siteAcademicSettingReplication/siteAcademicSettingReplicationComponent"
            ),
        meta: {
            breadcrumb: [
                { title: "Settings" },
                { title: "Academic Settings" },
                { title: "Setting Replication", active: true }
            ],
            pageTitle: "Site Setting Replication"
        }
    },

    {
        name: "site-student-promotion-view",
        path: "/site/student/promotion/view",
        component: () =>
            import("@/components/site/student/promotion/masterComponent"),
        meta: {
            breadcrumb: [
                { title: "Settings" },
                { title: "Student Promotion", active: true }
            ],
            pageTitle: "Promotion"
        }
    },
    {
        name: "site-routine-master",
        path: "/site/routine/master",
        component: () => import("@/components/site/routine/masterComponent"),
        meta: {
            breadcrumb: [
                { title: "Timetable" },
                { title: "Routine Management" },
                { title: "Routine Setting", active: true }
            ],
            pageTitle: "Routine Setting"
        }
    },
    {
        name: "site-student-report-master",
        path: "/site/student/report/master",
        component: () =>
            import("@/components/site/student/report/masterComponent"),
        meta: {
            breadcrumb: [
                { title: "report Manager" },
                { title: "Student Details", active: true }
            ],
            pageTitle: "Student Details"
        }
    },
    {
        name: "site-student-id-card-master",
        path: "/site/student/idcard/master",
        component: () =>
            import("@/components/site/student/id-card/masterComponent"),
        meta: {
            breadcrumb: [
                { title: "report Manager" },
                { title: "Student ID Card", active: true }
            ],
            pageTitle: "Student ID Card"
        }
    },
    {
        name: "site-employee-report-master",
        path: "/site/employee/report/master",
        component: () =>
            import("@/components/site/employee/report/masterComponent"),
        meta: {
            breadcrumb: [
                { title: "report Manager", url: "/" },
                { title: "Employeee ID Card", active: true }
            ],
            pageTitle: "Employeee ID Card"
        }
    },
    {
        name: "site-user-master",
        path: "/site/user/master",
        component: () => import("@/components/site/users/masterComponent"),
        meta: {
            breadcrumb: [
                { title: "Settings" },
                { title: "User Settings" },
                { title: "User Role Permission", active: true }
            ],
            pageTitle: "User Role Permission"
        }
    },

    // {
    //     name: "site-class-subject-topic-component",
    //     path: "/site/assessment/class-subject-assessment-topic-form",
    //     component: () =>
    //         import("@/components/site/assessment/SiteClassSubjectWiseAssessmentTopicsComponent"),
    //     meta: {
    //         breadcrumb: [
    //             { title: "Assessment Management" },
    //             { title: "Assessment Topics", active: true }
    //         ],
    //         pageTitle: "Assessment Topics"
    //     }
    // },

    // {
    //     name: "site-assessment-settings-component",
    //     path: "/site/assessment/assessment-settings-master",
    //     component: () =>
    //         import("@/components/site/assessment/SiteAssessmentSettingsMasterComponent"),
    //     meta: {
    //         breadcrumb: [
    //             { title: "Assessment Management" },
    //             { title: "Assessment Settings", active: true }
    //         ],
    //         pageTitle: "Assessment Settings"
    //     }
    // },
    // {
    //     name: "site-assessment-subject-and-topic-settings",
    //     path: "/site/assessment/assessment-subject-and-topic-settings",
    //     component: () =>
    //         import("@/components/site/assessment/SiteAssessmentAndTypeSettingComponent"),
    //     meta: {
    //         breadcrumb: [
    //             { title: "Assessment Management" },
    //             { title: "Assessment Topics", active: true }
    //         ],
    //         pageTitle: "Assessment Topics"
    //     }
    // },

    {
        name: "site-assessment-subject-student-declare-form",
        path: "/site/assessment/site-assessment-declare-form",
        component: () =>
            import("@/components/site/assessment/SiteAssessmentDeclareComponent"),
        meta: {
            breadcrumb: [
                { title: "Assessment Management" },
                { title: "Assessment Declare", active: true }
            ],
            pageTitle: "Assessment Declare"
        }
    },
    {
        name: "site-assessment-mark-entry-form",
        path: "/site/assessment/site-assessment-mark-entry-form",
        component: () =>
            import("@/components/site/assessment/SiteAssessmentMarksEntryComponent"),
        meta: {
            breadcrumb: [
                { title: "Assessment Management" },
                { title: "Assessment Mark Entry", active: true }
            ],
            pageTitle: "Assessment Mark Entry"
        }
    },

    // {
    //     name: "get-site-assessment-result-setting-form",
    //     path: "/site/assessment-result/get-site-assessment-result-setting-form",
    //     component: () =>
    //         import("@/components/site/assessment-result/SiteAssessmentResultSettingMasterComponent"),
    //     meta: {
    //         breadcrumb: [
    //             { title: "Assessment Result" },
    //             { title: "Assessment Result Setting", active: true }
    //         ],
    //         pageTitle: "Assessment Result Setting"
    //     }
    // },

    {
        name: "site-assessment-result-generate-form",
        path: "/site/assessment-result/site-assessment-result-generate-form",
        component: () =>
            import("@/components/site/assessment-result/SiteAssessmentResultGenerateMasterComponent"),
        meta: {
            breadcrumb: [
                { title: "Assessment Management" },
                { title: "Assessment Result Generate", active: true }
            ],
            pageTitle: "Assessment Result Generate"
        }
    },

    {
        name: "site-assessment-result-report-form",
        path: "/site/assessment-result/report/site-assessment-result-report-form",
        component: () =>
            import("@/components/site/assessment-result/report/SiteAssessmentResultReportMasterComponent"),
        meta: {
            breadcrumb: [
                { title: "Assessment Management" },
                { title: "Assessment Result Report", active: true }
            ],
            pageTitle: "Assessment Result Report"
        }
    },

    // {
    //     name: "site-assessment-primary-result-report-form",
    //     path: "/site/assessment-result/report/site-assessment-primary-result-report-form",
    //     component: () =>
    //         import("@/components/site/assessment-result/report/SiteAssessmentPrimaryResultReportMasterComponent"),
    //     meta: {
    //         breadcrumb: [
    //             { title: "Assessment Management" },
    //             { title: "Assessment Primary Result Report", active: true }
    //         ],
    //         pageTitle: "Assessment Primary Result Report"
    //     }
    // },
    

    {
        name: "site-exam-declare-component",
        path: "/site/exam-declare/site-exam-declare-form",
        component: () =>
            import("@/components/site/exam/SiteExamDeclareComponent"),
        meta: {
            breadcrumb: [
                { title: "Eaxm Management" },
                { title: "Exam Declare", active: true }
            ],
            pageTitle: "Exam Declare"
        }
    },
    {
        name: "site-answer-paper-distribution-component",
        path:
            "/site/site-answer-paper/site-base-answer-paper-distribution-form",
        component: () =>
            import(
                "@/components/site/exam/SiteAnswerPaperDistributionComponent"
            ),
        meta: {
            breadcrumb: [
                { title: "Eaxm Management" },
                { title: "Answer Paper Distribution", active: true }
            ],
            pageTitle: "Answer Paper Distribution"
        }
    },

    {
        name: "site-marks-entry-master-component",
        path: "/site/site-mark-entry/site-exam-marks-entry-form",
        component: () =>
            import("@/components/site/exam/SiteMarksEntryMasterComponent"),
        meta: {
            breadcrumb: [
                { title: "Exam Management", url: "/" },
                { title: "Exam Marks Entry", active: true }
            ],
            pageTitle: "Exam Marks Entry"
        }
    },

    {
        name: "site-marks-entry-send-master-component",
        path: "/site/site-marks/send-mark-master",
        component: () =>
            import("@/components/site/exam/exam-mark-send/SiteExamMarkSendMasterComponent"),
        meta: {
            breadcrumb: [
                { title: "Exam Management", url: "/" },
                { title: "Exam Marks Entry", active: true }
            ],
            pageTitle: "Exam Marks Entry"
        }
    },
    {
        name: "site-exam-mark-list-component",
        path: "/site/mark-list/site-all-exam-mark-list",
        component: () =>
            import("@/components/site/exam/mark-list/SiteExamEntryMarkListMasterComponent"),
        meta: {
            breadcrumb: [
                { title: "Exam Management", url: "/" },
                { title: "Exam Marks Entry", active: true }
            ],
            pageTitle: "Exam Marks Entry"
        }
    },
    {
        name: "exam-room-invigilator-master-component",
        path:
            "/site/exam-room-invigilator/invigilator-setup/site-exam-room-invigilator-set-form",
        component: () =>
            import(
                "@/components/site/exam/invigilator/ExamRoomInvigilatorMasterComponent"
            ),
        meta: {
            breadcrumb: [
                { title: "Home", url: "/" },
                { title: "Home", active: true }
            ],
            pageTitle: "Exam Invigilator"
        }
    },
    {
        name: "site-room-setting-master-component",
        path:
            "/site/seat-plan/seat-plan-generate/site-base-exam-seat-plan-form",
        component: () =>
            import(
                "@/components/site/exam/seat-plan/SiteRoomSettingMasterComponent"
            ),
        meta: {
            breadcrumb: [
                { title: "Home", url: "/" },
                { title: "Home", active: true }
            ],
            pageTitle: "Exam Seat Plan"
        }
    },
    {
        name: "site-exam-committee-declare-component",
        path: "/site/exam-committee/exam-committee-declare-form",
        component: () =>
            import("@/components/site/exam/SiteExamCommitteeDeclareComponent"),
        meta: {
            breadcrumb: [
                { title: "Exam Management" },
                { title: "Exam Individual Committee", active: true }
            ],
            pageTitle: "Exam Individual Committee"
        }
    },
    {
        name: "site-examination-setting-master",
        path: "/site/exam/examination-setting-master",
        component: () =>
            import(
                "@/components/site/exam/exam-setting/SiteSubjectExamMarksSettingMaster"
            ),
        meta: {
            breadcrumb: [
                { title: "Exam-Settings", active: true }
            ],
            pageTitle: "Exam-Settings"
        }
    },
    {
        name: "site-progress-category-system-setting",
        path: "/site/progress/progress-category-system-setting",
        component: () =>
            import(
                 "@/components/site/progress/progress-setting/SiteProgressCategorySettingMaster"
            ),
        meta: {
            breadcrumb: [
                { title: "Progress-Settings", active: true }
            ],
            pageTitle: "Progress-Settings"
        }
    },
    {
        name: "site-progress-declare-master",
        path: "/site/progress/progress-declare-master",
        component: () =>
            import(
                 "@/components/site/progress/SiteProgressDeclareComponent"
            ),
        meta: {
            breadcrumb: [
                { title: "Progress-Declare", active: true }
            ],
            pageTitle: "Progress-Declare"
        }
    },
    // {
    //     name: "subject-exam-marks-setting",
    //     path: "/site/subject-group-condition-setting/subject-exam-marks-setting",
    //     component: () =>
    //         import(
    //             "@/components/site/exam/exam-setting/SiteSubjectExamMarksSettingMaster"
    //         ),
    //     meta: {
    //         breadcrumb: [
    //             { title: "Exam-Settings" },
    //             { title: "Subject Exam Settings", active: true },
    //         ],
    //         pageTitle: "Subject Exam Settings"
    //     }
    // },
    // {
    //     name: "site-examination-exam-type-setting-component",
    //     path: "/site/exam/examination-exam-type-setting-form",
    //     component: () =>
    //         import(
    //             "@/components/site/exam/SiteExaminationExamTypeSettingComponent"
    //         ),
    //     meta: {
    //         breadcrumb: [
    //             { title: "Settings" },
    //             { title: "Academic Settings" },
    //             { title: "Examination & Exam Type", active: true }
    //         ],
    //         pageTitle: "Examination Exam Type Setting"
    //     }
    // },
    {
        name: "site-exam-question-component",
        path: "/site/exam-question/form",
        component: () =>
            import("@/components/site/exam/question/SiteExamQuestionComponent"),
        meta: {
            breadcrumb: [
                { title: "Exam Management" },
                { title: "Exam Question", active: true }
            ],
            pageTitle: "Exam Question"
        }
    },
    {
        name: "site-exam-question-list-component",
        path: "/site/exam-question/list-view",
        component: () =>
            import(
                "@/components/site/exam/question/SiteExamQuestionListComponent"
            ),
        meta: {
            breadcrumb: [
                { title: "Exam Management" },
                { title: "Exam Question List", active: true }
            ],
            pageTitle: "Exam Question List"
        }
    },
    {
        name: "site-exam-question-edit",
        path: "/site/exam-question/edit/:questionId",
        props: true,
        component: () =>
            import("@/components/site/exam/question/SiteExamQuestionComponent"),
        meta: {
            breadcrumb: [
                { title: "Exam Management" },
                { title: "Exam Question Edit", active: true }
            ],
            pageTitle: "Exam Question Edit"
        }
    },

    // {
    //     name: "site-exam-mark-list",
    //     path: "/site/exam-question/edit/:questionId",
    //     props: true,
    //     component: () =>
    //         import("@/components/site/exam/question/SiteExamQuestionComponent"),
    //     meta: {
    //         breadcrumb: [
    //             { title: "Exam Management" },
    //             { title: "Exam Question Edit", active: true }
    //         ],
    //         pageTitle: "Exam Question Edit"
    //     }
    // },

    //////////////////////
    // this routes are copy for quiz modiul
    {
        name: "site-quiz-question-form-component",
        path: "/site/quiz-question1/form",
        component: () =>
            //     import("@/components/site/exam/question2/SiteExamQuestionComponent"),
            import("@/components/site/quiz/question/SiteQuizQuestionComponent"),
        meta: {
            breadcrumb: [
                { title: "Quiz Management" },
                { title: "Quiz Question", active: true }
            ],
            pageTitle: "Quiz Question"
        }
    },
    {
        name: "site-quiz-question-list-component",
        path: "/site/quiz-question1/list-view",
        component: () =>
            //   import("@/components/site/exam/question2/SiteExamQuestionListComponent"),
            import("@/components/site/quiz/question/SiteQuizQuestionListComponent"),
        meta: {
            breadcrumb: [
                { title: "Exam Management" },
                { title: "Exam Question List", active: true }
            ],
            pageTitle: "Exam Question List"
        }
    },

    {
        name: "site-quiz-question-edit",
        path: "/site/quiz-question1/edit/:questionId",
        props: true,
        component: () =>
            import("@/components/site/quiz/question/SiteQuizQuestionComponent"),
        meta: {
            breadcrumb: [
                { title: "Exam Management" },
                { title: "Exam Question Edit", active: true }
            ],
            pageTitle: "Exam Question Edit"
        }
    },

    {
        name: "quiz-component",
        path: "/site/quiz",
        component: () => import("@/components/site/quiz/QuizMasterComponent"),
        meta: {
            breadcrumb: [
                { title: "Quiz", active: true },
            ],
            pageTitle: "Quiz"
        }
    },

    {
        name: "quiz-topics-question-list",
        path: "/site/quiz-question/list-view",
        component: () => import("@/components/site/quiz/question/SiteQuizQuestionListComponent"),
        meta: {
            breadcrumb: [
                { title: "Quiz" },
                { title: "Quiz Question List", active: true },
            ],
            pageTitle: "Quiz Question List"
        }
    },
    {
        name: "site-result-generate-master-component",
        path: "/site/result-generate/site-result-generate-form",
        component: () =>
            import(
                "@/components/site/result/SiteResultGenerateMasterComponent"
            ),
        meta: {
            breadcrumb: [
                { title: "Result Management" },
                { title: "Result Generate", active: true }
            ],
            pageTitle: "Result Generate"
        }
    },
    {
        name: "site-result-permission-master-component",
        path: "/site/result-permission/site-result-permission",
        component: () =>
            import(
                "@/components/site/result/permission/SiteResultPermissionMasterComponent"
            ),
        meta: {
            breadcrumb: [
                { title: "Result Management" },
                { title: "Result Permission", active: true }
            ],
            pageTitle: "Result Permission"
        }
    },
    {
        name: "site-result-report-master-component",
        path: "/site/result-report/site-result-report-form",
        component: () =>
            import(
                "@/components/site/result/report/SiteResultReportMasterComponent"
            ),
        meta: {
            breadcrumb: [
                { title: "Result Management" },
                { title: "Result View", active: true }
            ],
            pageTitle: "Result View"
        }
    },
    {
        name: "site-result-report-two-master-component",
        path: "/site/result-report/site-result-report-two-master",
        component: () =>
            import(
                "@/components/site/result/report/SiteResultReportTwoMasterComponent"
            ),
        meta: {
            breadcrumb: [
                { title: "Result Management" },
                { title: "Result View Two", active: true }
            ],
            pageTitle: "Result View Two"
        }
    },
    {
        name: "site-combine-result-report-master-component",
        path: "/site/result-statistics/site-combine-result-report-master",
        component: () =>
            import(
                "@/components/site/result/report/combine/SiteCombineResultReportMasterComponent"
            ),
        meta: {
            breadcrumb: [
                { title: "Result Management" },
                { title: "Result View Two", active: true }
            ],
            pageTitle: "Result View Two"
        }
    },
    {
        name: "site-result-report-send-sms-form",
        path: "/site/result-report/site-result-report-sms-master-component",
        component: () =>
            import(
                "@/components/site/result/report/SiteResultReportSendSmsComponent"
            ),
        meta: {
            breadcrumb: [
                { title: "Result Management" },
                { title: "Result View SMS", active: true }
            ],
            pageTitle: "Result SMS"
        }
    },


    {
        name: "site-result-setting-master-component",
        path: "/site/result-setting/site-result-setting-form",
        component: () =>
            import("@/components/site/result/SiteResultSettingMasterComponent"),
        meta: {
            breadcrumb: [
                { title: "Settings" },
                { title: "Academic Settings" },
                { title: "Individual Result Setting", active: true }
            ],
            pageTitle: "Result Setting"
        }
    },
    {
        name: "emp-exam-marks-entry-component",
        path: "/site/employee-panel/exam/employee-exam-marks-entry-form",
        component: () =>
            import(
                "@/components/site/employee-panel/exam/mark-entry/EmpExamMarksEntryMasterComponent"
            ),
        meta: {
            breadcrumb: [
                { title: "Exam Management" },
                { title: "Employee Exam Marks Entry", active: true }
            ],
            pageTitle: "Employee Exam Marks Entry"
        }
    },



    // {
    //     name: "site-payment-gateway-settings-master-component",
    //     path: "/site/payment-gateway-settings",
    //     component: () =>
    //         import("@/components/site/fee/fee-collection-api/feeApiMasterComponent"),
    //     meta: {
    //         breadcrumb: [
    //             { title: "Fee Management" },
    //             { title: "Fee Api Settings", active: true }
    //         ],
    //         pageTitle: "Fee Api Settings"
    //     }
    // },

    {
        name: "site-fee-setting-master-component",
        path: "/site/fee/settings",
        component: () =>
            import("@/components/site/fee/feeSettingMasterComponent"),
        meta: {
            breadcrumb: [
                { title: "Fee Management" },
                { title: "Fee Settings", active: true }
            ],
            pageTitle: "Fee Settings"
        }
    },
    {
        name: "site-fee-collection-master-component",
        path: "/site/fee/student-payment/view",
        component: () =>
            import("@/components/site/fee/feeCollectionMasterComponent"),
        meta: {
            breadcrumb: [
                { title: "Fee Management" },
                { title: "Fee Collection" },
                { title: "Student Payment", active: true }
            ],
            pageTitle: "Student Payment"
        }
    },
    {
        name: "site-student-payment-report-master-component",
        path: "/site/fee/student-payment-report/view",
        component: () =>
            import("@/components/site/fee-report/SiteFeeReportMasterComponent"),
        meta: {
            breadcrumb: [
                { title: "Fee Management" },
                { title: "Fee report" },
                { title: "Payment report", active: true }
            ],
            pageTitle: "Payment report"
        }
    },
    {
        name: "site-fee-cancelation-master-component",
        path: "/site/fee/student-payment/fee-cancel-view",
        component: () =>
            import(
                "@/components/site/fee-cancellation/feeCancellationMasterComponent"
            ),
        meta: {
            breadcrumb: [
                { title: "Fee Management" },
                { title: "Fee Cancel", active: true }
            ],
            pageTitle: "Fee Cancel"
        }
    },
    {
        name: "admin-leave-master-component",
        path: "/site/employee-leave/index",
        component: () =>
            import("@/components/site/EmployeeLeave/adminLeaveMasterComponent"),
        meta: {
            breadcrumb: [
                { title: "Leave Management", url: "/" },
                { title: "Employee Leave Setting", active: true }
            ],
            pageTitle: "Employee Leave Setting"
        }
    },
    {
        name: "admin-leave-approve-master-component",
        path: "/site/employee-leave/leave-approve",
        component: () =>
            import(
                "@/components/site/EmployeeLeave/adminLeaveApproveMasterComponent"
            ),
        meta: {
            breadcrumb: [
                { title: "Leave Management", url: "/" },
                { title: "Employee Leave Approve", active: true }
            ],
            pageTitle: "Employee Leave Approve"
        }
    },
    {
        name: "employee-leave-history-master-component",
        path: "/site/employee-leave-history/index",
        component: () =>
            import(
                "@/components/site/EmployeeLeave/employeeLeaveMasterComponent"
            ),
        meta: {
            breadcrumb: [
                { title: "Leave Management", url: "/" },
                { title: "Employee Individual Leave", active: true }
            ],
            pageTitle: "Employee Individual Leave"
        }
    },
    {
        name: "admin-duty-approve-master-component",
        path: "/site/employee-duty/duty-master",
        component: () =>
            import(
                "@/components/site/employee-duty/AdminDutyApproveMasterComponent"
            ),
        meta: {
            breadcrumb: [
                { title: "Leave Management", url: "/" },
                { title: "Employee Leave Approve", active: true }
            ],
            pageTitle: "Employee Leave Approve"
        }
    },
    {
        name: "student-remote-registration-master",
        path:
            "/site/student-registration/site-base-student-registration-declare-form",
        component: () =>
            import("@/components/site/student-registration/MasterComponent"),
        meta: {
            breadcrumb: [
                { title: "Remote Registration" },
                { title: "Registration Declare", active: true }
            ],
            pageTitle: "Registration Declare"
        }
    },
    {
        name: "emp-exam-seat-plan-attendance-master-component",
        path:
            "/site/employee-panel/seat-plan-attendance/employee-exam-seat-plan-attendance-form",
        component: () =>
            import(
                "@/components/site/employee-panel/exam/SeatPlanAttendanceMasterComponent"
            ),
        meta: {
            breadcrumb: [
                { title: "Exam Management", url: "/" },
                { title: "Seat Plan & Attendance", active: true }
            ],
            pageTitle: "Seat Plan & Attendance"
        }
    },
    {
        name: "asset-master-component",
        path: "/building/building-floor-room-form",
        component: () => import("@/components/site/asset/AssetMasterComponent"),
        meta: {
            breadcrumb: [
                { title: "Asset Management" },
                { title: "Asset Settings" },
                { title: "Building Floor Room", active: true }
            ],
            pageTitle: "Asset Master"
        }
    },
    {
        name: "site-floor-component",
        path: "/floor/view",
        component: () => import("@/components/site/asset/SiteFloorComponent"),
        meta: {
            breadcrumb: [
                { title: "Asset Management" },
                { title: "Asset Settings" },
                { title: "Floor", active: true }
            ],
            pageTitle: "Floor"
        }
    },

    {
        name: "site-room-component",
        path: "/room/view",
        component: () => import("@/components/site/asset/SiteRoomComponent"),
        meta: {
            breadcrumb: [
                { title: "Asset Management" },
                { title: "Asset Settings" },
                { title: "Room", active: true }
            ],
            pageTitle: "Room"
        }
    },

    {
        name: "site-certification-letter-form",
        path: "/site/certification/site-certification-letter-form",
        component: () =>
            import(
                "@/components/site/result/certification/CertificationMasterComponent"
            ),
        meta: {
            breadcrumb: [
                { title: "Result Management", url: "/" },
                { title: "certification", active: true }
            ],
            pageTitle: "certification"
        }
    },

    {
        name: "site-protyonpotro-form",
        path: "/site/protyonpotro/site-protyonpotro-form",
        component: () =>
            import(
                "@/components/site/result/protyonpotro/ProtyonpotroMasterComponent"
            ),
        meta: {
            breadcrumb: [
                { title: "Result Management", url: "/" },
                { title: "Protyonpotro", active: true }
            ],
            pageTitle: "Protyonpotro"
        }
    },

    {
        name: "testimonial-master-component",
        path: "/site/testimonial/site-testimonial-form",
        component: () =>
            import(
                "@/components/site/result/testimonial/TestimonialMasterComponent"
            ),
        meta: {
            breadcrumb: [
                { title: "Result Management", url: "/" },
                { title: "Testimonial", active: true }
            ],
            pageTitle: "Testimonial"
        }
    },


    {
        name: "admit-card-master-component",
        path: "/site/admit-card/site-admit-card-form",
        component: () =>
            import(
                "@/components/site/exam/admit-card/AdmitCardMasterComponent"
            ),
        meta: {
            breadcrumb: [
                { title: "Exam Management", url: "/" },
                { title: "Admit Card or Attendance Sheet", active: true }
            ],
            pageTitle: "Admit Card or Attendance Sheet"
        }
    },

    {
        name: "site-student-quick-update-master-component",
        path: "/site/student/quick-update/site-student-quick-update-master",
        component: () =>
            import(
                "@/components/site/student/quick-update/SiteStudentQuickUpdateMasterComponent"
            ),
        meta: {
            breadcrumb: [
                { title: "Form", url: "/" },
                { title: "Student Update", active: true }
            ],
            pageTitle: "Quiz Update Master"
        }
    },

    {
        name: "site-student-manual-count-component",
        path: "/site/student/manual/site-student-manual-count",
        component: () =>
            import(
                "@/components/site/student/manual/SiteStudentManualCount"
            ),
        meta: {
            breadcrumb: [
                { title: "Form", url: "/" },
                { title: "Student Update", active: true }
            ],
            pageTitle: "Quiz Update Master"
        }
    },

    // quiz report start
    {
        name: "quiz-report",
        path: "/site/quiz-report",
        component: () => import("@/components/site/quiz/report/QuizReportMasterComponent"),
        meta: {
            breadcrumb: [
                { title: "Quiz", active: true },
            ],
            pageTitle: "Quiz"
        }
    },
    // quiz report end



    {
        name: "site-class-lesson-list",
        path: "/api/site/web/setting/classroom/class-lesson-view",
        component: () =>
            import("@/components/site/ClassRoom/ClassLessonListComponent"),
        meta: {
            breadcrumb: [
                { title: "Class Room" },
                { title: "Class Lesson List", active: true }
            ],
            pageTitle: "Class Lesson List"
        }
    },
    {
        name: "site-class-lesson-new",
        path: "/api/site/web/setting/classroom/class-lesson/new",
        component: () =>
            import("@/components/site/ClassRoom/ClassLessonComponent"),
        meta: {
            breadcrumb: [
                { title: "Class Room" },
                { title: "Class Lesson", active: true }
            ],
            pageTitle: "Class Lesson"
        }
    },
    {
        name: "site-class-lesson-edit",
        path:
            "/api/site/web/setting/classroom/class-lesson/edit/:classlessonId",
        props: true,
        component: () =>
            import("@/components/site/ClassRoom/ClassLessonComponent"),
        meta: {
            breadcrumb: [
                { title: "Class Room" },
                { title: "Class Lesson Edit", active: true }
            ],
            pageTitle: "Class Lesson Edit"
        }
    },
    {
        name: "site-tc-master-component",
        path: "/site/student/tc/tc-master-form",
        props: true,
        component: () => import("@/components/site/student/tc/MasterComponent"),
        meta: {
            breadcrumb: [
                { title: "TC" },
                { title: "Transfer Certificate", active: true }
            ],
            pageTitle: "Transfer Certificate"
        }
    },
    {
        name: "site-attestation-master-component",
        path: "/site/student/attestation/attestation-master-form",
        props: true,
        component: () => import("@/components/site/student/attestation/MasterComponent"),
        meta: {
            breadcrumb: [
                { title: "TC" },
                { title: "Transfer Certificate", active: true }
            ],
            pageTitle: "Transfer Certificate"
        }
    },
    {
        name: "site-library-books",
        path:
            "/site/library/site-library-books",
        props: true,
        component: () =>
            import(
                "@/components/site/library/LibraryIndexComponent"
            ),
        meta: {
            breadcrumb: [
                { title: "Library" },
                { title: "Library Books", active: true }
            ],
            pageTitle: "Library Books"
        }
    },

    {
        name: "site-library-borrowings-manage",
        path:
            "/site/library/site-library-borrowings-manage",
        props: true,
        component: () =>
            import(
                "@/components/site/library/BorrowingsManageComponent"
            ),
        meta: {
            breadcrumb: [
                { title: "Library" },
                { title: "Library borrowings-manage", active: true }
            ],
            pageTitle: "Library borrowings-manage"
        }
    },

    {
        name: "site-library-recks",
        path:
            "/site/library/site-library-recks",
        props: true,
        component: () =>
            import(
                "@/components/site/library/ReckIndexComponent"
            ),
        meta: {
            breadcrumb: [
                { title: "Library" },
                { title: "Library recks", active: true }
            ],
            pageTitle: "Library recks"
        }
    },
    {
        name: "site-library-members",
        path:
            "/site/library/site-library-members",
        props: true,
        component: () =>
            import(
                "@/components/site/library/MembersIndexComponent"
            ),
        meta: {
            breadcrumb: [
                { title: "Library" },
                { title: "Library members", active: true }
            ],
            pageTitle: "Library members"
        }
    },
    {
        name: "site-library-authors",
        path:
            "/site/library/site-library-authors",
        props: true,
        component: () =>
            import(
                "@/components/site/library/AuthorsIndexComponent"
            ),
        meta: {
            breadcrumb: [
                { title: "Library" },
                { title: "Library authors", active: true }
            ],
            pageTitle: "Library Authors"
        }
    },

    {
        name: "site-job-application",
        path:
            "/site/job-application/site-job-application",
        props: true,
        component: () =>
            import(
                "@/components/site/jobapplication/JobApplicationComponent"
            ),
        meta: {
            breadcrumb: [
                { title: "job application" },
                { title: "job application", active: true }
            ],
            pageTitle: "job application"
        }
    },



    {
        name: "student-admission-master-component",
        path:
            "/site/student-admission/site-base-student-admission-declare-form",
        props: true,
        component: () =>
            import(
                "@/components/site/student-admission/StudentAdmissionMasterComponent"
            ),
        meta: {
            breadcrumb: [
                { title: "Remote Admission" },
                { title: "Admission", active: true }
            ],
            pageTitle: "Remote Admission"
        }
    },
    {
        name: "admission-lottery-result-component",
        path: "/site/lottery-result/site-admission-lottery-result-form",
        props: true,
        component: () =>
            import(
                "@/components/site/student-admission/AdmissionLotteryResultComponent"
            ),
        meta: {
            breadcrumb: [
                { title: "Admission Lottery" },
                { title: "Lottery Result", active: true }
            ],
            pageTitle: "Admission Lottery"
        }
    },
    {
        name: "student-admission-inside-form",
        path: "/site/student-admission/site-student-admission-inside-form",
        props: true,
        component: () =>
            import(
                "@/components/site/student-admission/StudentAdmissionInsideFormComponent"
            ),
        meta: {
            breadcrumb: [
                { title: "Remote Admission" },
                { title: "Admission", active: true }
            ],
            pageTitle: "Remote Admission"
        }
    },

    {
        name: "site-accounts-setting-master-component",
        path: "/site/accounts",
        props: true,
        component: () =>
            import(
                "@/components/site/accounts/accountsSetting/accountsSettingMasterComponent"
            ),
        meta: {
            breadcrumb: [
                { title: "Accounts Management" },
                { title: "Accounts Setting" },
                { title: "Accounts Ledger", active: true }
            ],
            pageTitle: "Accounts Ledger"
        },
        children: [
            {
                name: "site-accounts-ledger-component",
                path: "accounts-ledger/view",
                props: true,
                component: () =>
                    import(
                        "@/components/site/accounts/accountsSetting/accountsLedgerComponent"
                    ),
                meta: {
                    breadcrumb: [
                        { title: "Accounts Management" },
                        { title: "Accounts Setting" },
                        { title: "Accounts Ledger", active: true }
                    ],
                    pageTitle: "Accounts Ledger"
                }
            },
            {
                name: "site-accounts-sub-group-component",
                path: "accounts-sub-group/view",
                props: true,
                component: () =>
                    import(
                        "@/components/site/accounts/accountsSetting/accountsSubGroupComponent"
                    ),
                meta: {
                    breadcrumb: [
                        { title: "Accounts Management" },
                        { title: "Accounts Setting" },
                        { title: "Accounts Sub Group", active: true }
                    ],
                    pageTitle: "Accounts Sub Group"
                }
            },
            {
                name: "site-accounts-group-component",
                path: "accounts-group/view",
                props: true,
                component: () =>
                    import(
                        "@/components/site/accounts/accountsSetting/accountsGroupComponent"
                    ),
                meta: {
                    breadcrumb: [
                        { title: "Accounts Management" },
                        { title: "Accounts Setting" },
                        { title: "Accounts Group", active: true }
                    ],
                    pageTitle: "Accounts Group"
                }
            },
            {
                name: "site-accounts-bank-component",
                path: "bank/view",
                props: true,
                component: () =>
                    import(
                        "@/components/site/accounts/accountsSetting/accountsBankComponent"
                    ),
                meta: {
                    breadcrumb: [
                        { title: "Accounts Management" },
                        { title: "Accounts Setting" },
                        { title: "Bank", active: true }
                    ],
                    pageTitle: "Bank"
                }
            },
            {
                name: "site-accounts-party-component",
                path: "party/view",
                props: true,
                component: () =>
                    import(
                        "@/components/site/accounts/accountsSetting/accountsPartyComponent"
                    ),
                meta: {
                    breadcrumb: [
                        { title: "Accounts Management" },
                        { title: "Accounts Setting" },
                        { title: "Party", active: true }
                    ],
                    pageTitle: "Party"
                }
            },
            {
                name: "site-accounts-cheque-register-component",
                path: "cheque-register/view",
                props: true,
                component: () =>
                    import(
                        "@/components/site/accounts/accountsSetting/accountsChequeRegisterComponent"
                    ),
                meta: {
                    breadcrumb: [
                        { title: "Accounts Management" },
                        { title: "Accounts Setting" },
                        { title: "Cheque Register", active: true }
                    ],
                    pageTitle: "Cheque Register"
                }
            }
        ]
    },
    {
        name: "site-accounts-transaction-master-component",
        path: "/site/accounts/accounts-transaction/",
        props: true,
        component: () =>
            import(
                "@/components/site/accounts/accountsTransaction/accountsTransactionMasterComponent"
            ),
        meta: {
            breadcrumb: [
                { title: "Accounts Management" },
                { title: "Accounts Transaction", active: true }
            ],
            pageTitle: "Accounts Transaction"
        },
        children: [
            {
                name:
                    "site-accounts-accounts-transaction-debit-voucher-component",
                path: "debit-voucher/view",
                props: true,
                component: () =>
                    import(
                        "@/components/site/accounts/accountsTransaction/accountsDebitVoucherComponent"
                    ),
                meta: {
                    breadcrumb: [
                        { title: "Accounts Management" },
                        { title: "Accounts Transaction" },
                        { title: "Debit Voucher", active: true }
                    ],
                    pageTitle: "Debit Voucher"
                }
            },
            {
                name:
                    "site-accounts-accounts-transaction-debit-voucher-list-component",
                path: "debit-voucher/list-view",
                props: true,
                component: () =>
                    import(
                        "@/components/site/accounts/accountsTransaction/voucherList/accountsDebitVoucherListComponent"
                    ),
                meta: {
                    breadcrumb: [
                        { title: "Accounts Management" },
                        { title: "Accounts Transaction" },
                        { title: "Debit Voucher List", active: true }
                    ],
                    pageTitle: "Debit Voucher List"
                }
            },
            {
                name: "site-accounts-accounts-transaction-debit-voucher-edit",
                path: "debit-voucher/edit/:voucherId",
                props: true,
                component: () =>
                    import(
                        "@/components/site/accounts/accountsTransaction/accountsDebitVoucherComponent"
                    ),
                meta: {
                    breadcrumb: [
                        { title: "Accounts Management" },
                        { title: "Accounts Transaction" },
                        { title: "Debit Voucher Edit", active: true }
                    ],
                    pageTitle: "Debit Voucher Edit"
                }
            },
            {
                name:
                    "site-accounts-accounts-transaction-credit-voucher-component",
                path: "credit-voucher/view",
                props: true,
                component: () =>
                    import(
                        "@/components/site/accounts/accountsTransaction/accountsCreditVoucherComponent"
                    ),
                meta: {
                    breadcrumb: [
                        { title: "Accounts Management" },
                        { title: "Accounts Transaction" },
                        { title: "Credit Voucher", active: true }
                    ],
                    pageTitle: "Credit Voucher"
                }
            },
            {
                name:
                    "site-accounts-accounts-transaction-credit-voucher-list-component",
                path: "credit-voucher/list-view",
                props: true,
                component: () =>
                    import(
                        "@/components/site/accounts/accountsTransaction/voucherList/accountsCreditVoucherListComponent"
                    ),
                meta: {
                    breadcrumb: [
                        { title: "Accounts Management" },
                        { title: "Accounts Transaction" },
                        { title: "Credit Voucher List", active: true }
                    ],
                    pageTitle: "Credit Voucher List"
                }
            },
            {
                name: "site-accounts-accounts-transaction-credit-voucher-edit",
                path: "credit-voucher/edit/:voucherId",
                props: true,
                component: () =>
                    import(
                        "@/components/site/accounts/accountsTransaction/accountsCreditVoucherComponent"
                    ),
                meta: {
                    breadcrumb: [
                        { title: "Accounts Management" },
                        { title: "Accounts Transaction" },
                        { title: "Credit Voucher Edit", active: true }
                    ],
                    pageTitle: "Credit Voucher Edit"
                }
            },
            {
                name:
                    "site-accounts-accounts-transaction-journal-voucher-component",
                path: "journal-voucher/view",
                props: true,
                component: () =>
                    import(
                        "@/components/site/accounts/accountsTransaction/accountsJournalVoucherComponent"
                    ),
                meta: {
                    breadcrumb: [
                        { title: "Accounts Management" },
                        { title: "Accounts Transaction" },
                        { title: "Journal Voucher", active: true }
                    ],
                    pageTitle: "Journal Voucher"
                }
            },
            {
                name:
                    "site-accounts-accounts-transaction-journal-voucher-list-component",
                path: "journal-voucher/list-view",
                props: true,
                component: () =>
                    import(
                        "@/components/site/accounts/accountsTransaction/voucherList/accountsJournalVoucherListComponent"
                    ),
                meta: {
                    breadcrumb: [
                        { title: "Accounts Management" },
                        { title: "Accounts Transaction" },
                        { title: "Journal Voucher List", active: true }
                    ],
                    pageTitle: "Journal Voucher List"
                }
            },
            {
                name: "site-accounts-accounts-transaction-journal-voucher-edit",
                path: "journal-voucher/edit/:voucherId",
                props: true,
                component: () =>
                    import(
                        "@/components/site/accounts/accountsTransaction/accountsJournalVoucherComponent"
                    ),
                meta: {
                    breadcrumb: [
                        { title: "Accounts Management" },
                        { title: "Accounts Transaction" },
                        { title: "Journal Voucher Edit", active: true }
                    ],
                    pageTitle: "Journal Voucher Edit"
                }
            },
            {
                name:
                    "site-accounts-accounts-transaction-contra-voucher-component",
                path: "contra-voucher/view",
                props: true,
                component: () =>
                    import(
                        "@/components/site/accounts/accountsTransaction/accountsContraVoucherComponent"
                    ),
                meta: {
                    breadcrumb: [
                        { title: "Accounts Management" },
                        { title: "Accounts Transaction" },
                        { title: "Contra Voucher", active: true }
                    ],
                    pageTitle: "Contra Voucher"
                }
            },
            {
                name:
                    "site-accounts-accounts-transaction-contra-voucher-list-component",
                path: "contra-voucher/list-view",
                props: true,
                component: () =>
                    import(
                        "@/components/site/accounts/accountsTransaction/voucherList/accountsContraVoucherListComponent"
                    ),
                meta: {
                    breadcrumb: [
                        { title: "Accounts Management" },
                        { title: "Accounts Transaction" },
                        { title: "Contra Voucher List", active: true }
                    ],
                    pageTitle: "Contra Voucher List"
                }
            },
            {
                name: "site-accounts-accounts-transaction-contra-voucher-edit",
                path: "contra-voucher/edit/:voucherId",
                props: true,
                component: () =>
                    import(
                        "@/components/site/accounts/accountsTransaction/accountsContraVoucherComponent"
                    ),
                meta: {
                    breadcrumb: [
                        { title: "Accounts Management" },
                        { title: "Accounts Transaction" },
                        { title: "Contra Voucher Edit", active: true }
                    ],
                    pageTitle: "Contra Voucher Edit"
                }
            }
        ]
    },
    {
        name: "site-accounts-report-master-component",
        path: "/site/accounts/report/",
        props: true,
        component: () =>
            import(
                "@/components/site/accounts/accountsReport/accountsReportMasterComponent"
            ),
        meta: {
            breadcrumb: [
                { title: "Accounts Management" },
                { title: "Accounts report", active: true }
            ],
            pageTitle: "Accounts report"
        },
        children: [
            {
                name: "site-accounts-accounts-general-ledger-report-component",
                path: "general-ledger",
                props: true,
                component: () =>
                    import(
                        "@/components/site/accounts/accountsReport/accountsGeneralLedgerReportMasterComponent"
                    ),
                meta: {
                    breadcrumb: [
                        { title: "Accounts Management" },
                        { title: "Accounts report" },
                        { title: "General Ledger", active: true }
                    ],
                    pageTitle: "General Ledger"
                }
            },
            {
                name: "site-accounts-accounts-ledger-report-component",
                path: "ledger",
                props: true,
                component: () =>
                    import(
                        "@/components/site/accounts/accountsReport/accountsLedgerReportComponent"
                    ),
                meta: {
                    breadcrumb: [
                        { title: "Accounts Management" },
                        { title: "Accounts report" },
                        { title: "Ledger", active: true }
                    ],
                    pageTitle: "Ledger"
                }
            },
            {
                name: "site-accounts-trial-balance-report-component",
                path: "trial-balance",
                props: true,
                component: () =>
                    import(
                        "@/components/site/accounts/accountsReport/accountsTrialBalanceReportComponent"
                    ),
                meta: {
                    breadcrumb: [
                        { title: "Accounts Management" },
                        { title: "Accounts report" },
                        { title: "Trial Balance", active: true }
                    ],
                    pageTitle: "Trial Balance"
                }
            },
            {
                name: "site-accounts-finacial_statements-report-component",
                path: "financial-statements",
                props: true,
                component: () =>
                    import(
                        "@/components/site/accounts/accountsReport/accountsFinancialStatementsReportMasterComponent"
                    ),
                meta: {
                    breadcrumb: [
                        { title: "Accounts Management" },
                        { title: "Accounts report" },
                        { title: "Financial Statements", active: true }
                    ],
                    pageTitle: "Financial Statements"
                }
            },
            {
                name: "site-accounts-balance-sheet-report-component",
                path: "balance-sheet",
                props: true,
                component: () =>
                    import(
                        "@/components/site/accounts/accountsReport/accountsBalanceSheetReportComponent"
                    ),
                meta: {
                    breadcrumb: [
                        { title: "Accounts Management" },
                        { title: "Accounts report" },
                        { title: "Balance Sheet", active: true }
                    ],
                    pageTitle: "Balance Sheet"
                }
            },
            {
                name: "site-accounts-profit-loss-statements-report-component",
                path: "profit-loss-statements",
                props: true,
                component: () =>
                    import(
                        "@/components/site/accounts/accountsReport/accountsProfitLossStatementsReportComponent"
                    ),
                meta: {
                    breadcrumb: [
                        { title: "Accounts Management" },
                        { title: "Accounts report" },
                        { title: "Profit & Loss Statements", active: true }
                    ],
                    pageTitle: "Profit & Loss Statements"
                }
            }
        ]
    },

    {
        name: "emp-result-master-component",
        path: "/site/employee-panel/result/emp-exam-result-master-form",
        props: true,
        component: () =>
            import(
                "@/components/site/employee-panel/result/EmpResultMasterComponent"
            ),
        meta: {
            breadcrumb: [{ title: "Result", active: true }],
            pageTitle: "Result"
        }
    },

    {
        name: "student-result-master-component",
        path: "/student/result/master",
        props: true,
        component: () =>
            import(
                "@/components/site/studentPanel/result/StudentResultMasterComponent"
            ),
        meta: {
            breadcrumb: [{ title: "Result", active: true }],
            pageTitle: "Result"
        }
    },
    {
        name: "student-exam-master-component",
        path: "/student/exam/master",
        props: true,
        component: () =>
            import(
                "@/components/site/studentPanel/exam/StudentExamMasterComponent"
            ),
        meta: {
            breadcrumb: [{ title: "Exam", active: true }],
            pageTitle: "Exam"
        }
    },
    {
        name: "student-exam-start-component",
        path: "/student/exam/start/:siteExamDeclareStudentSubjectId",
        props: true,
        component: () =>
            import(
                "@/components/site/studentPanel/exam/StudentExamStartComponent"
            ),
        meta: {
            breadcrumb: [
                { title: "Exam Start" },
                { title: "Exam Start", active: true }
            ],
            pageTitle: "Exam Start"
        }
    },
    {
        name: "site-exam-question-declare-master",
        path: "/site/question-declare/site-exam-question-declare-form/",
        props: true,
        component: () =>
            import(
                "@/components/site/exam/question/SiteExamQuestionDeclareMasterComponent"
            ),
        meta: {
            breadcrumb: [
                { title: "Exam Management" },
                { title: "Exam Question Declare", active: true }
            ],
            pageTitle: "Exam Question Declare"
        }
    },
    {
        name: "site-exam-attendance-master-component",
        path: "/site/site-exam-attendance/site-exam-attendance-entry-form",
        props: true,
        component: () =>
            import(
                "@/components/site/exam/attendance/SiteExamAttendanceMasterComponent"
            ),
        meta: {
            breadcrumb: [
                { title: "Exam Attendance" },
                { title: "Exam Attendance", active: true }
            ],
            pageTitle: "Exam Attendance"
        }
    },
    {
        name: "batch-details-component",
        path: "/site/batch/site-batch-form",
        component: () =>
            import("@/components/site/batch/BatchDetailsComponent"),
        meta: {
            breadcrumb: [{ title: "Batch" }, { title: "Batch", active: true }],
            pageTitle: "Batch"
        }
    },
    {
        name: "student-edu-transaction-component",
        path: "/student/transaction/master",
        component: () =>
            import(
                "@/components/site/studentPanel/transaction/StudentTransactionMasterComponent"
            ),
        meta: {
            breadcrumb: [
                { title: "Transaction" },
                { title: "Transaction", active: true }
            ],
            pageTitle: "Transaction"
        }
    },

    {
        name: "payment-gateway-component",
        path: "/site/payment-gateway/view",
        component: () =>
            import("@/components/site/paymentGateway/paymentGatewayComponent"),
        meta: {
            breadcrumb: [
                { title: "Settings" },
                { title: "Payment Gateway", active: true }
            ],
            pageTitle: "Payment Gateway"
        }
    },
    {
        name: "student-payment-report-master-component",
        path: "/site/student/report/payment-master",
        component: () =>
            import(
                "@/components/site/student/paymentReport/StudentPaymentReportMasterComponent"
            ),
        meta: {
            breadcrumb: [
                { title: "My Payment" },
                { title: "Payment Report", active: true }
            ],
            pageTitle: "Payment Report"
        },
        children: [
            {
                name: "student-payment-report-component",
                path: "/site/student/report/general-payment-report-view",
                component: () =>
                    import(
                        "@/components/site/student/paymentReport/StudentPaymentReportComponent"
                    ),
                meta: {
                    breadcrumb: [
                        { title: "My Payment" },
                        { title: "Payment Report" },
                        { title: "General Report", active: true }
                    ],
                    pageTitle: "General Report"
                }
            },
            {
                name: "student-financial-statement-component",
                path: "/site/student/report/financial-statement-view",
                component: () =>
                    import(
                        "@/components/site/student/paymentReport/StudentFinancialStatementComponent"
                    ),
                meta: {
                    breadcrumb: [
                        { title: "My Payment" },
                        { title: "Payment Report" },
                        { title: "Financial Statement", active: true }
                    ],
                    pageTitle: "Financial Statement"
                }
            }
        ]
    },
    {
        name: "site-help-desk-show-component",
        path: "/site/help-desk/view",
        component: () =>
            import("@/components/site/help-desk/SiteHelpDeskShowComponent"),
        meta: {
            breadcrumb: [
                { title: "Help Desk" },
                { title: "Help Desk", active: true }
            ],
            pageTitle: "Help Desk"
        }
    }
];
