import JwtService from "@/service/jwt.service";


const state = {
  errors: null,
  user: {},
  token: "",
  isAuthenticated: !!JwtService.getToken()
};

const getters = {
  currentUser(state) {
    return state.user;
  },
  isAuthenticated(state) {
    return state.isAuthenticated;
  }
};

const actions = {
  loginSuccess({ commit }, data) {
    commit('SET_AUTH', data.data);

  },
  LOGOUT(context) {
    context.commit('PURGE_AUTH');
  },
  REGISTER(context, credentials) {
    return new Promise((resolve, reject) => {
      ApiService.post("users", { user: credentials })
        .then(({ data }) => {
          context.commit(SET_AUTH, data.user);
          resolve(data);
        })
        .catch(({ response }) => {
          context.commit(SET_ERROR, response.data.errors);
          reject(response);
        });
    });
  },
  CHECK_AUTH(context) {
    if (JwtService.getToken()) {
      ApiService.setHeader();
      ApiService.get("user")
        .then(({ data }) => {
          context.commit(SET_AUTH, data.user);
        })
        .catch(({ response }) => {
          context.commit(SET_ERROR, response.data.errors);
        });
    } else {
      context.commit(PURGE_AUTH);
    }
  },
  UPDATE_USER(context, payload) {
    const { email, username, password, image, bio } = payload;
    const user = {
      email,
      username,
      bio,
      image
    };
    if (password) {
      user.password = password;
    }

    return ApiService.put("user", user).then(({ data }) => {
      context.commit(SET_AUTH, data.user);
      return data;
    });
  }
};

const mutations = {
  SET_ERROR(state, error) {
    state.errors = error;
  },
  SET_AUTH(state, data) {
    state.isAuthenticated = true;
    state.user = data.user;
    state.token = data.token;
    state.errors = {};
    JwtService.saveToken(state.token);
  },
  PURGE_AUTH(state) {
    state.isAuthenticated = false;
    state.user = {};
    state.token="";
    state.errors = {};
    JwtService.destroyToken();
  }
};

export default {
  namespaced: true,
  state,
  actions,
  mutations,
  getters
};
