/**
 * Automatically imports all the modules and exports as a single module object
 * https://dev.to/localeai/architecting-vuex-store-for-large-scale-vue-js-applications-4f1f
 * https://stackoverflow.com/questions/49548622/vuex-empty-state-on-logout
 */
const requireModule = require.context('.', false, /\.store\.js$/);
const modules = {};

requireModule.keys().forEach(filename => {

    // create the module name from fileName
    // remove the store.js extension and capitalize
    const moduleName = filename
        .replace(/(\.\/|\.store\.js)/g, '')
        .replace(/^\w/, c => c.toUpperCase()) 

    modules[moduleName] = requireModule(filename).default || requireModule(filename);
});

export default modules;
