/*=========================================================================================
  File Name: state.js
  Description: Vuex Store - state
==========================================================================================*/

// /////////////////////////////////////////////
// Helper
// /////////////////////////////////////////////

// *From Auth - Data will be received from auth provider
const userDefaults = {
    ALIAS: "",
    USER_TYPE: "",
    SITE_NAME: "",
    SITE_ID: "",
    LOGO_PATH: "",
    SITE_EMAIL: "",
    SITE_PHONE: "",
    webTittle: "",
    site_address: "",
    id: 0, // From Auth
    fullName: null, // From Auth
    about: "",
    photoURL: require("../../../public/uploads/image-not.png"), // From Auth
    status: "online",
    userRole: null
};

//const userInfoLocalStorage = JSON.parse(localStorage.getItem("userInfo")) || {};
const userInfoLocalStorage = JSON.parse(localStorage.getItem("userInfo")) || {};

// Set default values for active-user
// More data can be added by auth provider or other plugins/packages
const getUserInfo = () => {
    const userInfo = {};

    // Update property in user
    Object.keys(userDefaults).forEach(key => {
        // If property is defined in localStorage => Use that
        userInfo[key] = userInfoLocalStorage[key]
            ? userInfoLocalStorage[key]
            : userDefaults[key];
    });

    // Include properties from localStorage
    Object.keys(userInfoLocalStorage).forEach(key => {
        if (userInfo[key] === undefined && userInfoLocalStorage[key] !== null)
            userInfo[key] = userInfoLocalStorage[key];
    });

    return userInfo;
};

const getCurrentDate = () => {
    var today = new Date();
    var dd = String(today.getDate()).padStart(2, "0");
    var mm = String(today.getMonth() + 1).padStart(2, "0"); //January is 0!
    var yyyy = today.getFullYear();

    today = yyyy + "-" + mm + "-" + dd;

    return today;
};
const getWeekAgoDate = () => {
    //Change it so that it is 7 days in the past.
    var week_ago = new Date();
    var pastDate = week_ago.getDate() - 7;
    week_ago.setDate(pastDate);

    var dd1 = String(week_ago.getDate()).padStart(2, "0");
    var mm1 = String(week_ago.getMonth() + 1).padStart(2, "0"); //January is 0!
    var yyyy1 = week_ago.getFullYear();

    var week_ago_date = yyyy1 + "-" + mm1 + "-" + dd1;

    //Log the date to our web console.
    // console.log("week_past: " + week_ago_date);

    return week_ago_date;
};
const getMonthAgoDate = () => {
    //Change it so that it is 7 days in the past.
    var week_ago = new Date();
    var pastDate = week_ago.getDate() - 30;
    week_ago.setDate(pastDate);

    var dd1 = String(week_ago.getDate()).padStart(2, "0");
    var mm1 = String(week_ago.getMonth() + 1).padStart(2, "0"); //January is 0!
    var yyyy1 = week_ago.getFullYear();

    var week_ago_date = yyyy1 + "-" + mm1 + "-" + dd1;

    //Log the date to our web console.
    // console.log("week_past: " + week_ago_date);

    return week_ago_date;
};

// /////////////////////////////////////////////
// State
// /////////////////////////////////////////////

const state = {
    tabNumber: 1,
    alias: "",

    AppActiveUser: getUserInfo(),
    theme: "light",
    currentDate: getCurrentDate(),
    weekAgoDate: getWeekAgoDate(),
    monthAgoDate: getMonthAgoDate()
};

export default state;
