@extends('layouts.forgot-pass')
@section('message', trans('auth.reset_password'))

@section('content')

    <div class="login-box">
        <div class="login-box-body">
            <div class="login-logo">
                @if(Session::get('USER_TYPE') == 'eduworld')
                    <img class="logo-image-transparent" width="160" src="{!! asset('image/edu.png') !!}"/>
                @else
                    <img class="logo-image-transparent" width="70" src="{!! asset(Session::get('LOGO_PATH')) !!}">
                @endif
            </div>

            <p style="font-size: 17px" class="text-center">{{Session::get('FULL_NAME')}}</p>

            <p class="login-box-msg"></p>
            @if (count($errors) > 0)
                <div class="alert alert-danger">
                    @foreach ($errors->all() as $error)
                        <i class="fa fa-warning"></i>   {{ $error }} <br>
                    @endforeach
                </div>
            @endif
            <form role="form" method="POST" action="{{ route('password.email') }}">
                {{ csrf_field() }}


                @if (session('status'))
                    <div class="alert alert-success" role="alert">
                        {{ session('status') }}
                    </div>
                @endif

                <div class="form-group has-feedback{{ $errors->has('email') ? ' has-error' : '' }}">
                    <input name="email" type="email" class="form-control" placeholder="{{ trans('auth.enter_email') }}"
                           required>
                    <span class="glyphicon glyphicon-envelope form-control-feedback"></span>
                    {{-- @if ($errors->has('email'))
                         <span class="help-block">
                         <strong>{{ $errors->first('email') }}</strong>
                     </span>
                     @endif--}}
                </div>


                <div class="row">
                    <!-- /.col -->

                    <div class="col-xs-6 col-sm-4">
                        <a href="{{route('login-form')}}" class="btn btn-success btn-block btn-flat"> <i
                                    class="fa fa-backward"></i> Login</a>
                    </div>


                    <div class="col-sm-4">
                    </div>

                    <div class="col-xs-6 col-sm-4">
                        <button type="submit"
                                class="btn btn-success btn-block btn-flat">{{ trans('general.send')}}</button>
                    </div>
                    <!-- /.col -->
                </div>
            </form>

        </div>
        <!-- /.login-box-body -->

        <div class="login-box-footer">
            <i>{{ trans('footer.powered') }}</i> <a href="{{ trans('footer.link') }}" target="_blank"> <b>Edu world</b>
            </a>
        </div>
        <!-- /.login-box-footer -->

    </div>
@endsection














{{--@extends('layouts.app')--}}

{{--@section('content')--}}
{{--<div class="container">--}}
{{--<div class="row justify-content-center">--}}
{{--<div class="col-md-8">--}}
{{--<div class="card">--}}
{{--<div class="card-header">{{ __('Reset Password') }}</div>--}}

{{--<div class="card-body">--}}
{{--@if (session('status'))--}}
{{--<div class="alert alert-success" role="alert">--}}
{{--{{ session('status') }}--}}
{{--</div>--}}
{{--@endif--}}

{{--<form method="POST" action="{{ route('password.email') }}">--}}
{{--@csrf--}}

{{--<div class="form-group row">--}}
{{--<label for="email" class="col-md-4 col-form-label text-md-right">{{ __('E-Mail Address') }}</label>--}}

{{--<div class="col-md-6">--}}
{{--<input id="email" type="email" class="form-control{{ $errors->has('email') ? ' is-invalid' : '' }}" name="email" value="{{ old('email') }}" required>--}}

{{--@if ($errors->has('email'))--}}
{{--<span class="invalid-feedback" role="alert">--}}
{{--<strong>{{ $errors->first('email') }}</strong>--}}
{{--</span>--}}
{{--@endif--}}
{{--</div>--}}
{{--</div>--}}

{{--<div class="form-group row mb-0">--}}
{{--<div class="col-md-6 offset-md-4">--}}
{{--<button type="submit" class="btn btn-primary">--}}
{{--{{ __('Send Password Reset Link') }}--}}
{{--</button>--}}
{{--</div>--}}
{{--</div>--}}
{{--</form>--}}
{{--</div>--}}
{{--</div>--}}
{{--</div>--}}
{{--</div>--}}
{{--</div>--}}
{{--@endsection--}}
