<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no'
          name='viewport'>

    <title>{{$page_tittle}}</title>

    <style>

        @font-face {
            font-family: 'Verdana';
            font-weight: 100;
            font-style: normal;
            font-variant: normal;
            src: url("{{public_path()}}/fonts/Verdana.ttf") format("truetype");
        }

        body {
            font-family: "Verdana", sans-serif;
            font-size: 12px;
        }

        .st-image {
            text-align: center;
            width: 57px;
            height: 55px;
            border-radius: 10px;
            border: 1px solid #0b0b0b;
        }

        .txt-left {
            text-align: left;
        }

        .page-break {
            page-break-after: always;
        }

        .bg-image {
            background-image: url({{asset("/img/site/idcard/background-1.png")}});
            background-position: center;
            background-size: 100% 100%;
            background-repeat: no-repeat;
        }

        .site-logo {
            background: transparent;
        }

    </style>

</head>
<body>

{{--
@include('default.site.layout.pdf-header')


--}}


@foreach($att_data as $key => $value)

    <div class="bg-image"
         style="width:209px; padding: 2px 5px; height:345px; border-radius: 5px; border: 1px solid #0b0b0b;margin-left:3px;float: left; overflow: hidden">

        <table class="data-table" cellspacing="0" border="0" width="100%;">

            <tbody>
            <tr>
                <td style="width: 100%;text-align: center">
                    <img class="site-logo" style="text-align: center" width="50"
                         src="{!! asset(Session::get('LOGO_PATH')) !!}">
                </td>
            </tr>
            <tr>
                <td style="width: 100%;text-align: center">
                    <span style="font-size: 12px; text-transform:capitalize;font-weight: bold">{{Session::get('FULL_NAME')}}</span>
                </td>
            </tr>
            <tr>
                <td style="width: 100%;text-align: center">

                    @if(file_exists(public_path("uploads").'/'.$value['student']['latest_photo']['name']))
                        <img class="st-image"
                             src="{{asset("uploads").'/'.$value['student']['latest_photo']['name']  ?? 'image-not.png'}}">
                    @else
                        <img class="st-image"
                             src="{{asset("uploads").'/image-not.png'}}">
                    @endif

                </td>
            </tr>

            <tr>
                <td style="width: 100%;text-align: center">
                    <span style="text-transform:uppercase;font-size: 12px; font-weight: bold; color: #0b2c89"> {{$value['student']['full_name'] ?? '--'}} </span>
                </td>
            </tr>
            </tbody>
        </table>

        <table class="data-table" cellspacing="0" border="0" width="100%;" style="">

            <tbody>
            <tr>
                <th class="txt-left" style="width: 40%;">
                    <nobr> F. Name</nobr>
                </th>
                <td class="txt-left" style="width: 100%; font-size: 10px">
                    :{{$value['student']['father_name'] ??  '--'}}
                </td>
            </tr>

            <tr>
                <th class="txt-left">
                    <nobr> M. Name</nobr>
                </th>
                <td class="txt-left">
                    <nobr> :{{$value['student']['mother_name'] ?? '--'}}</nobr>
                </td>
            </tr>
            <tr>
                <th class="txt-left">
                    Shift
                </th>
                <td>
                    <nobr> :{{$value['shift']['shift_name'] ?? '--'}}</nobr>
                </td>
            </tr>
            <tr>
                <th class="txt-left">
                    Class
                </th>
                <td>
                    <nobr> :{{$value['st_class']['class_name'] ?? '--'}}</nobr>
                </td>
            </tr>


            @if($value['section'])
                <tr>
                    <th class="txt-left">
                        Section
                    </th>
                    <td>
                        <nobr> :{{$value['section']['section_name'] ?? '--'}}</nobr>
                    </td>
                </tr>
            @endif
            <tr>
                <th class="txt-left">
                    Roll
                </th>
                <td>
                    <nobr> :{{$value['student_roll_number'] ?? '--'}}</nobr>
                </td>
            </tr>

            @if($value['blood_group'])
                <tr>
                    <th class="txt-left">
                        B. Group
                    </th>
                    <td>
                        <nobr> :{{$value['blood_group']['blood_group_name'] ?? '--'}}</nobr>
                    </td>
                </tr>
            @endif


            <tr>
                <th class="txt-left">
                    DOB
                </th>
                <td>
                    <nobr>
                        :{{ date('d M Y', strtotime($value['student']['date_of_birth'] ?? '1970-12-16'))}}</nobr>
                </td>
            </tr>

            <tr>
                <th class="txt-left">
                    Mobile
                </th>
                <td>
                    <nobr> :{{$value['student']['contact_number'] ?? '--'}}</nobr>
                </td>
            </tr>
            </tbody>
        </table>

    </div>


    @if(($key+1) % 3== 0)
        <div style="clear:both;"></div>
    @endif


    @if(($key+1) % 9 == 0 )
        <div class="page-break"></div>
    @endif


@endforeach


</body>


<style>

    @page {
        size: a4;
        margin: 0px;

    }

    body {
        margin: 10px 35px 3px;
    }


</style>

</html>












