@extends('default.admin.layouts.master')

@section('style')
    {!! Html::style('css/styles.css') !!}
@endsection

@section('content')
    <div class="container-fluid min_height_area">
        <div class="row">
            <div class="col-md-12">
                <div class="view-header">
                    <section class="content-header">
                        <a  href="{!! route('class-add-form') !!}">
                            <i class="fa fa-plus"></i> {{ trans('sidebar.class-create') }}
                        </a>
                        <ol class="breadcrumb">
                            <li>
                                <span class="fa fa-dashboard" aria-hidden="true"></span>
                                <a href="{{route('admin')}}">{{ trans('translate.dashboard') }}</a></li>
                            <li class="active text-capitalize">{{ request()->route()->getName() }}</li>
                        </ol>
                    </section>
                </div>
            </div>
        </div>

        <div class="inner-box-1">

                @if (count($errors) > 0)
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif
                @if(session()->has('success'))
                    <div class="alert alert-success">
                        <ul>

                            <li>{{ session()->get('success') }}</li>

                        </ul>
                    </div>
                @endif
                    <div class="row">
                        <div class="col-md-12">
                        <div class="box-body">
                                    <table id="example1" class="table table-bordered table-striped">
                                        <thead>
                                        <tr>
                                           <th class="th_width_100"> {{ trans('translate.sl') }}</th>
                                            <th>{{ trans('translate.class_name') }}</th>
                                            <th>{{trans('translate.academic.class.group_present')}}</th>
                                            <th>{{ trans('translate.note') }}</th>
                                            <th> {{ trans('translate.status') }}</th>
                                            <th class="text-center th_width_80"> {{ trans('translate.action') }}</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @set('sl',1)

                                        @if(isset($classList) && !$classList->isEmpty())
                                            @foreach($classList as $class)
                                                <tr>
                                                    <td>{{ $sl++ }}</td>
                                                    <td>{{ $class->class_name ?? 'Not Available' }}</td>
                                                    <td>{{ getYesNo($class->academic_group_present) }}</td>
                                                    <td>{{ $class->note ?? 'Not Available' }}</td>
                                                    <td>{{ getActiveInactive($class->status)}}</td>
                                                    <td>
                                                        <a class="btn btn-success btn-xs mrg" data-original-title="Edit" data-toggle="tooltip" href="{{ route('class-edit-form',[$class->id]) }}"><i class="fa fa-edit"></i></a>
                                                        <a  class="btn btn-danger btn-xs delete_btn mrg"  onclick="return confirm('are you sure?')" data-original-title="Delete" data-toggle="tooltip" href="{{ route('class-delete', [$class->id]) }}"><i class="fa fa-trash-o"></i></a>
                                                    </td>
                                                </tr>
                                            @endforeach
                                        @else
                                            <tr>
                                                <td colspan="10">
                                                    Sorry !!! No Class Found........
                                                </td>
                                            </tr>
                                        @endif
                                        </tbody>
                                    </table>
                                    <div class="pagination">{!!   str_replace('/?','?',$classList->render() ) !!} </div>
                        </div>
                        </div>
                    </div> <!-- row last -->

            </div>
    </div>
@endsection
@section('scripts')

    @parent
    <script src="{{ asset('theme_components/admin/plugins/datatables/jquery.dataTables.min.js') }}"></script>
    {!! Html::script('theme_components/admin/plugins/datatables/dataTables.bootstrap.min.js') !!}

@endsection
