@extends('default.admin.layouts.master')

@section('style')
    {!! Html::style('css/styles.css') !!}
@endsection

@section('content')

    <div class="container-fluid min_height_area">
        <div class="row">
            <div class="col-md-12">
                <div class="student-box-header">
                    <div class="col-md-6 col-xs-5">
                        <span class="glyphicon glyphicon-user "
                              aria-hidden="true"></span>{{ trans('sidebar.division_list') }}
                    </div>
                    <div class="col-md-6 col-xs-7 snt">
                        <ul class="breadcrumb text-right">
                            <li>
                                <a href="{!! route('division-add-form') !!}"><i
                                            class="fa fa-plus"></i> {{ trans('sidebar.division-create') }}</a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div> <!--row-->
        <div class="row">
            <div class="col-md-12">
                <div class="view-header">
                    <button onclick="javascript:window.print()" class="btn btn-primary"><span
                                class="fa fa-print"></span> {{ trans('translate.print') }} </button>
                    <button onclick="javascript:window.print()" class="btn btn-primary"><span
                                class="fa fa-print"></span> {{ trans('translate.print_preview') }} </button>
                    <button class="btn btn-primary"><span class="fa fa-file"></span> {{ trans('translate.edit') }}
                    </button>
                </div>
            </div>
        </div> <!--row-->
        <div class="inner-box">
            <div class="row">
                <div id="datatable">
                    <div class="row last">
                        <div class="col-sm-12">


                            <div class="box">
                                @if (count($errors) > 0)
                                    <div class="alert alert-danger row">
                                        <ul>
                                            @foreach ($errors->all() as $error)
                                                <li>{{ $error }}</li>
                                            @endforeach
                                        </ul>
                                    </div>
                                @endif
                                @if(session()->has('success'))
                                    <div class="alert alert-success row">
                                        <ul>

                                            <li>{{ session()->get('success') }}</li>

                                        </ul>
                                    </div>
                                @endif

                                <div class="box-body auto_scroll">
                                    <table id="example1" class="table table-bordered table-striped">
                                        <thead>
                                        <tr>
                                            <th>{{ trans('translate.sl') }}</th>
                                            <th>{{ trans('sidebar.country_name') }}</th>
                                            <th>{{ trans('sidebar.division_name') }}</th>
                                            <th>{{ trans('sidebar.govt_code') }}</th>
                                            <th>{{ trans('translate.status') }}</th>
                                            <th style="width: 200px"
                                                class="text-center">{{ trans('translate.action') }}</th>
                                        </tr>
                                        </thead>
                                        <tbody>

                                        @set('sl',1)
                                        @foreach($divisionList as $division)


                                            <tr>
                                                <td>{{$sl++}}</td>
                                                <td>
                                                    {{$division->country->country_name?? '' }}
                                                </td>
                                                <td>
                                                    {{  $division->division_name ?? '' }}
                                                </td>
                                                <td>
                                                    {{  $division->govt_code ?? '' }}
                                                </td>
                                                <td>{{getActiveInactive($division->status) }}</td>
                                                <td>
                                                    <nobr>
                                                        <a class="btn btn-success btn-xs"
                                                           data-original-title="District"
                                                           data-toggle="tooltip"
                                                           target="_blank"
                                                           href="{{ route('district-add-form',[$division->id]) }}"> <i
                                                                    class="fa fa-creative-commons"></i> New District
                                                        </a>

                                                        <a class="btn btn-success btn-xs"
                                                           data-original-title="District"
                                                           data-toggle="tooltip"
                                                           target="_blank"

                                                           href="{{ route('district-list',[$division->id]) }}">

                                                            <i class="fa fa-file"></i> Districts
                                                            ({{$division->district->count() ?? 'n|a'}})
                                                        </a>
                                                        <a class="btn btn-success btn-xs"
                                                           data-original-title="{{ trans('translate.edit') }}"
                                                           data-toggle="tooltip"
                                                           href="{{ route('division-edit-form',[$division->id]) }}"><i
                                                                    class="fa fa-edit"></i></a>

                                                        <a class="btn btn-danger btn-xs delete_btn"
                                                           onclick="return confirm('Are you sure?')"
                                                           data-original-title="{{ trans('translate.delete') }}"
                                                           data-toggle="tooltip"
                                                           href="{{ route('division-delete',[$division->id]) }}"><i
                                                                    class="fa fa-trash-o"></i></a>


                                                    </nobr>
                                                </td>

                                            </tr>
                                        @endforeach

                                        </tbody>
                                    </table>
                                    <div class="pagination">{!!   str_replace('/?','?',$divisionList->render() ) !!} </div>
                                    {{--this function is described in the helper/formFunctionHelper.php page and the
                                    parameteres are provided from the relevant controller i.e UsersController in this case--}}
                                    {{--                                    {!! dataTableList($usersList,null,null,$model) !!}--}}
                                </div><!-- /.box-body -->
                            </div><!-- /.box -->
                        </div>
                    </div> <!--row last-->
                </div>
            </div>
        </div>
    </div>



@endsection
@section('scripts')

    @parent

@endsection