@extends('default.admin.layouts.master')


@section('style')
    {!! Html::style('css/styles.css') !!}
@endsection




@section('content')
    <div class="container-fluid" style="min-height: 1215px;">

        <div class="row">
            <div class="col-md-12">
                <div class="view-header">
                    <section class="content-header">
                        <ol class="breadcrumb">
                            <li>
                                <span class="fa fa-dashboard" aria-hidden="true"></span>
                                <a href="{{route('admin')}}">{{ trans('translate.dashboard') }}</a>
                            </li>
                            <li class="active text-capitalize">Sms Log</li>
                        </ol>
                    </section>
                </div>
            </div>
        </div> <!--row-->


        <div class="row">

                <div class="col-md-12">
                    <div class="box">
                        <div class="box-header with-border">
                            <h3 class="box-title"> <i class="fa fa-list"></i> SMS Log  For  {{ date('d F Y',strtotime($get_date))}} </h3>

                        </div>


                        <div class="box-body with-border">

                            <div class="table-responsive" style="overflow: auto">
                                    <table class="table table-bordered table-striped">
                                        <thead class="thead-bg">
                                        <tr>
                                            <td colspan="3">
                                                <form action="{{route('edu-device-log-device-log-view',[''])}}">
                                                    <input class="form-control" type="text" id="date" name="date" placeholder="Choose Log Date" />

                                                    <button class="btn btn-info btn-xs" type="submit">
                                                        Get Log
                                                    </button>

                                                </form>
                                            </td>

                                        <td colspan="10"></td>

                                        <thead class="thead-bg">
                                        <tr>
                                            <th>{{ trans('translate.sl') }}
                                            </th>
                                            <th>Msg Id</th>
                                            <th>Message Text</th>
                                            <th>Numbers</th>
                                            <th> Res. Status</th>
                                            <th>
                                                <nobr> Sms Count</nobr>
                                            </th>
                                            <th>Date</th>

                                            <th class="text-center th_width_80">
                                                {{ trans('translate.action') }}
                                            </th>

                                        </tr>
                                        </thead>
                                        <tbody>

                                        @set('sl',1)


                                        @foreach($data as $key =>  $item)


                                            <tr>
                                                <td>

                                                    {{ ($data->currentpage()-1) * $data->perpage() + $key + 1 }}

                                                </td>
                                                <td>
                                                    {{$item->res_msg_id}}
                                                </td>

                                                <td><nobr> {{ $item->msg_txt}} </nobr></td>
                                                <td>{{ $item->msg_numbers }}</td>
                                                <td>
                                                    {{$item->res_status}}
                                                </td>

                                                <td>  {{$item->res_sms_count}} </td>

                                                <td>
                                                    <nobr> {{date('d M Y h:i A', strtotime($item->created_at)) }} </nobr>
                                                </td>

                                                <td>

                                                    <a class="btn btn-success btn-xs mrg"
                                                       data-original-title="{{ trans('translate.edit') }}"
                                                       data-toggle="tooltip"
                                                       href="#"><i
                                                            class="fa fa-edit"></i>

                                                    </a>

                                                    {{--   <a class="btn btn-danger  btn-xs mrg"
                                                          data-original-title="{{ trans('translate.delete') }}"
                                                          onclick="return confirm('Are you sure?')"
                                                          data-toggle="tooltip"
                                                          href="{{ route('menu-delete',[$item->id]) }}"><i
                                                               class="fa fa-trash"></i></a>--}}
                                                </td>

                                            </tr>
                                        @endforeach

                                        </tbody>


                                    </table>


                        </div>
                        </div>


                        <div class="box-footer">
                            <div class="row">
                                <div class="col-md-12">
                                    {!!   str_replace('/?','?',$data->render() ) !!}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

        </div>


    </div>




@endsection


@section('scripts')



    <script>

        $("#date").datepicker({
            dateFormat: "yy-m-d",
            showAnim: "slideDown",
            changeMonth: true,
            changeYear: true,
        });
    </script>

@endsection
