@extends('default.admin.layouts.master')


@section('style')
    {!! Html::style('select/css/select2.min.css') !!}
@endsection

@section('content')


    <div class="container-fluid min_height_area">

        <div class="row">
            <div class="col-md-12">
                <div class="view-header">
                    <section class="content-header">
                        <ol class="breadcrumb">
                            <li>
                                <span class="fa fa-dashboard" aria-hidden="true"></span>
                                <a href="{{route('admin')}}">{{ trans('translate.dashboard') }}</a>
                            </li>
                            <li class="active text-capitalize">
                                <a href="{{ route('menu-list') }}">{{ trans('breadcrumb.menu.list') }}</a>

                            </li>
                            <li class="active text-capitalize">{{ request()->route()->getName() }}</li>
                        </ol>
                    </section>
                </div>
            </div>

        </div> <!--row-->
        <div class="inner-box-1">
            <div class="row">
                <div class="col-md-12 ">

                        <table class="table table-bordered table-striped">
                            <thead>
                            <tr>
                                <td>Sl</td>
                                <td>Group Name</td>
                                <td>Action</td>
                            </tr>
                            </thead>
                            <tbody>


                            @if(count($site_groups))
                                @foreach($site_groups as $k=>$value)

                                    <tr>
                                        <td>{{$k+1}}</td>
                                        <td>
                                            {{$value->name}}
                                        </td>
                                        <td>
                                            {!! Form::open(array('route' =>'site-group-impersonate', 'class'=>'form-horizontal')) !!}
                                            {!! Form::hidden('site_group_id',$value->id,['class'=>'form-control']) !!}

                                            <button class="btn btn-dropbox" type="submit"> Impersonate <i
                                                        class="fa fa-arrow-circle-right"></i></button>
                                            {!! Form::close() !!}
                                        </td>
                                    </tr>


                                @endforeach
                            @else
                                <tr>
                                    <td colspan="4" class="text-danger text-center"> <b> No Group Assigned Yet!</b></td>
                                </tr>
                            @endif
                            </tbody>
                        </table>
                </div>
            </div>
        </div>
    </div>


@endsection
@section('scripts')


    {!! Html::script('select/js/select2.min.js') !!}
    <script type="text/javascript">
        $(document).ready(function () {
            $('select1').select2();

        });
    </script>

@endsection