<!doctype html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>{{ $report_tittle ?? 'Challan Report' }}</title>

    <style type="text/css">
        * {
            font-family: Verdana, Arial, sans-serif;
        }

        table {
            font-size: x-small;
            width: 100%;
            border-collapse: collapse;
        }

        th,
        td {
            padding: 6px;
            border: 1px solid #ccc;
        }
        .header-table th,
        .header-table td {
            padding: 6px;
            border: none;
        }

        tfoot tr td {
            font-weight: bold;
            font-size: x-small;
        }

        .gray {
            background-color: lightgray
        }

        @page {
            size: 21cm 29.7cm;
            margin: 15px;
        }

        body {
            border: 1px dotted black;
            padding: 10px;
            border-radius: 5px;
        }

        .header-logo {
            height: 30px;
        }

        address {
            font-size: 12px;
            line-height: 1.4;
        }
    </style>
</head>

<body>

    {{-- Header --}}
    <table style="border: none;" class="header-table">
        <tr>
            <td valign="top">
                <img src="{{ public_path('image/named-logo.jpg') }}" class="header-logo">
            </td>
            <td align="right">
                <address>
                    <strong>Edu World</strong><br>
                    info@eduworld.com.bd<br>
                    +88 01901-029440
                </address>
            </td>
        </tr>
    </table>

    <br>
    {{-- Report Heading --}}
    <h2 style="text-align: center; margin: 20px 0; font-size: 20px; text-transform: uppercase; border;">
        <span style="border:1px solid #ddd; padding: 10px ; background-color: #f0f0f0;">
            Delivery Challan
        </span>
    </h2>

    {{-- Bill To --}}
    <table style="padding: 20px 20px 0px 20px">
        <tr>
            <td>
                <strong>To</strong>
                <address>
                    <strong>{{ $challan->siteInfo->site_name ?? 'N/A' }}</strong><br>
                    {{ $challan->siteInfo->address ?? 'N/A' }}<br>
                    {{ $challan->siteInfo->site_phone ?? 'N/A' }}
                </address>
            </td>
            <td align="right">
                <strong>Challan No:</strong> {{ $challan->challan_no ?? 'N/A' }}<br>
                <strong>Printed At:</strong> {{ date('d-m-Y h:i:s A', time()) }}
            </td>
        </tr>
    </table>

    <br>

    {{-- Challan Details --}}
    <table style="padding: 20px">
        <thead style="background-color: lightgray;">
            <tr>
                <th style="width: 10px">#</th>
                <th>Particulars</th>
                <th align="right" style="width: 20px">Quantity</th>
            </tr>
        </thead>
        <tbody>
            @if (!empty($challan->challan_details) && count($challan->challan_details) > 0)
                @foreach ($challan->challan_details as $k => $value)
                    <tr>
                        <th scope="row">{{ $k + 1 }}</th>
                        <td>{{ $value->item_details_id ?? 'N/A' }}</td>
                        <td align="right">{{ $value->item_quantity ?? 0 }}</td>
                    </tr>
                @endforeach
            @else
                <tr>
                    <td colspan="3" align="center">No data available</td>
                </tr>
            @endif
        </tbody>


    </table>

    <div style="padding-top: 50px">
        <table style="padding: 20px">
            <tr>
                <td style="width: 100%">

                    <span ><span style="font-weight: bold">Note:</span> {{ $challan->note}}</span>
                </td>

            </tr>

        </table>

    </div>
    <div style="position: fixed; bottom: 70px; ">
        <table style="border: none;" class="header-table">
            <tr>
                <td valign="top">
                    <span style="border-top: 2px solid black;padding:20px">Delivery Signature  </span>
                </td>
                <td align="right">
                    <span style="border-top: 2px solid black;padding:20px">Receiver Signature</span>
                </td>
            </tr>
        </table>
    </div>

</body>

</html>
