@extends('default.admin.layouts.master')
@section('content')
    <div class="container-fluid min_height_area">
        <div class="row">
            <div class="col-md-12">
                <div class="view-header">
                    <section class="content-header">
                        <ol class="breadcrumb">
                            <li>
                                <span class="fa fa-dashboard" aria-hidden="true"></span>
                                <a href="{{route('admin')}}">{{ trans('translate.dashboard') }}</a></li>
                            <li class="active text-capitalize">{{ request()->route()->getName() }}</li>
                        </ol>
                    </section>
                </div>
            </div>
        </div>

        <edu-site-monitor-master-component

                get-site-list="{{route('edu-site-get-site-list')}}"
                get-item-list="{{route('edu-item-get-item-list')}}"
                get-new-invoice-data="{{route('edu-site-invoice-get-data-for-new-invoice-by-site',[''])}}"
                create-invoice="{{route('edu-site-invoice-create')}}"
                get-invoice-list="{{route('edu-site-invoice-get-invoice-list')}}"
                the-invoice-details="{{route('edu-site-invoice-get-the-invoice-details-for-payment',[''])}}"
                payment-create="{{route('edu-site-invoice-payment-create')}}"
                invoice-delete="{{route('edu-site-invoice-delete',[''])}}"
                invoice-pdf="{{route('edu-site-invoice-get-pdf-report',[''])}}"
                payment-details="{{route('edu-site-invoice-payment-details',[''])}}"
                invoice-by-search="{{route('edu-site-invoice-get-invoice-by-search')}}"
        >

        </edu-site-monitor-master-component>


    </div>

@endsection


@section('hscripts')


    <script>


        window.routes = {
            'edu_site_invoice_get_site_list': "{{route('edu-site-get-site-list')}}",
            'site_invoice_get_item_list': "{{route('edu-item-get-item-list')}}",
            'site_invoice_get_new_invoice_data': "{{route('edu-site-invoice-get-data-for-new-invoice-by-site',[''])}}",
            'site_invoice_create_invoice': "{{route('edu-site-invoice-create')}}",
            'site_invoice_get_invoice_list': "{{route('edu-site-invoice-get-invoice-list')}}",
            'site_invoice_invoice_details': "{{route('edu-site-invoice-get-the-invoice-details-for-payment',[''])}}",
            'site_invoice_payment_create': "{{route('edu-site-invoice-payment-create')}}",
            'site_invoice_delete': "{{route('edu-site-invoice-delete',[''])}}",
            'site_invoice_pdf': "{{route('edu-site-invoice-get-pdf-report',[''])}}",
            'payment_details': "{{route('edu-site-invoice-payment-details',[''])}}",
            'site_invoice_by_search': "{{route('edu-site-invoice-get-invoice-by-search')}}"
        }
    </script>
@endsection


