<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>{{ $title_view }}</title>

    <style type="text/css">
        * {
            font-family: Verdana, Arial, sans-serif;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            font-size: 11px;
        }
        thead {
            background-color: #e6e6e6;
        }
        th, td {
            border: 1px solid #999999;
            padding: 4px;
            text-align: center;
        }
        .amount-right {
            text-align: right;
        }
        .status-paid {
            background-color: #e0f7e9; /* light green */
        }
        .status-due {
            background-color: #fdecea; /* light red */
        }
        .total-row {
            background-color: #dcdcdc;
            font-weight: bold;
        }
        @page {
            size: A4 landscape;
            margin: 10px;
        }
        body {
            margin: 10px;
        }
    </style>
</head>
<body>

    <h3 style="text-align:center; margin-bottom:10px;"> Reguler Site Invoice List</h3>

    <table>
        <thead>
            <tr>
                <th rowspan="2">S/L</th>
                <th rowspan="2">Institute Name</th>
                <th rowspan="2">Invoice No.</th>
                <th rowspan="2">Date</th>
                <th rowspan="2">Due Date</th>
                <th rowspan="2">Status</th>
                <th colspan="{{count($itemsList)}}">Items</th>
                <th rowspan="2">Sub Total</th>
                <th rowspan="2">Tax Amount</th>
                <th rowspan="2">Previous Due</th>
                <th rowspan="2">Discount</th>
                <th rowspan="2">Grand Total</th>
                <th rowspan="2">Paid Amount</th>
                <th rowspan="2">Due Amount</th>
            </tr>
            <tr>
                @foreach($itemsList as $item)
                    <th>{{ $item->item_name }}</th>
                @endforeach
            </tr>
        </thead>
        <tbody>
            @forelse($invoiceList as $index => $inv)
                <tr class="{{ $inv['status_code'] == 'Paid' ? 'status-paid' : 'status-due' }}">
                    <td>{{ $loop->iteration }}</td>
                    <td>{{ $inv['site_info']['site_name'] ?? '' }}</td>
                    <td>{{ $inv['invoice_no'] }}</td>
                    <td>{{ \Carbon\Carbon::parse($inv['invoice_date'])->format('d-m-Y') }}</td>
                    <td>{{ \Carbon\Carbon::parse($inv['due_date'])->format('d-m-Y') }}</td>
                    <td>{{ ucfirst($inv['status_code']) }}</td>

                    @foreach($inv['details'] as $detail)
                        <td class="amount-right">{{ number_format($detail['item_final_amount'],2) }}</td>
                    @endforeach

                    <td class="amount-right">{{ number_format($inv['sub_total'],2) }}</td>
                    <td class="amount-right">{{ number_format($inv['total_tax'],2) }}</td>
                    <td class="amount-right">{{ number_format($inv['previous_due'],2) }}</td>
                    <td class="amount-right">{{ number_format($inv['discount_amount'],2) }}</td>
                    <td class="amount-right">{{ number_format($inv['grand_total'],2) }}</td>
                    <td class="amount-right">{{ number_format($inv['amount_paid'],2) }}</td>
                    <td class="amount-right">{{ number_format($inv['amount_due'],2) }}</td>
                </tr>
            @empty
                <tr>
                    <td colspan="15" style="color:red; text-align:center;">
                        Data Not Found!
                    </td>
                </tr>
            @endforelse

            <tr class="total-row">
                <td colspan="6" style="text-align: right;">Total</td>
                @foreach($grand_totals['item_total_array'] as $item_total)
                    <td class="amount-right">{{ number_format($item_total['grand_total'],2) }}</td>
                @endforeach
                <td class="amount-right">{{ number_format($grand_totals['sub_total_sum'],2) }}</td>
                <td class="amount-right">{{ number_format($grand_totals['total_tax_sum'],2) }}</td>
                <td class="amount-right">{{ number_format($grand_totals['previous_due_sum'],2) }}</td>
                <td class="amount-right">{{ number_format($grand_totals['discount_amount_sum'],2) }}</td>
                <td class="amount-right">{{ number_format($grand_totals['grand_total_sum'],2) }}</td>
                <td class="amount-right">{{ number_format($grand_totals['amount_paid_sum'],2) }}</td>
                <td class="amount-right">{{ number_format($grand_totals['amount_due_sum'],2) }}</td>
            </tr>
        </tbody>
    </table>

</body>
</html>
