@extends('default.admin.layouts.master')

@section('style')
    {!! Html::style('css/styles.css') !!}
@endsection

@section('content')



        <div class="container-fluid" style="min-height: 1215px;">

            <div class="row">
                <div class="col-md-12">
                    <div class="view-header">
                        <section class="content-header">
                            <ol class="breadcrumb">
                                <li>
                                    <span class="fa fa-dashboard" aria-hidden="true"></span>
                                    <a href="{{route('admin')}}">{{ trans('translate.dashboard') }}</a>
                                </li>
                                <li class="active text-capitalize">
                                    <a href="{{route('get-menu-report')}}">Routes</a>
                                </li>
                                <li class="active text-capitalize">Menu Using Route</li>
                            </ol>
                        </section>
                    </div>
                </div>

            </div> <!--row-->

        <div class="inner-box-1 box-body">

            @if($menu_using_route)
                <div class="col-md-12 table-responsive" style="padding:0;">
                    <table class="table table-bordered table-dark">
                        <thead>
                        <tr>
                            <th scope="col">#</th>
                            <th scope="col">Id</th>
                            <th scope="col">Name</th>
                            <th scope="col">Route Name</th>
                            <th scope="col">Dispalyable</th>
                            <th scope="col">Menu For</th>
                        </tr>
                        </thead>
                        <tbody>
                        <tr>
                            <td class="" colspan="10">
                                <button type="button" class="btn btn-primary">
                                    <span class="badge badge-light">#{{$menu_using_route->id}}</span> {{$menu_using_route->menu_name}}
                                    <span class="sr-only"> {{$menu_using_route->menu_name}}</span>
                                </button>
                            </td>
                        </tr>
                        @if($menu_using_route && count($menu_using_route->routes)>0)
                            @foreach($menu_using_route->routes as $key =>  $route)
                                <tr>
                                    <th>{{$key+1}}</th>
                                    <th>{{$route->menu->id}}</th>
                                    <td>{{$route->menu->menu_name}}</td>
                                    <td>{{$route->menu->route_name}}</td>
                                    <td>{{getYesNo( $route->menu->is_displayable)}}</td>
                                    <td>{{$route->menu->menu_for}}</td>
                                </tr>
                            @endforeach
                        @endif

                        </tbody>
                        <tfoot>
                        <tr>
                            <td colspan="10">
                                @if($menu_using_route && !count($menu_using_route->routes))

                                    <p class="text-center danger">No Using Menu Found</p>
                                @endif
                            </td>
                        </tr>
                        </tfoot>
                    </table>
                </div>
            @endif

            @if(count($menus)>0)

                <div class="col-md-12 table-responsive" style="padding:0;">
                    <table class="table table-bordered table-dark">

                        <thead>
                        <tr>
                            <th scope="col">#</th>
                            <th scope="col">Id</th>
                            <th scope="col">Name</th>
                            <th scope="col">Route Name</th>
                            <th scope="col">Menu For</th>
                            <th scope="col">Active</th>
                        </tr>
                        </thead>

                        <tbody>


                        @foreach($menus as $key =>  $menu)
                            <tr>
                                <td>{{$key+1}}</td>
                                <td>{{$menu->id}}</td>
                                <td>{{$menu->menu_name}}</td>
                                <td>{{$menu->route_name}}</td>
                                <td>{{$menu->menu_for}}</td>
                                <td>
                                    <a class="btn btn-success btn-xs mrg"
                                       data-original-title="{{ trans('translate.edit') }}"
                                       data-toggle="tooltip"
                                       href="{{ route('get-menu-report',[$menu->id]) }}"><i
                                                class="fa fa-edit"></i>
                                        Usages</a>
                                </td>
                            </tr>


                        @endforeach

                        </tbody>
                    </table>
                    @endif

                </div>
        </div>
    </div>

@endsection

@section('scripts')

    @parent



@endsection