@inject('roleList','App\Lists\RoleList')
@extends('default.admin.layouts.master')

@section('style')
    {!! Html::style('css/styles.css') !!}
@endsection

@section('content')

    <div class="container-fluid min_height_area">
        <div class="row">
            <div class="col-md-12">
                <div class="student-box-header">
                    <div class="col-md-6 col-xs-6">
                        <span class="glyphicon glyphicon-user " aria-hidden="true"></span>{{ trans('sidebar.role_list') }}
                    </div>
                    <div class="col-md-6 col-xs-6 snt">
                        <ul class="breadcrumb text-right">
                            <li>
                                <a href="{!! route('role-add-form') !!}"><i class="fa fa-plus"></i> {{ trans('sidebar.role-create') }}</a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div> <!--row-->
        <div class="row">
            <div class="col-md-12">
                <div class="view-header">
                    <button onclick="javascript:window.print()" class="btn btn-primary"><span class="fa fa-print"></span> {{ trans('translate.print') }} </button>
                    <button onclick="javascript:window.print()" class="btn btn-primary"><span class="fa fa-file"></span> {{ trans('translate.print_preview') }} </button>
                    <button class="btn btn-primary"><span class="fa fa-file"></span> {{ trans('translate.edit') }}</button>
                 
                </div>
            </div>


            @if(session()->has('success'))
                <div class="col-md-8 col-md-offset-2 text-center">
                    <div class="alert alert-success successOrErrorMsgDiv">
                        <p>{{session()->get('success')}}</p>
                    </div>
                </div>
            @endif
            @if(session()->has('error'))
                <div class="col-md-8 col-md-offset-2 text-center">
                    <div class="alert alert-danger successOrErrorMsgDiv">
                        <p class="">{{session()->get('error')}}</p>
                    </div>
                </div>
            @endif
            @if ($errors->any())
                <div class="col-md-8 col-md-offset-2 text-capitalize">
                    <div class="alert alert-warning successOrErrorMsgDiv">
                        @foreach ($errors->all() as $error)
                            <p>{{ $error }}</p>
                        @endforeach
                    </div>
                </div>
            @endif
















        </div> <!--row-->
        <div class="inner-box">
            <div class="row">
                <div id="datatable">
                    <div class="row last">
                        <div class="col-sm-12 col-xs-12">
                            <div class="box">
                                <div class="box-body auto_scroll">

                                    <table id="example1" class="table table-bordered table-striped table-responsive">
                                        <thead>
                                        <tr>
                                            <th>{{ trans('translate.sl') }}</th>
                                            <th>{{ trans('translate.name') }}</th>
                                            <th>{{ trans('translate.description') }}</th>

                                            <th class=" text-center th_width_100">{{ trans('translate.action') }}</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @set('sl',1)
                                        @foreach($model as $role)
                                        <tr>
                                            <td>{{ $sl++ }}</td>
                                            <td>{{ $role->name ?? 'Null' }}</td>
                                            <td>{{ $role->role_description ?? 'Null' }}</td>

                                            <td class="text-center">
                                                <a class="btn btn-info btn-xs mrg" data-original-title="{{ trans('translate.view') }}" data-toggle="tooltip" href="{{ route('role-view',[$role->id]) }}"><i class="fa fa-edit"></i></a>
                                                <a class="btn btn-success btn-xs mrg" data-original-title="{{ trans('translate.edit') }}" data-toggle="tooltip" href="{{ route('role-edit-form',[$role->id]) }}"><i class="fa fa-edit"></i></a>
                                                <a  class="btn btn-danger btn-xs delete_btn mrg" data-original-title="{{ trans('translate.delete') }}" data-toggle="tooltip" href="{{ route('role-delete',[$role->id]) }}"><i class="fa fa-trash-o"></i></a>
                                            </td>
                                        </tr>
                                        @endforeach
                                        </tbody>

                                    </table>
                                    <div class="pagination">{!!   str_replace('/?','?',$model->render() ) !!} </div>
                                </div><!-- /.box-body -->
                            </div><!-- /.box -->
                        </div>
                    </div> <!--row last-->
                </div>
            </div>
        </div>
    </div>



@endsection
