<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>{{$view_title}}</title>

    <style type="text/css">

        * {
            font-family: Verdana, Arial, sans-serif;
        }
        table{
            font-size: x-small;
        }
        tfoot tr td{
            font-weight: bold;
            font-size: x-small;
        }

        .amount-right{
            text-align:right;
        }

        .gray {
            background-color: lightgray
        }

    </style>

</head>
<body>
@include('default.site.layout.pdf-header')


    <table width="100%">

        <thead style="background-color: #3c8dbc; color:white;">
        <tr>
            <td align="left"><b>Particular</b></td>
            <td align="right"><b>Amount</b></td>
        </tr>
        </thead>
        <tbody>

        <!-- ==================Asset================== -->
        <!-- ===============current asset================== -->
        <tr>
            <td colspan="2"  class="no-padding" style="text-align:left; padding:3px !important;  background-color:#c2d1f0;"
            >
                <b>Asset</b>
            </td>
        </tr>
        <tr>
            <td colspan="2" class="no-padding" style="text-align:left; padding:3px !important;"
            >
                <b>&nbsp;&nbsp;Current Asset</b>
            </td>
        </tr>
        @foreach($current_asset_data_list as $key => $value)
        <tr>
            <td class="no-padding" style="text-align:left; padding:3px !important;">
                &nbsp;&nbsp;&nbsp;&nbsp;{{$value['ledger']['name']}}
            </td>
            <td class="no-padding" style="text-align:right;">
                @if($value['ledger_tatol_amount'] < 0)
                    <span>
                      ({{number_format($value['ledger_tatol_amount'] * -1)}})
                    </span>
                @endif
                @if($value['ledger_tatol_amount'] >= 0)
                    <span>
                      {{number_format($value['ledger_tatol_amount'])}}
                    </span>
                @endif
            </td>
        </tr>
        @endforeach
        <tr>
            <td class="no-padding" style="text-align:right; padding:3px !important;">
                <b>Total Current Asset</b>
            </td>
            <td class="no-padding" style="text-align:right; padding:3px !important;">
                @if($current_asset_total_amount < 0)
                <span>
                     <b>({{number_format($current_asset_total_amount * -1)}})</b>
                </span>
                @else
                    <span>
                       <b>{{number_format($current_asset_total_amount)}}</b>

                </span>
                @endif
            </td>
        </tr>
        <!-- ===============fixed asset================== -->

        <tr>
            <td colspan="2" class="no-padding" style="text-align:left; padding:3px !important;"
            >
                <b>&nbsp;&nbsp;Fixed Asset</b>
            </td>
        </tr>
        @foreach($fixed_asset_data_list as $k => $v)
            <tr>
                <td class="no-padding" style="text-align:left; padding:3px !important;">
                    &nbsp;&nbsp;&nbsp;&nbsp;{{$v['ledger']['name']}}
                </td>
                <td class="no-padding" style="text-align:right;">
                    @if($v['ledger_tatol_amount'] < 0)
                        <span>
                          ({{
                          number_format($v['ledger_tatol_amount'] * -1)
                          }})
                        </span>
                    @endif
                    @if($v['ledger_tatol_amount'] >= 0)
                        <span>
                          {{
                          number_format($v['ledger_tatol_amount'])
                          }}
                        </span>
                    @endif
                </td>
            </tr>
        @endforeach
        <tr>
            <td class="no-padding" style="text-align:left; padding:3px !important;">
                &nbsp;&nbsp;&nbsp;&nbsp;Accumulated Depriciation
            </td>
            <td class="no-padding" style="text-align:right;">
                <span>
                  ({{ number_format($depriciation_amount)}})
                </span>
            </td>
        </tr>
        <tr>
            <td class="no-padding" style="text-align:right; padding:3px !important;">
                <b>Total Fixed Asset</b>
            </td>
            <td class="no-padding" style="text-align:right; padding:3px !important;">
                @if(($fixed_asset_total_amount - $depriciation_amount) < 0)
                    <span>
                     <b>({{number_format(($fixed_asset_total_amount - $depriciation_amount) * -1)}})</b>
                </span>
                @else
                    <span>
                       <b>{{number_format($fixed_asset_total_amount - $depriciation_amount)}}</b>

                </span>
                @endif
            </td>
        </tr>
        <tr>
            <td class="no-padding" style="text-align:right; padding:3px !important; background-color:#ebf0fa;;"
            >
                <b>Total Asset</b>
            </td>
            <td class="no-padding" style="text-align:right; padding:3px !important; background-color:#ebf0fa;"
            >
                @if(($current_asset_total_amount + ($fixed_asset_total_amount - $depriciation_amount)) < 0)
                    <span>
                     <b>({{number_format(($current_asset_total_amount + ($fixed_asset_total_amount - $depriciation_amount)) * -1)}})</b>
                </span>
                @else
                    <span>
                       <b>{{number_format($current_asset_total_amount + ($fixed_asset_total_amount - $depriciation_amount))}}</b>

                </span>
                @endif

            </td>
        </tr>
        <!-- ==================Liability==================== -->
        <!-- ===============current liability================== -->
        <tr>
            <td colspan="2" class="no-padding" style="text-align:left; padding:3px !important;  background-color:#c2d1f0;"
            >
                <b>Liability</b>
            </td>
        </tr>
        <tr>
            <td colspan="2" class="no-padding" style="text-align:left; padding:3px !important;"
            >
                <b>&nbsp;&nbsp;Current Liability</b>
            </td>
        </tr>
        @foreach($current_liability_data_list as $kk => $vv)
            <tr>
                <td class="no-padding" style="text-align:left; padding:3px !important;">
                    &nbsp;&nbsp;&nbsp;&nbsp;{{ $vv['ledger']['name']}}
                </td>
                <td class="no-padding" style="text-align:right;">
                    @if($vv['ledger_tatol_amount'] < 0)
                        <span>
                          ({{
                          number_format($vv['ledger_tatol_amount'] * -1)
                          }})
                        </span>
                    @endif
                     @if($vv['ledger_tatol_amount'] >= 0)
                        <span>
                          {{
                          number_format($vv['ledger_tatol_amount'])
                          }}
                        </span>
                    @endif
                </td>
            </tr>
        @endforeach
        <tr>
            <td class="no-padding" style="text-align:right; padding:3px !important;">
                <b>Total Current Liability</b>
            </td>
            <td class="no-padding" style="text-align:right; padding:3px !important;">
                @if($current_liability_total_amount < 0)
                    <span>
                     <b>({{number_format($current_liability_total_amount * -1)}})</b>
                </span>
                @else
                    <span>
                       <b>{{number_format($current_liability_total_amount)}}</b>

                </span>
                @endif
            </td>
        </tr>
        <!-- ===============long term liability================== -->

        <tr>
            <td colspan="2" class="no-padding" style="text-align:left; padding:3px !important;">
                <b>&nbsp;&nbsp;Long Term Liability</b>
            </td>
        </tr>
        @foreach($long_term_liability_data_list as $kkk => $vvv)
            <tr>
                <td class="no-padding" style="text-align:left; padding:3px !important;">
                    &nbsp;&nbsp;&nbsp;&nbsp;{{ $vvv['ledger']['name']}}
                </td>
                <td class="no-padding" style="text-align:right;">
                    @if($vvv['ledger_tatol_amount'] < 0)
                        <span>
                          {{
                          number_format($vvv['ledger_tatol_amount'] * -1)
                          }}
                        </span>
                    @endif
                    @if($vvv['ledger_tatol_amount'] >= 0)
                        <span>
                          {{
                          number_format($vvv['ledger_tatol_amount'])
                          }}
                        </span>
                    @endif
                </td>
            </tr>
        @endforeach
        <tr>
            <td class="no-padding" style="text-align:right; padding:3px !important;">
                <b>Total Long Term Liability</b>
            </td>
            <td class="no-padding" style="text-align:right; padding:3px !important;">
                @if($long_term_liability_total_amount < 0)
                    <span>
                     <b>({{number_format($long_term_liability_total_amount * -1)}})</b>
                </span>
                @else
                    <span>
                       <b>{{number_format($long_term_liability_total_amount)}}</b>

                </span>
                @endif
            </td>
        </tr>
        <tr>
            <td class="no-padding" style="text-align:right; padding:3px !important; background-color:#ebf0fa;"
            >
                <b>Total Liability</b>
            </td>
            <td class="no-padding" style="text-align:right; padding:3px !important; background-color:#ebf0fa;"
            >
                @if(($current_liability_total_amount + $long_term_liability_total_amount) < 0)
                    <span>
                     <b>({{number_format(($current_liability_total_amount + $long_term_liability_total_amount) * -1)}})</b>
                </span>
                @else
                    <span>
                       <b>{{number_format($current_liability_total_amount + $long_term_liability_total_amount)}}</b>

                </span>
                @endif

            </td>
        </tr>
        <!-- ==================Equity==================== -->
        <tr>
            <td  colspan="2" class="no-padding" style="text-align:left; padding:3px !important; background-color:#c2d1f0;"
            >
                <b>Equity</b>
            </td>
        </tr>
        <tr>
            <td class="no-padding" style="text-align:left; padding:3px !important;">
                &nbsp;&nbsp;Retained Earnings
            </td>
            <td class="no-padding" style="text-align:right; padding:3px !important;">
                @if($total_profit_loss < 0)
                    <span>
                      ({{
                      number_format($total_profit_loss * -1)
                      }})
                    </span>
                @endif
                @if($total_profit_loss >= 0)
                    <span>
                      {{
                      number_format($total_profit_loss)
                      }}
                    </span>
                @endif
            </td>
        </tr>

        <tr>
            <td class="no-padding" style="text-align:right; padding:3px !important;  background-color:#ebf0fa;"
            >
                <b>Total Liability & Equity</b>
            </td>
            <td class="no-padding" style="text-align:right; padding:3px !important;  background-color:#ebf0fa;"
            >
                @if(($current_liability_total_amount + $long_term_liability_total_amount + $total_profit_loss) < 0)
                    <span>
                     <b>({{number_format(($current_liability_total_amount + $long_term_liability_total_amount + $total_profit_loss) * -1)}})</b>
                </span>
                @else
                    <span>
                       <b>{{number_format($current_liability_total_amount + $long_term_liability_total_amount + $total_profit_loss)}}</b>

                </span>
                @endif
            </td>
        </tr>
        </tbody>


        {{--<tbody></tbody>--}}
    </table>
    <table width="100%">
        {{--<span>Print Date: {{$print_date}}</span>--}}
    </table>
</body>


<style>
    @page {
        size: a4;
        margin: 1px 0;
    }
    body {
        margin: 5px 20px 0;
        border:1px dotted black;
    }

</style>
</html>