<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>{{$view_title}}</title>

    <style type="text/css">

        * {
            font-family: Verdana, Arial, sans-serif;
        }
        table{
            font-size: x-small;
        }
        tfoot tr td{
            font-weight: bold;
            font-size: x-small;
        }

        .amount-right{
            text-align:right;
        }

        .gray {
            background-color: lightgray
        }

    </style>

</head>
<body>
@include('default.site.layout.pdf-header')


    <table width="100%">

        <thead style="background-color: #e2e6e9;">
        <tr>
            <td align="left"><b>Particular</b></td>
            <td align="center"><b>Code</b></td>
            <td align="center"><b>Date</b></td>
            <td align="left"><b>Voucher</b></td>
            <td align="center"><b>Voucher No</b></td>
            <td align="right"><b>Debit</b></td>
            <td align="right"><b>Credit</b></td>
        </tr>
        </thead>
        <tbody>
        @foreach($final_ledger_data_list as $key=>$value)

                <tr>
                    <td colspan = "3" class="no-padding" style="text-align:left; padding:3px !important;"
                    >
                        <b>
                            {{$value['ledger_account']['name']}}
                        </b>
                    </td>
                    <td colspan="2" class="text-right" style="text-align:right; padding:3px !important;">
                                                        <span>
                                                           <nobr> Opening Balance (Upto: {{$value['upto_date_for_opening_balance']}}) :</nobr>
                                                        </span>
                    </td>
                    <td  class="no-padding"
                         style="text-align:right; padding:3px !important;">
                        @if($value['opening_balance'] >=0)
                                                         <span>
                                                             {{number_format($value['opening_balance'])}}

                                                        </span>
                            @endif
                    </td>
                    <td   class="no-padding"
                          style="text-align:right; padding:3px !important;">
                        @if($value['opening_balance'] < 0)
                                                        <span>
                                                             {{number_format($value['opening_balance'] * -1)}}

                                                        </span>
                        @endif
                    </td>
                </tr>
                @foreach($value['data_list'] as $ky=>$vl)
                <tr>
                    <td class="no-padding" style="text-align:left; padding:3px !important;">
                        {{
                        $vl['data']['ledger']['name']
                        }}
                    </td>
                    <td class="no-padding" style="text-align:center; padding:3px !important;">
                        {{
                        $vl['data']['ledger']['ledger_code']
                        }}
                    </td>
                    <td class="no-padding" style="text-align:center; padding:3px !important;">
{{--                        {{$vl['data']->acc_voucher_details->transaction_date}}--}}
                       <nobr> {{$vl['data']['accVoucherDetails']['transaction_date']}}</nobr>

                    </td>
                    <td class="no-padding" style="text-align:left; padding:3px !important;">
                        @if($vl['data']['accVoucherDetails']['voucher_type'] == 'debitvoucher')
                            <span>Debit/Payment</span>
                        @endif
                        @if($vl['data']['accVoucherDetails']['voucher_type'] == 'creditvoucher')
                            <span>Credit/Receive</span>
                        @endif
                        @if($vl['data']['accVoucherDetails']['voucher_type'] == 'journalvoucher')
                            <span>Journal</span>
                        @endif

                    </td>
                    <td class="no-padding" style="text-align:center; padding:3px !important;">
                        <span>{{$vl['data']['accVoucherDetails']['voucher_no']}}</span>
                    </td>
                    <td class="no-padding" style="text-align:right; padding:3px !important;">
                        @if($vl['data']['entry'] =='cr')
                           <span> {{
                             number_format($vl['data']['credit_amount'])
                             }}</span>
                        @endif
                    </td>
                    <td class="no-padding" style="text-align:right; padding:3px !important;">
                        @if($vl['data']['entry'] =='dr')
                          <span>{{
                             number_format($vl['data']['debit_amount'])
                             }}</span>
                        @endif
                    </td>
                </tr>
                @endforeach
                <tr>
                    <td  class="no-padding" colspan="5" style="text-align:right; padding:3px !important; background-color:whitesmoke">
                        <b>
                            Total
                            @if($value['total_amount'] >= 0)
                                <span>(Dr)</span>
                            @endif
                            @if($value['total_amount'] < 0)
                                <span>(Cr)</span>
                            @endif

                        </b>
                    </td>
                    {{--<td>--}}
                        {{--{{$value['total_amount'] >= 0 ? $value['total_amount'] : ''}}--}}
                    {{--</td>--}}
                    {{--<td>--}}
                        {{--{{$value['total_amount'] < 0 ? $value['total_amount'] : ''}}--}}
                    {{--</td>--}}
                    <td  class="no-padding"  style="text-align:right; padding:3px !important; font-size: 14px; background-color:whitesmoke">
                        @if($value['total_amount'] >= 0)
                            <span><b>{{number_format($value['total_amount'])}}</b></span>
                        @endif

                    </td>
                    <td  class="no-padding" style="text-align:right; padding:3px !important; font-size: 14px; background-color:whitesmoke">
                        @if($value['total_amount'] < 0)
                            <span><b>{{number_format($value['total_amount'] * -1)}}</b></span>
                        @endif
                    </td>
                </tr>

        @endforeach
        @foreach($fixed_depriciation_list as $ke => $val)
            <tr>
                <td colspan="6" class="no-padding" style="text-align:left; padding:3px !important;" >
                    <b>
                        {{
                        $val['ledger_account']
                        }}
                    </b>
                </td>
            </tr>
            @if($val['entry'] == 'cr')
                @foreach($val['data'] as $kke => $vvl)
                    <tr>
                        <td class="no-padding" style="text-align:left; padding:3px !important;">{{$vvl['particular']}}</td>
                        <td style="text-align:center;">{{$vvl['ledger_code']}}</td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td style="text-align:right; padding:3px !important;">{{$vvl['amount']}}</td>
                    </tr>
                @endforeach
            @endif
            @if($val['entry'] == 'dr')
                <tr>
                    <td class="no-padding" style="text-align:left; padding:3px !important;">{{$val['particular']}}</td>
                    <td style="text-align:center;">50001</td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td style="text-align:right; padding:3px !important;">{{$val['amount']}}</td>
                    <td></td>
                </tr>
            @endif

            <tr>
                <td class="no-padding" colspan="5" style="text-align:right; padding:3px !important; background-color:whitesmoke" >
                    <b>
                        Total
                        @if($val['entry'] == 'dr')
                            <span>(Dr)</span>

                        @endif
                        @if($val['entry'] == 'cr')
                            <span>(Cr)</span>

                        @endif
                    </b>
                </td>
                <td style="text-align:right; padding:3px !important; background-color:whitesmoke" >
                    @if($val['entry'] == 'dr')
                        <span><b>{{$val['amount']}}</b></span>

                    @endif
                </td>
                <td style="text-align:right; padding:3px !important; background-color:whitesmoke" >
                    @if($val['entry'] == 'cr')
                        <span><b>{{$val['amount']}}</b></span>

                    @endif
                </td>
            </tr>
        @endforeach



        </tbody>


        {{--<tbody></tbody>--}}
    </table>
    <table width="100%">
{{--        <span>Print Date: {{$print_date}}</span>--}}
    </table>
</body>


<style>
    @page {
        size: a4;
        margin: 1px 0;
    }
    body {
        margin: 6px 6px;
        /*border:1px dotted black;*/
    }

</style>
</html>