<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>{{$title_view}}</title>

    <style type="text/css">

        * {
            font-family: Verdana, Arial, sans-serif;
        }
        table{
            font-size: x-small;
        }
        tfoot tr td{
            font-weight: bold;
            font-size: x-small;
        }

        .amount-right{
            text-align:right;
        }

        .gray {
            background-color: lightgray
        }
        .slot-table td {
            border: 1px solid #999999;
            border-width: thin;
            border-spacing: 2px;
            /*border-style: none;*/

        }

        .heading-slot-bg {
            background-color: #dcdcdc;
            color: #000000;
            text-align: center;
            width: 25px;
            vertical-align: middle;
            padding-left: 20px;
        }

        .slot {
            width: 100px;
            min-height: 200px;
            padding: 0 3px;
        }


    </style>

</head>
<body>
@include('default.site.layout.pdf-header')

<table width="100%">
    <tr>
        <td align="left"> <b>Shift:</b> {{$class_shift_details->shift_name ?? ""}}</td>
        <td align="left"><b> Class:</b> {{$class_details->class_name}}</td>
        <td align="left"><b> Group:</b> {{$class_group_details->group_name ?? ""}}</td>
        {{-- <td align="left"> <b>Section:</b> {{$class_section_details->section_name ?? ""}}</td> --}}
        <td align="left"><b> From Date:</b> {{$from_date ?? ""}}</td>
        <td align="left"><b> To Date:</b> {{$to_date ?? ""}}</td>
    </tr>

</table>

 <table class="slot-table" width="100%" cellspacing="0" border="0">
    <thead style="background-color:  #e6e6e6;">
    <tr>

        <td><b>S.L.</b></td>
        <td  style="padding:2px;"><b>Student Name</b></td>
        {{-- <td align="center" style="padding:2px;"><b>Board</b></td > --}}
        <td align="center" style="padding:2px;"><b>Board Roll</b></td >
        <td  style="padding:2px;" class="amount-right"><nobr><b>Admission Fee</b></nobr></td>
        <td  style="padding:2px;" class="amount-right"><nobr><b>Other Fee</b></nobr></td>
        {{-- <td style="padding:2px;" class="amount-right"><b>Fine</b></td> --}}
        {{-- <td style="padding:2px;" class="amount-right"><nobr><b>Waiver</b></nobr></td> --}}
        <td  style="padding:2px;" class="amount-right"><nobr><b>Payable</b></nobr></td>
        <td align="center" style="padding:2px;" class="amount-right"><nobr><b>Paid</b></nobr></td>
        <td  style="padding:2px;" class="amount-right"><nobr><b>Due</b></nobr></td>
    </tr>
    </thead>
   <tbody>


    @php($sl=1)
    @foreach($admission_list as $key=>$value)

        <tr>
            <td><nobr>{{$key+1}}</nobr></td>
            <td class="text-right" style="padding:2px;"><nobr>{{$value['student_name']}}</nobr></td>
            <td align="center" style="padding:2px;">{{$value['board_roll_number']}}</td>
            <td class="amount-right" style="padding:2px;">{{$value['admission_fee']==0?"0.00":number_format($value['admission_fee']).".00"}}</td>
            <td class="amount-right" style="padding:2px;">{{$value['other_fee']==0?"0.00":number_format($value['other_fee']).".00"}}</td>
            {{-- <td class="amount-right" style="padding:2px;">{{$value['waiver_amount']==0?"0.00":number_format($value['waiver_amount']).".00"}}</td> --}}
            <td class="amount-right" style="padding:2px;">{{$value['payable']==0?"0.00":number_format($value['payable']).".00"}}</td>
            <td class="amount-right" style="padding:2px;">{{$value['paid']==0?"0.00":number_format($value['paid']).".00"}}</td>
            <td class="amount-right" style="padding:2px;">{{$value['due']==0?"0.00":number_format($value['due']).".00"}}</td>
        </tr>

    @endforeach


    </tbody>
    <tfoot  style="background-color:  #e6e6e6;">
    <tr>
        <td colspan="3" style="" class="amount-right">Total</td>
        <td class="amount-right" style="">{{$footer_data['total_admission_fee'].".00"}}</td>
        <td class="amount-right" style="">{{$footer_data['total_other_fee'].".00"}}</td>
        {{-- <td class="amount-right" style="">{{$footer_data['total_waiver'].".00"}}</td> --}}
        <td class="amount-right" style="">{{$footer_data['total_payable'].".00"}}</td>
        <td class="amount-right" style="">{{$footer_data['total_paid'].".00"}}</td>
        <td class="amount-right" style="">{{$footer_data['total_due'].".00"}}</td>
       

    </tr>
    </tfoot> 

</table>

<table width="100%">
    <br>
    <tr>
        <td align="left">
            {{--Print Date: {{date('d-m-Y h:i:s A',time())}}--}}
        </td>
    </tr>

</table>

</body>



<style>
    @page {
        size: a4;
        margin: 1px 0;
    }
    body {
        margin: 5px 20px 0;
        /*border:1px dotted black;*/
    }

</style>
</html>