<!DOCTYPE html>
<html>
<head>

    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no'
          name='viewport'>

    <title>{{$report_tittle}}</title>

    <style>

        @font-face {
            font-family: 'Verdana';
            font-weight: 100;
            font-style: normal;
            font-variant: normal;
            src: url("{{public_path()}}/fonts/Verdana.ttf") format("truetype");
        }


        body {
            font-family: "Verdana", sans-serif;
            font-size: 12px;
        }


        .tittle {
            background-color: #dcdcdc;
            border-radius: 10px;
            width: 100%;
            color: #000000;
            padding: 5px;
            font-weight: bold;
        }

        .data-table td {
            border: 1px solid #999999;
            text-align: center;
        }


    </style>

</head>
<body>


<table width="100%;" border="0">
    <tr>
        <td style="width: 25%">
            <img src="{{public_path($site->site_logo)}}" width="55" height="55">
        </td>
        <td style="width: 50%; text-align: center">
            <span style="font-size: 15px;">{{$site->site_name}}</span> <br>
            <span style="font-size: 11px;">{{$site->address}}</span> <br>
            <br>

            <span class="tittle">Shift: {{$shifName}}, Year: {{$yearName}}, Month: {{ $monthName }}</span>

        </td>
        <td style="width: 25%; font-size: 10px; text-align: right; vertical-align: bottom;">
            <b>Printed :</b> {{date('d-m-Y h:i:s A',time())}}
        </td>

    </tr>
</table>

<div>
    <table class="data-table" cellspacing="0" border="0" width="100%;" style="">

        <thead class="tittle">
        <tr>
            <td style="width: 1px">S/L</td>
            <td>Name</td>
            @foreach($daysList as $day)
                <td>{{ $day['short_date'] }}</td>
            @endforeach
            <td>Present</td>
            <td>Absent</td>
            <td>Leave</td>
            <td>Off</td>
            <td>Duty</td>

        </tr>
        </thead>


        <tbody>
        @foreach($employee_data_list as $key => $em_data)
          
            <tr>
                <td>{{$key +1}}</td>

                <td>
                    {{$em_data['employee_name']}}
                </td>

                @foreach($daysList as $key => $day)
                    @foreach($em_data['employee_attendance'] as $e_att)
                        @if($day['short_date']==$e_att['short_date'])
                            <td>{{$e_att['type'] ?? 'n/a'}}</td>
                        @endif
                    @endforeach
                @endforeach

                <td> {{$em_data['total_present'] ?? 'n/a'}}</td>
                <td> {{$em_data['total_absent'] ?? 'n/a'}}</td>
                <td> {{$em_data['total_leave'] ?? 'n/a'}}</td>
                <td> {{$em_data['total_off_day'] ?? 'n/a'}} </td>
                <td> {{$em_data['total_duty'] ?? 'n/a'}} </td>
            </tr>

        @endforeach
        </tbody>


    </table>
</div>


</body>


<style>

    @page {
        size:a4 landscape;
        margin: 0px;
    }

    body {
        margin: 10px 20px 50px 20px;
    }


</style>

</html>












