<!DOCTYPE html>
<html>
<head>

    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no'
          name='viewport'>

    <title>{{$report_tittle}}</title>

    <style>

        @font-face {
            font-family: 'Verdana';
            font-weight: 100;
            font-style: normal;
            font-variant: normal;
            src: url("{{public_path()}}/fonts/Verdana.ttf") format("truetype");
        }

        body {
            font-family: "Verdana", sans-serif;
            font-size: 12px;
        }

        .tittle {
            background-color: #dcdcdc;
            border-radius: 10px;
            width: 100%;
            color: #000000;
            padding: 5px;
            font-weight: bold;
        }

        .data-table td {
            border: 1px solid #999999;
            text-align: center;
        }
        .image{
            width: 60px;
            height: 60px;
            border-radius: 10px;
        }

    </style>

</head>
<body>
<div>

    @include('default.site.layout.pdf-header')


    <table class="data-table" cellspacing="0" border="0" width="100%;" style="">

        <thead class="tittle">
        <tr>
            <td style="width: 2px">S/L</td>
            <td>Name</td>


            @if($img_status)
            <td>Pic</td>

            @endif



            <td>User Id</td>
            <td>Joining Date</td>
            <td>Contact No.</td>
            <td>Email</td>

        </tr>
        </thead>


        <tbody>
        @foreach($emp_list as $key => $value)

            <tr>
                <td>{{$key +1}}</td>
                <td>
                    <nobr>  {{$value->full_name ?? 'N/A'}}</nobr>
                    <br>
                    <span style="font-size: 9px">  ( {{$value->activeHistory->designation->name ?? 'N/A'}} )</span>
                </td>

                @if($img_status)
                <td>
                    @if(file_exists(public_path("uploads").'/'.$value->latestPhoto->name))
                        <img  class="image"
                             src="{{asset("uploads").'/'.$value->latestPhoto->name  ?? 'image-not.png'}}">
                    @else
                        <img class="image"
                             src="{{asset("uploads").'/image-not.png'}}">
                    @endif
                </td>
                @endif


                <td>{{$value->username}}</td>
                <td>
                    <nobr> {{ date('M d Y', strtotime($value->dept_join_date))}}</nobr>
                </td>
                <td>
                    {{$value->contact_number}}
                </td>
                <td>
                    {{$value->email}}
                </td>


            </tr>


        @endforeach
        </tbody>


    </table>
</div>


</body>


<style>

    @page {
        size: a4;
        margin: 0px;
    }

    body {
        margin: 10px 20px 50px 20px;
    }


</style>

</html>












