<!DOCTYPE html>
<html>
<head>

    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no'
          name='viewport'>

    <title>{{$report_tittle}}</title>

    <style>

        @font-face {
            font-family: 'Verdana';
            font-weight: 100;
            font-style: normal;
            font-variant: normal;
            src: url("{{public_path()}}/fonts/Verdana.ttf") format("truetype");
        }

        body {
            font-family: "Verdana", sans-serif;
            font-size: 11px;
        }

        .tittle {

            border-radius: 10px;
            width: 100%;
            color: #000000;
            padding: 5px;
        }

        .slot-table th {
            border: 1px solid #999999;
        }

        .slot-table tr td {
            border: 1px dotted #999999;
            vertical-align: text-top;

        }

        .slot-table tr td:first-child {
            border: 1px solid #999999;
            vertical-align: middle;
        }

        .heading-slot-bg {
            background-color: #dcdcdc;
            color: #000000;
            text-align: center;
            vertical-align: text-top;
            width: 25px;
        }

        .slot {
            min-height: 200px;
            padding: 0 3px;
        }

        .class_timings {
            font-size: 10px;
        }

        .subject-div {
            font-size: 11px;
            font-weight: bold;

        }

        .employee-div {
            font-size: 9px;

        }

        .room-div {
            font-size: 11px;

        }

        .vertical {
            -ms-transform: rotate(270deg);
            -webkit-transform: rotate(270deg);
            transform: rotate(340deg);
            text-align: center;
            font-size: 12px;
            height: 30px;
        }

        .heading-slot-bg td {
            text-align: center;
        }

    </style>

</head>
<body>

@if($week_array)

    @include('default.site.layout.pdf-header')


    <div>
        <table class="slot-table" width="100%" cellspacing="0" border="0">


            @if(count($week_array)>0)
                <tbody>
                <tr class="heading-slot-bg">
                    <th>Day/Period</th>
                    @for( $i = 1; $i <= $max_col_count; $i++)
                        <th><i> {{ addOrdinalNumberSuffix($i)}} Period</i></th>
                    @endfor
                </tr>
                @foreach($week_array as $key=>$week)
                    <tr>
                        <td class="heading-slot-bg">
                            <div class="vertical">
                                {{$key}}
                            </div>
                        </td>
                        @if(count($week)<1)
                            <td colspan="{{$max_col_count}}"></td>
                        @endif

                        @php
                            $count=0;
                            $s_key=0;
                        @endphp

                        @foreach($week as $key1 => $slot)

                            @php($count++)
                            @php($s_key++)

                            @if(!$slot->classTimingDetail->is_break)
                                <td>
                                    <div class="slot">
                                        <div class="class_timings">
                                            ({{$slot->classTimingDetail->name }}). <br>
                                            {{date('h:i A', strtotime($slot->classTimingDetail->start_time)) }}
                                            - {{date('h:i A', strtotime($slot->classTimingDetail->end_time)) }}
                                        </div>

                                        <div class="employee-div">
                                            <nobr>
                                                @if($slot->dept) Dept: {{ $slot->dept->name }} @endif
                                                @if($slot->academicClass)
                                                    Class: {{ $slot->academicClass->class_name }}  @endif
                                                @if($slot->classGroup) Group:{{ $slot->classGroup->group_name }} @endif
                                                @if($slot->academicSection)
                                                    Section:{{ $slot->academicSection->section_name }}@endif
                                            </nobr>
                                        </div>

                                        @if(count($slot->routineAllocations))
                                            @foreach($slot->routineAllocations as $ks=>$routineAllocation)
                                                <div class="subject-div">
                                                    @if($routineAllocation->subject)
                                                        {{$routineAllocation->subject->subject_name}}
                                                    @endif
                                                </div>
                                                <div class="room-div">

                                                    @if($routineAllocation->room)
                                                        {{$routineAllocation->room->room_name}}

                                                        ({{($routineAllocation->room->building->building_name ?? '') .'- '. ($routineAllocation->room->floor->floor_name ?? '')}}
                                                        )

                                                    @endif
                                                </div>
                                            @endforeach
                                        @endif
                                    </div>

                                </td>

                            @endif

                            @if($s_key <$max_col_count && count($week)==$s_key) &&)
                            <td colspan="{{($max_col_count - $s_key)}}">

                            </td>
                            @endif

                        @endforeach
                    </tr>
                @endforeach


                </tbody>
            @endif

        </table>
    </div>


@endif
</body>


<style>
    @page {
        size: a4 landscape;
        margin: 0px;
    }

    body {
        margin: 10px 20px 50px 20px;
    }
</style>

</html>












