<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>{{$view_title}}</title>

    <style type="text/css">

        * {
            font-family: Verdana, Arial, sans-serif;
        }
        table{
            font-size: x-small;
        }
        tfoot tr td{
            font-weight: bold;
            font-size: x-small;
        }

        .amount-right{
            text-align:right;
        }

        .gray {
            background-color: lightgray
        }
        #tt{
            background-color: navy;
            color:red;

        }
        #sp{
            border:1px solid black;
        }
        #mm{
            border:1px solid black;
            padding:10px;
        }

    </style>

</head>
<body>
@include('default.site.layout.pdf-header')

<table width="100%" >
    @php($sl=1)

    @if(count($data))
        @foreach($data as $key => $value)
            @if($value['check_select_checkbox'])
                <tr>
                <br><br>
                <td  colspan="3" align="center"> <span id="tt"><b id="mm">Q-{{$sl++}}</b></span></td>
                </tr>
                <tr>
                    <td align="left" colspan="3" id="sp">
                        @if($value['question_no'])
                            <span>
                            <b>Question No.: </b>{{ $value['question_no'] }}
                          </span>
                        @endif
                        @if($value['site_exam_question_info']['academic_department'])
                            <span>
                            <b>Department: </b>{{ $value['site_exam_question_info']['academic_department']['name'] }},
                          </span>
                        @endif
                        @if($value['site_exam_question_info']['academic_class'])
                            <span>
                            <b>Class: </b>{{ $value['site_exam_question_info']['academic_class']['class_name'] }},
                          </span>
                        @endif
                        @if($value['site_exam_question_info']['academic_subject'])
                            <span>
                            <b>Subject: </b>{{ $value['site_exam_question_info']['academic_subject']['subject_name'] }},
                          </span>
                        @endif
                        @if($value['site_exam_question_info']['academic_subject_topic'])
                            <span>
                            <b>Topic/Lesson: </b>{{ $value['site_exam_question_info']['academic_subject_topic']['topic_name'] }},
                          </span>
                        @endif
                        @if($value['site_exam_question_info']['academic_exam_type'])
                            <span>
                            <b>Exam Type: </b>{{ $value['site_exam_question_info']['academic_exam_type']['marks_type'] }}
                          </span>
                        @endif

                    </td>

                </tr>
                <tr>

                    <td align="left" colspan="2">
                        <b>Q: {{$value['question']}}</b> <br>

                    </td>
                    <td align="right">Mark: {{$value['mark']}}</td>
                </tr>
                @if(count($value['site_exam_question_details']))
                    @foreach($value['site_exam_question_details'] as $k => $v)
                        <tr  style="border:1px solid black;">
                            <td width="5%"></td>
                            <td width="85%">
                                @if($value['site_exam_question_info']['academic_exam_type']['head_key'] == 'mcq' && $v['answer_status'])
                                  <span style="color:blue;">
                                       <b>{{$k+1}}.&nbsp;{{$v['option']}} </b>
                                    </span>
                                @else
                                    <span>
                                      {{$k+1}}.&nbsp;{{$v['option']}}
                                    </span>
                                @endif
                            </td>
                            <td align="right" width="10%">
                                @if($value['site_exam_question_info']['written_type'] == 'creative')
                                    <span>
                                        {{$v['mark']}}
                                    </span>
                                @endif
                            </td>

                        </tr>
                    @endforeach
                @endif

            @endif
        @endforeach
    @endif
</table>
</body>


<style>
    @page {
        size: a4;
        margin: 1px 0;
    }
    body {
        margin: 5px 20px 0;
        border:1px dotted black;
    }

</style>
</html>