<!DOCTYPE html>
<html>
<head>
    @set('site',getSiteInfoForPdf())
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no'
          name='viewport'>

    <title>{{$page_tittle}}</title>

    <style>

        @font-face {
            font-family: 'Verdana';
            font-weight: 100;
            font-style: normal;
            font-variant: normal;
            src: url("{{public_path()}}/fonts/Verdana.ttf") format("truetype");
        }

        body {
            font-family: "Verdana", sans-serif;
            font-size: 12px;
        }

        .tittle {

            border-radius: 10px;
            width: 100%;
            color: #000000;
            padding: 5px;
        }

        .data-table td, th {
            border: 1px dotted #999999;
            text-align: center;
        }

        .data-table th {
            border: 1px solid #999999;
            text-align: center;
        }
        .name-item{
           text-transform: capitalize;
           text-align: left !important;
        }


    </style>

</head>
<body>


@include('default.site.layout.pdf-header')


<div>
    <table class="data-table" cellspacing="0" border="0" width="100%;" style="">

        <thead class="tittle">
        <tr>
            <th>S/L</th>
            <th>Class Roll</th>
            <th>Student’s Name</th>
            <th>Father’s Name</th>
            <th>Mother’s Name</th>
            <th>Gender</th>
            <th>DOB</th>
            <th>Class</th>
            <th>Group</th>
            <th>Board Roll no.</th>
            <th>Board Registration no.</th>
            <th>Address</th>
         
        </tr>
        </thead>


        <tbody>
            @foreach($student_detail as $key => $value)
                <tr>
                    <td>{{$key +1}}</td>
                    <td>{{$value->student_roll_number}}</td>
                    <td class="name-item">{{$value->full_name ?? 'na'}}</td>
                    <td class="name-item">{{$value->student->father_name ?? 'na'}}</td>
                    <td class="name-item">{{$value->student->mother_name ?? 'na'}}</td>
                    <td>{{$value->student->gender->gender_name ?? 'na'}}</td>
                    <td>{{$value->student->date_of_birth ?? 'na'}}</td>
                    <td>{{$value->stClass->class_name ?? 'na'}}</td>
                    <td>{{$value->classGroup->group_name ?? 'na'}}</td>
                    <td>{{$value->board_roll_number ?? 'na'}}</td>
                    <td>{{$value->board_registration_number ?? 'na'}}</td>
                    <td>{{$value->address ?? 'na'}}</td>
                </tr>
            @endforeach
        </tbody>


    </table>
</div>


</body>


<style>
      @page {
        /* size: a4; */
        size:Landscape;
        margin: 1px 0;
    }
   

    body {
        margin: 10px 20px 50px 20px;
    }


</style>

</html>












