<!DOCTYPE html>
<html>
<head>

    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no'
          name='viewport'>

    <title>{{$report_tittle}}</title>

    <style>

        .tittle {
            background-color: #dcdcdc;
            border-radius: 10px;
            width: 100%;
            color: #000000;
            padding: 5px;
            font-weight: bold;
        }

        .data-table td {
            border: 1px solid #999999;
            text-align: center;
        }

        .heading-slot-bg {
            background-color: #dcdcdc;
            color: #000000;
            text-align: center;
        }

        .slot {
            width: 100px;
            min-height: 200px;
            padding: 0 3px;
        }

        .class_timings {
            font-size: 10px;
        }

        .subject-div {
            font-size: 11px;

        }

        .employee-div {
            font-size: 9px;

        }

        .room-div {
            font-size: 11px;

        }

        .vertical {
            -ms-transform: rotate(270deg); /* IE 9 */
            -webkit-transform: rotate(270deg); /* Chrome, Safari, Opera */
            transform: rotate(270deg);
            text-align: center;
            font-size: 12px;
            height: 60px;
        }

        .break_timings {
            font-size: 12px;
            font-weight: normal;
            width: 40px;
            height: 30px;

        }

        .break {
            transform: rotate(270deg);
            text-align: center;

        }

    </style>

</head>
<body>


<table width="100%;" border="0">
    <tr>
        <td style="width: 25%">
            <img src="{{asset("img/site").'/'.$site->site_logo}}" width="55" height="55">
        </td>
        <td style="width: 50%; text-align: center">
            <span style="font-size: 20px;">{{$site->site_name}}</span> <br>
            <span style="font-size: 15px;">{{$site->address}}</span> <br>
            <span style="font-size: 12px;">

            </span> <br>

            <span class="tittle">Shift Details for {{$belongs_to}} ({{$period_type_name}})</span>

        </td>
        <td style="width: 25%; font-size: 12px; text-align: right; vertical-align: bottom;">
            <b>Printed :</b> {{date('d-m-Y h:i:s A',time())}}
        </td>

    </tr>
</table>

<div>
    <table class="data-table" cellspacing="0" border="0" width="100%;" style="">

        <thead>
        <tr>
            <td>Weekday</td>
            <td>In</td>
            <td>Out</td>
            <td>On Day</td>
        </tr>
        </thead>

        @foreach($day_list as $day_kea=>$day)

            <tbody>
            @foreach($data as $key => $value)
                @if($day_kea==$value->week_day)
                    <tr>
                        <td>
                            {{ucfirst($value->week_day)}}
                        </td>
                        <td>
                            {{$value->in_time}}
                        </td>
                        <td>
                            {{$value->out_time}}
                        </td>
                        <td>
                            {{getYesNo( $value->day_on)}}
                        </td>
                    </tr>

                @endif
            @endforeach
            </tbody>
        @endforeach


    </table>
</div>


</body>


<style>

    @page {
        size: a4;
        margin: 0px;
    }

    body {
        margin: 10px 20px 50px 20px;
    }


</style>

</html>












