<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <link rel="shortcut icon" type="image/png" href="/image/logo.ico"/>
    <title>{{Session::get('FULL_NAME') ?? Session::get('ALIAS')}} | {{$viewType}}</title>
    <!-- Tell the browser to be responsive to screen width -->
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">

    <!-- Bootstrap 3.3.5 -->
{!! Html::style('theme_components/bootstrap/css/bootstrap.min.css') !!}


    @yield('style')

</head>
<body>
<div class="text-center">
    <span style="text-align:center">
         <img
                 src="/images/bkash.png"
                 width="100"
                 height="50"
                 alt="bKash Payment"
                 style="margin:10px;"
         />
        {{--<h1>Payment</h1>--}}
        <p style="text-align:center">
          {{--<span>Invoice:&nbsp;</span><span class="invoice">10110</span>--}}
          <span>Invoice/Slip No:&nbsp;</span><span class="invoice">{{$invoice_no}}</span>
        </p>
        <p style="text-align:center">
          {{--<span>TK&nbsp;</span><span class="amount">1.00</span>--}}
          <b><span>TK&nbsp;</span><span class="amount">{{$total_amount}}</span></b>
        </p>

        <p style="text-align:center">
                 <a href="{{ url('/student/payment/master') }}" class="btn btn-info">
                     <i class="fa fa-arrow-left" aria-hidden="true"></i>
                        Back</a>&nbsp;<button class="btn btn-primary" id="bKash_button">
                    <i class="fa fa-credit-card-alt" aria-hidden="true"></i>
                    Payment</button>
         </p>
    </span>

</div>

</body>

<script src="https://code.jquery.com/jquery-1.8.3.min.js" integrity="sha256-YcbK69I5IXQftf/mYD8WY0/KmEDCv1asggHpJk1trM8=" crossorigin="anonymous"></script>
<script id = "myScript" src="https://scripts.sandbox.bka.sh/versions/1.2.0-beta/checkout/bKash-checkout-sandbox.js"></script>

<script>

    var accessToken='';
    $(document).ready(function(){
        $.ajaxSetup({
            headers:{
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        //===================================================

//        $.ajax({
//            url: "/site/payment-gateway/get-token",
//            type: 'POST',
//            contentType: 'application/json',
//            success: function (data) {
//                console.log('got data from token  ..');
//                console.log(JSON.stringify(data));
//
//                accessToken=JSON.stringify(data);
//            },
//            error: function(){
//                console.log('error');
//
//            }
//        });

        //=========================================================
        var paymentConfig={
            createCheckoutURL:"/site/payment-gateway/create-bkash-payment",
            executeCheckoutURL:"/site/payment-gateway/execute-bkash-payment",
        };


        var paymentRequest;
//        paymentRequest = { amount:101, intent:'sale', invoice:'1012'};
        paymentRequest = { amount:$('.amount').text(), intent:'sale', invoice:$('.invoice').text()};
        console.log(JSON.stringify(paymentRequest));


        //==========================================================

        bKash.init({
            paymentMode: 'checkout',
            paymentRequest: paymentRequest,
            createRequest: function(request){
                console.log('=> createRequest (request) :: ');
                console.log(request);

                $.ajax({
                    url: paymentConfig.createCheckoutURL+"?amount="+paymentRequest.amount+"&invoice="+paymentRequest.invoice,
                    type:'GET',
                    contentType: 'application/json',
                    success: function(data) {
                        console.log('got data from create  ..');
                        console.log('data ::=>');
                        console.log(JSON.stringify(data));

                        var obj = JSON.parse(data);

                        if(data && obj.paymentID != null){
                            paymentID = obj.paymentID;
                            bKash.create().onSuccess(obj);
                        }
                        else {
                            console.log('error');
                            bKash.create().onError();
                        }
                    },
                    error: function(){
                        console.log('error');
                        bKash.create().onError();
                    }
                });
            },

            executeRequestOnAuthorization: function(){
                console.log('=> executeRequestOnAuthorization');
                console.log(paymentID);
                $.ajax({
                    url: paymentConfig.executeCheckoutURL+"?paymentID="+paymentID,
                    type: 'GET',
                    contentType:'application/json',
                    success: function(data){
                        console.log('got data from execute  ..');
                        console.log('data ::=>');
                        console.log(JSON.stringify(data));

                        data = JSON.parse(data);
                        if(data && data.paymentID != null){
                            window.location.href = "{!!route('site-option-view-form')!!}";
//                            window.location.href = "/student/payment/master";
                        }
                        else {
                            bKash.execute().onError();
                        }
                    },
                    error: function(){
                        bKash.execute().onError();
                    }
                });
            }
        });

        console.log("Right after init ");
    });

    function callReconfigure(val){
        bKash.reconfigure(val);
    }

    function clickPayButton(){
        $("#bKash_button").trigger('click');
    }

</script>

<style>
    @page {
        size: a4;
        margin: 1px 0;
    }
    body {
        margin: 5px 20px 0;
        border:1px dotted black;
    }

</style>
</html>