<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>{{ $title_view }}</title>

    <style type="text/css">
        * {
            font-family: Verdana, Arial, sans-serif;
        }

        table {
            font-size: x-small;
            width: 100%;
            border-collapse: collapse;
        }

        tfoot tr td {
            font-weight: bold;
            font-size: x-small;
        }

        .amount-right {
            text-align: right;
        }

        .gray {
            background-color: lightgray;
        }

        .table-header {
            background-color: #b3dbff;
            font-weight: bold;
        }

        .text-center {
            text-align: center;
        }

        .text-right {
            text-align: right;
        }

        table.payment-history-table th,
        table.payment-history-table td {
            border: 1px solid #ddd;
            padding: 5px;
        }

        ,
        td {
            border: 1px solid #ddd;
            padding: 5px;
        }

        table>th,
        td {
            border: none;
            padding: 5px;
        }
    </style>
</head>

<body>

    <div>
        @include('default.site.layout.pdf-header')

        <table class="payment-history-table" style="margin-top: 20px;">
            <thead>

                <tr class="table-header">
                    <th style="text-align: center">SL</th>
                    <th style="text-align: left">Std Name</th>
                    <th style="text-align: center">Roll</th>
                    <th style="text-align: center">User ID</th>
                    <th style="text-align: center">Demand Slip No</th>
                    <th class="text-center">Generate Date</th>
                    <th class="text-right">Payable Amount</th>

                </tr>
            </thead>

            <tbody>
                @foreach ($data_list as $index => $payment)
                    <tr>
                        <td class="text-center">{{ $index + 1 }}</td>

                        <td class="text-center">{{ $payment['student_name'] ?? 'N/A' }}</td>
                        <td class="text-center">{{ $payment['student_roll_number'] ?? 'N/A' }}</td>
                        <td class="text-center">{{ $payment['user_name'] ?? 'N/A' }}</td>
                        <td class="text-center">{{ $payment['demand_slip_no'] ?? 'N/A' }}</td>
                        <td class="text-center">{{ $payment['generate_date'] ?? 'N/A' }}</td>
                        <td class="text-right">{{ number_format($payment['payable_amount'], 2) }}</td>
                    </tr>
                @endforeach
            @if (count($data_list) == 0)
                <tr>
                    <td colspan="7" class="text-center">No data found</td>
                </tr>

            @endif


            </tbody>
        </table>
    </div>

    <style>
        @page {
            size: A4;
            margin: 10px;
        }

        body {
            margin: 10px;
        }
    </style>

</body>

</html>
