<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>{{$title_view}}</title>

    <style type="text/css">

        * {
            font-family: Verdana, Arial, sans-serif;
        }
        table{
            font-size: x-small;
        }
        tfoot tr td{
            font-weight: bold;
            font-size: x-small;
        }

        .amount-right{
            text-align:right;
        }

        .gray {
            background-color: lightgray
        }

    </style>

</head>
<body>

<div>

    @include('default.site.layout.pdf-header')

    <table width="100%" style="margin-bottom: 10px">


        <tr>
            <td align="left"><b> Username:</b> {{$student_info['username']}}</td>
            <td align="left"><b> Name:</b> {{$student_info['name']}}</td>
            <td align="left"><b> Roll:</b> {{$student_info['roll']}}</td>

        </tr>
        {{-- <tr>
            <td colspan="2" valign="top" align="left"><b> Father Name:</b> {{$student_info['father_name']}}</td>
            <td colspan="2" valign="top" align="left"><b> Mother Name:</b> {{$student_info['mother_name']}}</td>
           
        </tr> --}}
        <tr>
            <td align="left"> <b>Version:</b> {{$student_info['version_name']}}</td>
            <td align="left"> <b>Year:</b> {{$student_info['year_name']}}</td>
            <td align="left"> <b>Shift:</b> {{$student_info['shift_name']}}</td>
        </tr>
        <tr>
            <td align="left"><b> Class:</b> {{$student_info['class_name']}}</td>
            <td align="left"><b> Group:</b> {{$student_info['group_name']}}</td>
            <td align="left"> <b>Section:</b> {{$student_info['section_name']}}</td>
        </tr>
        <tr>
            <td align="left"> <b>Type:</b> {{$student_info['type_name']}}</td>
            <td align="left"> <b>Session:</b> {{$student_info['session_name']}}</td>
            <td align="left"><b> Invoice No:</b> {{$payment_data['voucher_no']}}</td>

        </tr>
        <tr>
            <td align="left"><b> Invoice Date:</b> {{$payment_data['invoice_date']}}</td>
            <td align="left"><b> Invoice By:</b> {{$payment_data['slip_created_by']}}</td>
            <td align="left"><b> Payment Date:</b> {{$payment_data['payment_date']}} </td>
        </tr>
        <tr>
            <td align="left"><b> Payment By:</b>{{$payment_data['payment_created_by']}} </td>
            <td align="left"><b> Transaction ID:</b> {{$payment_data['transaction_id']}}</td>
            <td align="left"></td>
        </tr>

    </table>


    <table width="100%">

        <thead style="background-color: #e2e6e9;">
        <tr>
            <th align="left">Head</th>
            <th align="left">Type</th>
            @if(($slip_key == 'student' && $siteInfo['show_subhead_in_payment_slip']) || $slip_key != 'student')
                <th align="left">Fee Items</th>
            @endif
            <th align="center" class="amount-right">Amount</th>
        </tr>
        </thead>
        <tbody>

              @if(!empty($payment_data['fee_allocation_details_list']) && count($payment_data['fee_allocation_details_list']) > 0)
                @foreach($payment_data['fee_allocation_details_list'] as $index=>$item)
                    @foreach($item['head_type'] as $indexs=>$items)
                        @foreach($items['fee_sub_head'] as $indexss => $subItem)
                            <tr>
                                {{-- Fee Head --}}
                                @if($indexs == 0 && $indexss == 0)
                                    <td rowspan="{{ $item['head_type_base_sub_head_count'] }}">
                                        {{ $item['name'] }}
                                    </td>
                                @endif

                                {{-- Fee Type --}}
                                @if($indexss == 0)
                                    <td rowspan="{{ $items['fee_sub_head_count'] }}">
                                        {{ $items['fee_type_name'] }}
                                    </td>
                                @endif

                                @if(($slip_key == 'student' && $siteInfo['show_subhead_in_payment_slip']) || $slip_key != 'student')
                                    <td>
                                        {{ $subItem['academic_fee_sub_head']['name'] }}
                                    </td>
                                    <td class="amount-right">
                                        {{$subItem['amount']}}
                                    </td>
                                @else
                                    @if($indexss == 0)
                                        <td class="amount-right">
                                            {{$items['head_total_amount'] }}
                                        </td>
                                    @endif
                                @endif
                            </tr>
                        @endforeach
                    @endforeach
                @endforeach
            @endif


        @php($sl=1)
    

        <tr style="background-color: #e2e6e9">
            <td style="padding:0px;" colspan="{{($slip_key == 'student' && $siteInfo['show_subhead_in_payment_slip']) || $slip_key != 'student'
?2:1}}" class=""></td>
            <td style="padding:0px;" class="amount-right">Fee(TK)</td>
            <td style="padding:0px;" class="amount-right">{{$payment_data['fee_amount']}}</td>
        </tr>

        {{----------------------waiver details------------------------}}

              @if(!empty($payment_data['waiver_allocation_details']) && count($payment_data['fee_allocation_details_list']) > 0 && $siteInfo->show_subhead_in_payment_slip)
                    @foreach($payment_data['waiver_allocation_details'] as $index=>$item)
                        @foreach($item['head_type'] as $indexs=>$items)
                            @foreach($items['fee_sub_head'] as $indexss => $subItem)
                                <tr>
                                    {{-- Fee Head --}}
                                    @if($indexs == 0 && $indexss == 0)
                                        <td rowspan="{{ $item['head_type_base_sub_head_count'] }}">
                                            {{ $item['name'] }}
                                        </td>
                                    @endif

                                    {{-- Fee Type --}}
                                    @if($indexss == 0)
                                        <td rowspan="{{ $items['fee_sub_head_count'] }}">
                                            {{ $items['fee_type_name'] }}
                                        </td>
                                    @endif

                                    {{-- Fee Sub Head --}}
                                    <td>
                                        {{ $subItem['academic_fee_sub_head']['name'] }}
                                    </td>

                                    {{-- Amount --}}
                                    <td class="amount-right">
                                        {{$subItem['percantage_status'] ? $subItem['amount']. '%' : $subItem['amount']}}
                                    </td>
                                </tr>
                            @endforeach
                        @endforeach
                    @endforeach
                @endif


        <tr class="table_tr">
            <td  colspan="{{($slip_key == 'student' && $siteInfo['show_subhead_in_payment_slip']) || $slip_key != 'student'
?2:1}}" class=""></td>
            <td  class="amount-right">Waiver(TK)</td>
            <td  class="amount-right">{{$payment_data['waiver_amount']}}</td>
        </tr>
        {{-- <tr class="table_tr">
            <td  colspan="2" class=""></td>
            <td  class="amount-right">Special Waiver(TK)</td>
            <td  class="amount-right">{{$payment_data['special_waiver_amount']}}</td>
        </tr> --}}
        <tr class="table_tr">
            <td  colspan="{{($slip_key == 'student' && $siteInfo['show_subhead_in_payment_slip']) || $slip_key != 'student'
?2:1}}" class=""></td>
            <td  class="amount-right">Previous Due(TK)</td>
            <td  class="amount-right">{{$payment_data['previous_due']}}</td>
        </tr>
        <tr class="table_tr">
            <td  colspan="{{($slip_key == 'student' && $siteInfo['show_subhead_in_payment_slip']) || $slip_key != 'student'
?2:1}}" class=""></td>
            <td  class="amount-right">Extra Payment/Fine(TK)</td>
            <td  class="amount-right">{{$payment_data['fine_amount']}}</td>
        </tr>
        <tr class="table_tr">
            <td colspan="{{($slip_key == 'student' && $siteInfo['show_subhead_in_payment_slip']) || $slip_key != 'student'
?2:1}}" class="colorChange"></td>
            <td class="amount-right colorChange">Total(TK)</td>
            <td class="amount-right">{{$payment_data['total_amount']}}</td>
        </tr>
        @if($payment_data['paid_by']=='cash')
        <tr class="table_tr">
            <td colspan="{{($slip_key == 'student' && $siteInfo['show_subhead_in_payment_slip']) || $slip_key != 'student'
?2:1}}" class="colorChange"></td>
            <td class="amount-right colorChange">Previous Paid(TK)</td>
            <td class="amount-right">{{$payment_data['previous_paid_amount']}}</td>
        </tr>
        @endif
        <tr class="table_tr">
            <td colspan="{{($slip_key == 'student' && $siteInfo['show_subhead_in_payment_slip']) || $slip_key != 'student'
?2:1}}" class="colorChange"></td>
            <td class="amount-right colorChange">Transation Amount(TK)</td>
            <td class="amount-right">{{$payment_data['transaction_amount']}}</td>
        </tr>
        <tr class="table_tr">
            <td colspan="{{($slip_key == 'student' && $siteInfo['show_subhead_in_payment_slip']) || $slip_key != 'student'
?2:1}}" class="colorChange"></td>
            <td class="amount-right colorChange">Gateway Charge(TK)</td>
            <td class="amount-right">{{$payment_data['gateway_charge']}}</td>
        </tr>
        <tr class="table_tr">

            <td colspan="{{($slip_key == 'student' && $siteInfo['show_subhead_in_payment_slip']) || $slip_key != 'student'
?2:1}}"><b>In Word:</b> {{$payment_data['total_paid_amount_in_word']}} taka only</td>
            <td class="amount-right colorChange"><b>Payment Received (Paid TK)</b></td>
            <td class="amount-right"><b>{{$payment_data['paid_amount']}}</b></td>
        </tr>
        <tr class="table_tr">
            <td  colspan="{{($slip_key == 'student' && $siteInfo['show_subhead_in_payment_slip']) || $slip_key != 'student'
?2:1}}"></td>
            <td  class="amount-right colorChange">Due(TK)</td>
            <td  class="amount-right">{{$payment_data['due_amount']}}</td>
        </tr>

        </tbody>

    </table>
    <br><br><br>
    <table width="100%">
        <tr>
            <td align="left">
                {{--Print Date: {{date('d-m-Y h:i:s A',time())}}--}}
            </td>
            <td align="right" colspan="1">
                ------------------------<br>
                sign by authority
            </td>
        </tr>

    </table>
    <br> <br> <br>
    <table width="100%">
        <tr>
            <td>

            </td>

        </tr>
    </table>




</body>



<style>
    @page {
        size: a4;
        margin: 1px 0;
    }
    body {
        margin: 5px 20px 0;
        border:1px dotted black;
    }
    .table_tr {
        background-color: #e2e6e9
    }

</style>
</html>