<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>{{$title_view}}</title>

    <style type="text/css">

        * {
            font-family: Verdana, Arial, sans-serif;
        }
        table{
            font-size: x-small;
        }
        tfoot tr td{
            font-weight: bold;
            font-size: x-small;
        }

        .amount-right{
            text-align:right;
        }

        .gray {
            background-color: lightgray
        }

        .slot-table td {
            border: 1px solid #999999;
            border-width: thin;
            border-spacing: 2px;
            /*border-style: none;*/

        }

        .heading-slot-bg {
            background-color: #dcdcdc;
            color: #000000;
            text-align: center;
            width: 25px;
            vertical-align: middle;
            padding-left: 20px;
        }

        .slot {
            width: 100px;
            min-height: 200px;
            padding: 0 3px;
        }

    </style>

</head>
<body>
@include('default.site.layout.pdf-header')


<table width="100%">
    <tr>
        <td align="left"> <b>Shift:</b> {{$class_shift_details->shift_name ?? ""}}</td>
        @if(count($class_list))
            <td align="left" > <b>Class:</b> 
                @foreach($class_list as $class)
                    {{$class->class_name}},
                @endforeach
            </td>
        @endif
        @if(count($class_group_list))
            <td align="left"> <b>Class Group:</b> 
                @foreach($class_group_list as $group)
                    {{$group->group_name}},
                @endforeach
            </td>
        @endif
        @if(count($section_list))
            <td align="left"> <b>Section:</b> 
                @foreach($section_list as $section)
                    {{$section->section_name}},
                @endforeach
            </td>
        @endif
        <td align="left"><b> From Date:</b> {{$from_date ?? ""}}</td>
        <td align="left"><b> To Date:</b> {{$to_date ?? ""}}</td>
    </tr>

</table>

<table class="slot-table" width="100%" cellspacing="0" border="0">
    <thead style="background-color:  #e6e6e6;">
    <tr>
        <td  style="text-align:center; padding:2px; border: 1px solid black;"><b>Serial</b></td>
        <td  style="padding:2px; border: 1px solid black;"><b>Student</b></td>
        <td  style="padding:2px; border: 1px solid black; text-align:center"><b>Roll</b></td>
        <td  style="padding:2px; border: 1px solid black; text-align:center"><b>Class</b></td>
        @if($class_group_present)
            <td  style="padding:2px; border: 1px solid black; text-align:center"><b>Group</b></td>
        @endif
        @if($section_present)
            <td  style="padding:2px; border: 1px solid black; text-align:center"><b>Section</b></td>
        @endif
        @if($session_present)
            <td  style="padding:2px; border: 1px solid black; text-align:center"><b>Session</b></td>
        @endif
        @foreach($subHeadList as $subhead)
            <td  style="padding:2px; border: 1px solid black;" class="amount-right"><b>{{$subhead['name']}}</b></td>
        @endforeach
        <td  style="padding:2px; border: 1px solid black;" class="amount-right"><b>Fine</b></td>
        <td  style="padding:2px; border: 1px solid black;" class="amount-right"><b>Total Amount</b></td>
 
    </tr>
    </thead>
    <tbody>


    @php($sl=1)
    @foreach($paymentList as $key=>$item)

        <tr>
            <td style="text-align:center; padding:2px; border: 1px solid black;">{{$key+1}}</td>
            <td style="padding:2px; border: 1px solid black;">{{$item['student_history']['full_name_username']}}</td>
            <td style="padding:2px; border: 1px solid black; text-align:center">{{$item['student_history']['student_full_roll_number']}}</td>
            <td style="padding:2px; border: 1px solid black; text-align:center">{{$item['student_history']['st_class']?$item['student_history']['st_class']['class_name']:''}}</td>
           
            @if($class_group_present)
                <td style="padding:2px; border: 1px solid black; text-align:center">{{$item['student_history']['acc_group']?$item['student_history']['acc_group']['group_name']:''}}</td>
            @endif
            @if($section_present)
                <td style="padding:2px; border: 1px solid black; text-align:center">{{$item['student_history']['section']?$item['student_history']['section']['section_name']:''}}</td>
            @endif
            @if($session_present)
                <td style="padding:2px; border: 1px solid black; text-align:center">{{$item['student_history']['session']?$item['student_history']['session']['session_name']:''}}</td>
            @endif

            {{-- <template v-for="(sub_heade_item,indexs) in item.sub_head_list">
                <template v-for="(subHead,indexss) in subHeadList">
                <template v-if="subHead.id==sub_heade_item.sub_head_id"> --}}
           
            @foreach($subHeadList as $subHead)
                @foreach($item['sub_head_list'] as $sub_heade_item)
                    @if($subHead['id']==$sub_heade_item['sub_head_id'])
                        <td class="amount-right" style="padding:2px; border: 1px solid black;">{{number_format($sub_heade_item['total_pay_amount'],2)}}</td>
                    @endif
                @endforeach
             
            @endforeach
            <td class="amount-right" style="padding:2px; border: 1px solid black;">{{number_format($item['fine_amount'],2)}}</td>
            <td class="amount-right" style="padding:2px; border: 1px solid black;">{{number_format($item['sub_total_pay_amount'],2)}}</td>

            {{-- <td class="amount-right" style="padding:2px; border: 1px solid black;">{{$item['total_payable_amount']==0?"0.00":number_format($value['total_generate_amount']).".00"}}</td>
            <td class="amount-right" style="padding:2px; border: 1px solid black;">{{$item['total_fine_amount']==0?"0.00":number_format($value['total_fine_amount']).".00"}}</td>
            <td class="amount-right" style="padding:2px; border: 1px solid black;">{{$item['total_waiver_amount']==0?"0.00":number_format($value['total_waiver_amount']).".00"}}</td>
            <td class="amount-right" style="padding:2px; border: 1px solid black;">{{$item['total_payable_amount']==0?"0.00":number_format($value['total_payable_amount']).".00"}}</td>
            <td class="amount-right" style="padding:2px; border: 1px solid black;">{{$item['total_paid_amount']==0?"0.00":number_format($value['total_paid_amount']).".00"}}</td>
            <td class="amount-right" style="padding:2px; border: 1px solid black;">{{$item['total_due_amount']==0?"0.00":number_format($value['total_due_amount']).".00"}}</td> --}}
        </tr>

    @endforeach


    </tbody>
    <tfoot  style="background-color:  #e6e6e6;">
    <tr>
        <td colspan="{{4+($class_group_present?1:0)+($section_present?1:0)+($session_present?1:0)}}" class="amount-right" style="border: 1px solid black;">Total</td>
        @foreach($grossReport['subhead_total_array'] as $subhead_total)
            <td class="amount-right" style="border: 1px solid black;">{{number_format($subhead_total['subhead_total'],2)}}</td>
        @endforeach
        <td class="amount-right" style="border: 1px solid black;">{{number_format($grossReport['total_fine_amount'],2)}}</td>
        <td class="amount-right" style="border: 1px solid black;">{{number_format($grossReport['total_pay_amount'],2)}}</td>
        {{-- <td class="amount-right" style="border: 1px solid black;">{{$total_waiver_amount==0?"0.00":$total_waiver_amount.".00"}}</td>
        <td class="amount-right" style="border: 1px solid black;">{{$total_payable_amount==0? "0.00":$total_payable_amount.".00"}}</td>
        <td class="amount-right" style="border: 1px solid black;">{{$total_paid_amount==0?"0.00":$total_paid_amount.".00"}}</td>
        <td class="amount-right" style="border: 1px solid black;">{{$total_due_amount==0?"0.00":$total_due_amount.".00"}}</td> --}}

    </tr>
    </tfoot>

</table>

</body>



<style>
   @page {
    size: A4 landscape; /* Set to A4 landscape */
    margin: 1px 0;
    }

    body {
        margin: 5px 20px 0;
        /* border: 1px dotted black; */
    }

</style>
</html>