<!DOCTYPE html>
<html>
<head>

    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no'
          name='viewport'>

    <title>{{$report_tittle}}</title>

    <style>



        body{
            font-family: Verdana;
        }


        .tittle {
            background-color: #dcdcdc;
            border-radius: 10px;
            width: 100%;
            color: #000000;
            padding: 5px;
            font-weight: bold;
        }

        .data-table td {
            border: 1px solid #999999;
            text-align: center;
        }




    </style>

</head>
<body>


@if($att_type==1)

<table width="100%;" border="0">
    <tr>
        <td style="width: 25%">
            <img src="{{asset("img/site").'/'.$site->site_logo}}" width="55" height="55">
        </td>
        <td style="width: 50%; text-align: center">
            <span style="font-size: 20px;">{{$site->site_name}}</span> <br>
            <span style="font-size: 15px;">{{$site->address}}</span> <br>
            <span style="font-size: 12px;">

            </span> <br>

            <span class="tittle">Student Attendance Report For {{date('d-m-Y',strtotime($att_date))}}</span>

        </td>
        <td style="width: 25%; font-size: 12px; text-align: right; vertical-align: bottom;">
            <b>Printed :</b> {{date('d-m-Y h:i:s A',time())}}
        </td>

    </tr>
</table>

<div>
    <table class="data-table" cellspacing="0" border="0" width="100%;" style="">

        <thead class="tittle">
        <tr>
            <td style="width: 1px">S/L</td>
            <td>Name</td>
            <td>Dept</td>
            <td>Class</td>
            <td>Section</td>
            <td>Shift</td>
            <td>In</td>
            <td>Out</td>
            <td>Late Status</td>

        </tr>
        </thead>


        <tbody>
        @foreach($att_data as $key => $value)

            <tr>
                <td>{{$key +1}}</td>
                <td>
                  <nobr>  {{$value->studentHistory->student->first_name ?? 'na'}}    {{$value->studentHistory->student->last_name ?? 'n/a'}}</nobr>

                </td>
                <td>{{$value->studentHistory->department->name ?? 'n/a'}}</td>
                <td>{{$value->studentHistory->stClass->class_name ?? 'n/a'}}</td>
                <td>{{$value->studentHistory->section->section_name ?? 'n/a'}}</td>
                <td>{{$value->studentHistory->shift->shift_name ?? 'n/a'}}</td>
                <td>
                  {{$value->in_time ? date('h:i:s A',strtotime($value->in_time)) : 'n/a'}}
                </td>
                <td>
                    {{$value->out_time ? date('h:i:s A',strtotime($value->out_time)) : 'n/a'}}
                </td>

                <td>
                    {{getLateIntime( $value->late_status)}}
                </td>

            </tr>


        @endforeach
        </tbody>


    </table>
</div>


@elseif($att_type==2)


  @include('default.site.report-header.hearder1')

    <div>
        <table class="data-table" cellspacing="0" border="0" width="100%;" style="">

            <thead class="tittle">
            <tr>
                <td style="width: 1px">S/L</td>
                <td>Name</td>
                <td>Dept</td>
                <td>Class</td>
                <td>Section</td>
                <td>Shift</td>
                <td>In</td>
                <td>Out</td>
                <td>Late Status</td>

            </tr>
            </thead>


            <tbody>
            @foreach($att_data as $key => $value)

                <tr>
                    <td>{{$key +1}}</td>
                    <td>
                        {{$value->studentHistory->student->first_name ?? 'na'}}    {{$value->studentHistory->student->last_name ?? 'na'}}
                        <br>
                    </td>
                    <td>{{$value->studentHistory->department->name ?? 'na'}}</td>
                    <td>{{$value->studentHistory->stClass->class_name ?? 'na'}}</td>
                    <td>{{$value->studentHistory->section->section_name ?? 'na'}}</td>
                    <td>{{$value->studentHistory->shift->shift_name ?? 'n/a'}}</td>
                    <td>
                        {{$value->in_time ? date('h:i:s A',strtotime($value->in_time)) : 'n/a'}}
                    </td>
                    <td>
                        {{$value->out_time ? date('h:i:s A',strtotime($value->out_time)) : 'n/a'}}
                    </td>

                    <td>
                        {{getLateIntime( $value->late_status)}}
                    </td>

                </tr>


            @endforeach
            </tbody>


        </table>
    </div>


@endif


</body>


<style>

    @page {
        size: a4;
        margin: 0px;
    }

    body {
        margin: 10px 20px 50px 20px;
    }


</style>

</html>












