<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <style>
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }

        th,
        td {
            border: 1px solid #ddd;
            padding: 4px;
            text-align: center;
            font-size: 10px;
        }

        body {
            margin: 0;
            padding: 5px;
        }

        .badge {
            padding: 5px;
            border: 1px solid red;
            color: white;
        }

        .btn-success {
            background-color: #00a65a;
            border-color: #008d4c;
        }

        .btn {
            border-radius: 3px;
            -webkit-box-shadow: none;
            box-shadow: none;
            border: 1px solid transparent;
        }
    </style>
</head>

<body>
    <div>
        <div class="page">
            <div class="headerco" style="width: 100%;">
                <table style="width: 100%; border: none;">
                    <tr>
                        <td style="width: 10%; text-align: left; border: none;">
                            <img style="text-align: center; padding-top: 0px;" width="70px" height="70px"
                                src="{{ public_path('img/site_group/logo/' . $SiteGroupInfo['group_logo']) }}">
                        </td>
                        <td style="width: 100%; text-align: center; padding-right: 100px; border: none;">
                            <span style="font-size: 25px">{{ $SiteGroupInfo['name'] }}</span> <br>
                            <span style="font-size: 15px"> Education Department </span>
                        </td>
                    </tr>
                </table>
            </div>
            <div class="header-right" style="text-align: center">
                {{-- <strong>{{ $site->site_name }}</strong> <br> --}}
                <span>Employee Attendance Report</span> <br>
            </div>

            <div class="row">
                <div class="col-sm-12 col-md-12 col-lg-12">

                </div>
            </div>

            <div class="row display-flex">
                <div class="table table-responsive" style="margin-top:10px;">
                    @if (!empty($TotalCount))
                        <span>
                            Site : <span style="color: red;">{{ $TotalCount['total_Grpup_site'] }}</span>
                        </span>
                        <span>
                            Employees : <span style="color: red;">{{ $TotalCount['total_Group_employees'] }}</span>
                        </span>
                        <span>
                            Present : <span style="color: red;">{{ $TotalCount['Total_present'] }}</span>
                        </span>
                        <span>
                            Absent : <span style="color: red;">{{ $TotalCount['total_absent'] }}</span>
                        </span>
                        <span>
                            Leave : <span style="color: red;">{{ $TotalCount['total_leave'] }}</span>
                        </span>
                        <span>
                            Duty : <span style="color: red;">{{ $TotalCount['total_duty'] }}</span>
                        </span>
                    @endif
                    <table class="table table-responsive table-striped table-bordered studentlist">
                        <thead>
                            <tr class="bg-info">
                                <th>#</th>
                                <th>Institution</th>
                                <th>Total Employee</th>
                                <th>Total Present</th>
                                <th>Total Leave</th>
                                <th>Total Duty</th>
                                <th>Total Absent</th>
                            </tr>
                        </thead>
                        <tbody>
                            @if (empty($groupWiseSiteEmployeeAttendence))
                                <tr>
                                    <td class="text-center" colspan="7">
                                        <span class="text-red">No Data Found!</span>
                                    </td>
                                </tr>
                            @else
                                @foreach ($groupWiseSiteEmployeeAttendence as $index => $site)
                                    <tr>
                                        <td>{{ $index + 1 }}</td>
                                        <td>{{ $site['site_name'] }}</td>
                                        TotalEmplployee
                                        {{-- Total_present
Total_leave
Total_duty
Total_absent
off_day --}}
                                        @if ($site['off_day'])
                                            <td colspan="5">
                                                <span class="badge" style="background: #49B774;font-size: 17px;">Day
                                                    Off</span>
                                            </td>
                                        @else
                                            <td>{{ $site['TotalEmplployee'] }}</td>
                                            <td>{{ $site['Total_present'] }}</td>
                                            <td>{{ $site['Total_leave'] }}</td>
                                            <td>{{ $site['Total_duty'] }}</td>
                                            <td style="color: red;">{{ $site['Total_absent'] }}</td>
                                        @endif
                                    </tr>
                                @endforeach
                            @endif
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</body>

<style>
    @page {
        size: Landscape;
        margin: 1px 0;
    }

    body {
        margin: 10px 10px 10px 20px;
    }
</style>

</html>
