<!DOCTYPE html>
<html>

<head>
    {{-- @set('site',getSiteInfoForPdf()) --}}
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>

    <title>{{ $page_tittle }}</title>

    <style>
        @font-face {
            font-family: 'Verdana';
            font-weight: 100;
            font-style: normal;
            font-variant: normal;
            src: url("{{ public_path() }}/fonts/Verdana.ttf") format("truetype");
        }

        body {
            font-family: "Verdana", sans-serif;
            font-size: 12px;
        }

        .tittle {

            border-radius: 10px;
            width: 100%;
            color: #000000;
            padding: 5px;
        }

        .data-table td,
        th {
            border: 1px dotted #999999;
            text-align: center;
        }

        .data-table tfoot th {
            border: none !important;
            text-align: center;
        }
    </style>

</head>

<body>

    <table width="100%;" border="0">
        <tr>
            <td style="width: 25%;">
                <span>
                    <img style="float: left" src="{!! public_path('img/site_group/logo/' . $SiteGroupInfo['group_logo']) !!}" width="60" height="55">
                </span>
            </td>
            <td style="width: 50%; text-align: center; /*border: 1px solid green*/">

                <div style="width: 100%; text-align: center">
                    <span class="sitename" style="font-size: 14px; font-weight:bold ">{{ $SiteGroupInfo['name'] }}</span>
                    <br>
                    {{-- <span style="font-size: 11px;">{!! $site->address !!}</span><br> --}}
                    <span style="font-weight: bold">{!! $report_tittle !!} </span>
                </div>
            </td>
            <td style="width: 25%;font-size: 10px;text-align: right;vertical-align: top;">
                <b>Printed :</b> {{ date('d M Y h:i:s A', time()) }}
            </td>
        </tr>
    </table>


    <table width="100%;" border="0">
        <tr>
            <td style="width: 50%; font-size: 10px;">
                <span class="tittle">{!! $report_tittle2 !!}</span>

            </td>

            <td style="width: 30%; font-size: 10px; text-align: right; vertical-align: bottom; margin-top:50px">
                {{-- <b>Printed :</b> {{date('d M Y h:i:s A',time())}} --}}
            </td>
        </tr>
    </table>



    <div>
        <table class="data-table" cellspacing="0" border="0" width="100%;">
            <thead class="tittle">
                <tr style="background-color: #f2f2f2; padding: 60px;">
                    <th>S/L</th>
                    <th>Date</th>
                    <th>Subject(s)</th>
                    <th>Subject(s) Code</th>
                </tr>
            </thead>
            <tbody>

                @foreach ($groupedArray as $key => $item)
                    <tr>
                        <td>{{ $key + 1 }}</td>
                        <td>{{ $item['exam_start_date'] ?? '--' }} <br> {{ $item['dayName'] }}</td>
                        <td>
                            {!! implode('<br>', $item['subjects']) !!}
                        </td>
                        <td>
                            {!! implode('<br>', $item['subject_code']) !!}
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>


</body>


<style>
    @if ($report_type)
        @page {
            size: a4;
            margin: 0px;
        }

    @else
        @page {
            size: Landscape;
            margin: 0px;
        }

    @endif

    body {
        margin: 10px 20px 50px 20px;
    }
</style>

</html>
