<!DOCTYPE html>
<html>

<head>
    {{-- @set('site',getSiteInfoForPdf()) --}}
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>

    <title>{{ $page_tittle }}</title>

    <style>
        @font-face {
            font-family: 'Verdana';
            font-weight: 100;
            font-style: normal;
            font-variant: normal;
            src: url("{{ public_path() }}/fonts/Verdana.ttf") format("truetype");
        }

        body {
            font-family: "Verdana", sans-serif;
            font-size: 12px;
        }

        .tittle {

            border-radius: 10px;
            width: 100%;
            color: #000000;
            padding: 5px;
        }

        .data-table td,
        th {
            border: 1px dotted #999999;
            text-align: center;
        }

        .data-table tfoot th {
            border: none !important;
            text-align: center;
        }
    </style>

</head>

<body>


    @include('default.site_group.layout.pdf-header')


    <div>
        <table class="data-table" cellspacing="0" border="0" width="100%;" style="">

            <thead class="tittle">
                <tr style="background-color: #f2f2f2;">
                    <th>S/L</th>
                    <th>
                        Student’s Name
                    </th>
                    <th>
                        User Name
                    </th>
                    <th>
                        Class Roll
                    </th>
                    <th>
                        Exam Roll
                    </th>
                    <th>
                        Input Mark
                    </th>

                </tr>
            </thead>


            <tbody>
                @foreach ($SingleSiteListArray['total_present_student'] as $key => $value)
                    <tr>
                        <td>{{ $key + 1 }}</td>
                        <td>
                            {{ $value['student_history']['full_name'] ?? 'na' }}
                        </td>
                        <td>
                            {{ $value['student_history']['username'] ?? 'na' }}
                        </td>
                        <td>
                            {{ $value['student_history']['full_roll_number'] ?? 'na' }}
                        </td>

                        <td>
                            {{ $value['student_history']['exam_roll_number'] ?? 'na' }}
                        </td>
                        <td>
                            {{ $value['obtaine_marks'] ?? 'na' }}
                        </td>

                    </tr>
                @endforeach
            </tbody>



        </table>
    </div>


</body>


<style>
    @if ($report_type)
        @page {
            size: a4;
            margin: 0px;
        }

    @else
        @page {
            size: Landscape;
            margin: 0px;
        }

    @endif

    body {
        margin: 10px 20px 50px 20px;
    }
</style>

</html>
