<!doctype html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    {{-- <title>{{$title_view}}</title> --}}

    <style>
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }

        th,
        td {
            border: 1px solid #ddd;
            padding: 4px;
            text-align: center;
            font-size: 10px;
        }


        body {
            width: 800pt;
            height: 550pt;
            margin: 0;
            padding: 5px;
            border: 1px solid black;
            outline: 5px solid green;
        }
    </style>

</head>

<body>

    <div>
        <div class="page">
            <div class="headerco" style="width: 100%;">
                <table style="width: 100%; border: none;">
                    <tr>
                        <td style="width: 10%; text-align: left; border: none;">
                            <img style="text-align: center; padding-top: 0px;" width="70px" height="70px;"
                                src="{!! public_path('uploads/' . $SiteGroupInfo['group_logo']) !!}">
                        </td>
                        <td style="width: 100%; text-align: center; padding-right: 100px; border: none;">
                            <span style="font-size: 25px">{{ $SiteGroupInfo['name'] }}</span> <br>
                            <span style="font-size: 15px">Education Department</span>
                        </td>
                    </tr>
                </table>
            </div>
            <div class="header-right" style="text-align: center">
                <strong>Employee subject list</strong><br>
                <strong>
                    {{ $groupWiseSiteEmployeeSubjectsCount['subject_name']}}
                </strong>
            </div>

            <table class="table table-bordered table-responsive table-striped">
                <thead>
                    <tr>
                        <th>Site ID</th>
                        <th>Site Name</th>
                        <th>Subject-wise Employee</th>
                        <th>Full Name</th>
                        <th>Contact Number</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($groupWiseSiteAllEmployeesSubjectList as $site)
                        @foreach ($site['Employees'] as $index => $employee)
                            @if ($index == 0)
                                <tr>
                                    <td rowspan="{{ count($site['Employees']) }}">{{ $site['site_id'] }}</td>
                                    <td rowspan="{{ count($site['Employees']) }}">{{ $site['site_name'] }}</td>
                                    <td rowspan="{{ count($site['Employees']) }}">{{ $site['EmployeeHasSubject'] }}</td>
                                    <td>{{ $employee['full_name'] }}</td>
                                    <td>{{ $employee['contact_number'] ?? '-' }}</td>
                                </tr>
                            @else
                                <tr>
                                    <td>{{ $employee['full_name'] }}</td>
                                    <td>{{ $employee['contact_number'] ?? '-' }}</td>
                                </tr>
                            @endif
                        @endforeach
                    @endforeach
                </tbody>
            </table>

        </div>

    </div>

</body>



<style>
    @page {
        size: Landscape;
        margin: 1px 0;
    }

    /*@page {*/
    /*size: a4;*/
    /*margin: 1px 0;*/
    /*}*/
    body {
        margin: 10px 10px 10px 20px;
    }
</style>

</html>
