<!doctype html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>{{ $title_view ?? 'Student List Count' }}</title>

    <style>
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }

        .table th,
        .table td {
            border: 1px solid #ddd;
            padding: 4px;
            text-align: center;
            font-size: 10px;
        }

        body {
            margin: 10px 10px 10px 20px;
        }

        @page {
            size: Landscape;
            margin: 1px 0;
        }
    </style>
</head>

<body>
    <table class="header">
        <tr>
            <td style="width: 15%;">
                <img style="float: left" src="{{ public_path('img/site_group/logo/' . $SiteGroupInfo['group_logo']) }}"
                    width="60" height="55">
            </td>
            <td style="width: 62%; text-align: center;">
                <div style="width: 100%; text-align: center"></div>
                <span style="font-size: 20px;">
                    {{ $SiteGroupInfo['name'] }}
                </span>
                <br>
                <span style="font-size: 11px;">Education Department</span>
                <br>
                <span class="title">Student List</span>
            </td>
            <td style="width: 23%; font-size: 10px; text-align: right; vertical-align: bottom;">
                <b>Printed :</b> {{ date('d M Y h:i:s A', time()) }}
            </td>
        </tr>
    </table>
    <div class="table">

        <table>
            <thead>
                <tr style="background-color: #f2f2f2;">
                    <th>#</th>
                    <th>Institution Name</th>
                    <th>No. of Student</th>
                    <th>Male</th>
                    <th>Female</th>
                    <th>Others</th>

                </tr>
            </thead>
            <tbody>
                @foreach ($groupWiseSiteStudentList as $index => $site)
                    <tr>
                        <td>{{ $index + 1 }}</td>
                        <td style="font-size: 10px;">{{ $site['site_name'] }}</td>
                        <td style="font-size: 10px;">{{ $site['total_students'] }}</td>
                        <td style="font-size: 10px;">{{ $site['total_boys'] }}</td>
                        <td style="font-size: 10px;">{{ $site['total_girls'] }}</td>
                        <td style="font-size: 10px;">{{ $site['total_others'] }}</td>

                    </tr>
                @endforeach
                <tr style="background-color: #e6cece;">


                    <td colspan="2" style="font-size: 10px;"><b style="">Total</b></td>
                    <td colspan="" style="font-size: 10px;"><b>{{ $total_count['total_students'] }}</b></td>
                    <td style="font-size: 10px;"><b>{{ $total_count['total_boys'] }}</b></td>
                    <td style="font-size: 10px;"><b>{{ $total_count['total_girls'] }}</b></td>
                    <td style="font-size: 10px;"><b>{{ $total_count['total_others'] }}</b></td>

                </tr>
            </tbody>
        </table>
    </div>
</body>

</html>
