
@extends('default.admin.layouts.master')

@section('style')
    {!! Html::style('css/styles.css') !!}
@endsection

@section('content')

    <div class="container-fluid min_height_area">

        <div class="row">
            <div class="col-md-12">
                <div class="view-header">
                    <section class="content-header">
                        <ol class="breadcrumb">
                            <li>
                                <span class="fa fa-dashboard" aria-hidden="true"></span>
                                <a href="{{route('admin')}}">{{ trans('translate.dashboard') }}</a>
                            </li>
                            <li class="active text-capitalize">{{ request()->route()->getName() }}</li>
                        </ol>
                    </section>
                </div>
            </div>

        </div>

        {{--<div class="row">--}}

            {{--<div class="col-md-12">--}}
                {{--<div class="view-header">--}}
                    {{--<section class="content-header">--}}
                        {{--<ol class="breadcrumb">--}}
                            {{--<li>--}}
                                {{--<span class="fa fa-dashboard" aria-hidden="true"></span>--}}
                                {{--<a href="{{route('admin')}}">{{ trans('translate.dashboard') }}</a></li>--}}
                            {{--<li class="active text-capitalize">--}}
                                {{--<a>{{ trans('breadcrumb.fee_allocation.list') }}</a>--}}
                                {{--                                <a href="{{route('student-attendance-list')}}">{{ trans('breadcrumb.fee_allocation.list') }}</a>--}}
                            {{--</li>--}}
                            {{--<li class="active text-capitalize">{{ trans('breadcrumb.fee_allocation.over_view') }}</li>--}}
                        {{--</ol>--}}
                    {{--</section>--}}
                {{--</div>--}}
            {{--</div>--}}

        {{--</div>--}}

        <div class="inner-box">
            <div class="row">
                <div class="col-md-12 snt form-horizontal">
                    @if (count($errors) > 0)
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    @if (session()->has('success'))
                        <div class="alert alert-success">
                            <ul>
                                <li>{{ session()->get('success') }}</li>
                            </ul>
                        </div>
                    @endif
                    {{--<a href="{{ route('add-student-attendance-form') }}"><i class="fa fa-plus"></i>  {{ trans('sidebar.add-student-attendance') }}</a>--}}
                </div>
            </div>
        </div>
        <div class="row">
            <site-fee-allocation-view-component>

            </site-fee-allocation-view-component>
        </div>
    </div>

@endsection


@section('scripts')

    @parent

    {!! Html::script('select/js/select2.min.js') !!}



@endsection

<script src="//code.jquery.com/jquery-1.11.3.min.js"></script>
<script src="https://code.jquery.com/ui/1.11.3/jquery-ui.min.js"></script>
<script>
    $('.date').datepicker({
        autoclose: true,
        dateFormat: "yy-mm-dd"
    });
</script>....


<script src="//code.jquery.com/jquery-1.11.3.min.js"></script>
<script src='https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.17.1/moment.min.js'></script>
<script src='https://cdnjs.cloudflare.com/ajax/libs/fullcalendar/3.1.0/fullcalendar.min.js'></script>

<script>
    $(document).ready(function() {
        // page is now ready, initialize the calendar...
        $('#calendar').fullCalendar({
            // put your options and callbacks here

            events : [
                    @foreach($item as $eventModel)
                {
                    title : '{{ $item->name }}',
                    start : '{{ $item->task_date }}',
                    url : '{{ route('tasks.edit', $item->id) }}'
                },
                @endforeach
            ]
        })
    });
</script>
