@inject('createSiteInfo','App\Forms\SiteInfoForm')

@extends('default.admin.layouts.master')

@section('style')
    {!! Html::style('css/styles.css') !!}
    {!! Html::style('datepicker/css/datepicker.css') !!}
    {!! Html::style('select/css/select2.min.css') !!}
@endsection

@section('content')

    <div class="container-fluid min_height_area" >
        <div class="row">
            <div class="col-md-12">
                <div class="student-box-header">
                    <div class="col-md-6 col-xs-5">
                        <span class="glyphicon glyphicon-user " aria-hidden="true"></span>{{ trans('sidebar.institute_create') }}
                    </div>
                    <div class="col-md-6 col-xs-7 snt">
                        <ul class="breadcrumb text-right">
                            <li>
                                <span class="glyphicon glyphicon-folder-close" aria-hidden="true"></span>
                                <a href="#">{{ trans('sidebar.dashboard') }}</a></li>
                            <li class="active">{{ trans('sidebar.institute_create') }}</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div> <!--row-->
        <div class="inner-view">
            <div class="row">
                <div class="col-md-12 snt form-horizontal">

                    @if (count($errors) > 0)
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                        @if(session()->has('success'))
                            <div class="alert alert-success">
                                <ul>

                                    <li>{{ session()->get('success') }}</li>

                                </ul>
                            </div>
                        @endif

                        <div class="custom_row">
                            {!! inputLangControl() !!}
                        </div>

                        <div class="custom_row">                      
                            <h2 class="form_title">
                                {{ trans('sidebar.institute_create') }}
                            </h2>                                          
                        </div>

                    {!! Form::open(array('route' => 'site-create', 'files' => true, 'id'=>'create-form','class'=>'form-create')) !!}


                        {!! formFields($createSiteInfo) !!}

                    {!!  Form::close()   !!}
                </div>
            </div>
        </div>
    </div>



@endsection
@section('scripts')


    @parent
    <script src="{{ asset('jquery-validation/dist/jquery.validate.min.js') }}"></script>
    {!! Html::script('select/js/select2.min.js') !!}
    {{-- <script>
         $("#create-form").validate();
     </script>--}}
    <script type="text/javascript">
        $(document).ready(function(){
            $('#country_id').select2();
            $('#division_id').select2();
            $('#district_id').select2();
            $(".translation_wrap").hide();
            $(".translation_wrap.trans_en"/*+lang_def*/).show();
            $(".control_lang").on("click",function(){
                var selected_lang = $(this).val();
                $(".translation_wrap").hide();
                $(".translation_wrap.trans_"+selected_lang).show();
                $(".control_lang").val(selected_lang);
            });



            /*-------------on change function for getting division-------------*/

            $('#country_id').change(function () {
                var host = window.location.origin ;

                var divisionId = $('#country_id').find('option:selected').val();

                $.ajax({
                    'url': host+'/division/list-by-id/'+divisionId,
                    'dataType': 'json',
                    success: function(data){
                        console.log(data);
                        var divisionList = "<option value=''>Select </option>";
                        //var subjectList = "<option value=''>Select </option>";

                        $(data[0]).each(function(index,item){

                            divisionList += "<option value ="+ item.id +">"+item.division_name+" </option>";

                        });

                        $('#division_id').html(divisionList);
                    },error: function (data) {
                        console.log(data)
                        $.growl.error({ message: data.responseText });
                    }
                });
            });

            /*-------------on change function for getting district-------------*/

            $('#division_id').change(function () {
                var host = window.location.origin ;

                var divisionId = $('#division_id').find('option:selected').val();

                $.ajax({
                    'url': host+'/district/list-by-id/'+divisionId,
                    'dataType': 'json',
                    success: function(data){
                        console.log(data);
                        var divisionList = "<option value=''>Select </option>";
                        //var subjectList = "<option value=''>Select </option>";

                        $(data[0]).each(function(index,item){

                            divisionList += "<option value ="+ item.id +">"+item.district_name+" </option>";

                        });

                        $('#district_id').html(divisionList);
                    }
                });
            });


            /*-------------on change function for getting thana-------------*/

            $('#district_id').change(function () {
                var host = window.location.origin ;

                var districtId = $('#district_id').find('option:selected').val();

                $.ajax({
                    'url': host+'/thana/list-by-id/'+districtId,
                    'dataType': 'json',
                    success: function(data){
                        console.log(data);
                        var thanaList = "<option value=''>Select </option>";
                        //var subjectList = "<option value=''>Select </option>";

                        $(data[0]).each(function(index,item){

                            thanaList += "<option value ="+ item.id +">"+item.thana_name+" </option>";

                        });

                        $('#thana_id').html(thanaList);
                    }
                });
            });

        });
    </script>


    {{--<script src="{{ asset('jquery-validation/dist/jquery.validate.js') }}"></script>--}}

@endsection