@extends('default.site.layout.master')


@section('style')

    <style>

        .row.display-flex {
            display: flex;
            flex-wrap: wrap;
            margin-right: 0;
            margin-left: 0;
        }

        .row.display-flex > [class*='col-'] {
            display: flex;
            flex-direction: column;
        }

        /* not requied only for demo * */
        .row [class*='col-'] {
            background-colo: #cceeee;
            background-clip: content-box;
        }

        .panel {
            height: 100%;
        }


        .pretty {
            margin-right: 0!important;
            white-space: normal!important;
        }

        .pretty .state label {
            /*text-indent: 0!important;*/
        }

        .pretty .state label > span {
            display: inline-block!important;
            padding-left: 1.8em!important;
            line-height: 1.3em!important;
        }

        .pretty .state label::after, .pretty .state label::before {
            top: 1px!important;
        }
        .pretty.p-svg .state .svg{
            top:0!important;
        }

    </style>
@endsection




@section('content')
    <div class="container-fluid min_height_area">

        <div class="row">
            <div class="col-md-12">
                <div class="view-header">

                    <section class="content-header">
                        <ol class="breadcrumb">
                            <li>
                                <span class="fa fa-dashboard" aria-hidden="true"></span>
                                <a href="{{route('admin')}}">{{ trans('translate.dashboard') }}</a></li>

                            <li class="active text-capitalize">{{ trans('translate.leave_management') }}</li>
                            <li class="active text-capitalize">{{ trans('translate.leave') }}</li>
                        </ol>
                    </section>
                </div>
            </div>
        </div> <!--row--> <!--row-->


        <employee-leave-history-master-component>


        </employee-leave-history-master-component>

    </div>

@endsection



@section('hscripts')


    <script>


        window.routes = {
            'route_user_create': '{{ route('site-user-store') }}',
            'route_user_update': '{{ route('site-user-edit',['']) }}',
            'route_user_list': '{{ route('site-user-get-site-user-by-user-type') }}',
            'route_roles_list_and_user_assigned_roles': '{{ route('site-role-get-role-list-and-user-assigned-roles',['']) }}',
            'route_user_details': '{{ route('site-user-get-the-user-details',['']) }}',
            'generate_login_info': '{{ route('site-user-generate-login-info',['']) }}',
            'change_user_status': '{{ route('site-user-change-user-status',['']) }}',



            'get_roles_for_site':"{{route('site-user-role-get-roles-with-accesses')}}",
            'get_site_user_assigned_list':"{{route('site-access-get-assigned-list-for-the-site')}}",
            'role_create':"{{route('site-role-add')}}",
            'role_update':"{{route('site-role-update',[''])}}",
            'role_delete':"{{route('site-role-delete',[''])}}",



            'assign_roles':"{{route('site-user-assign-roles-to-user',[''])}}"



        }
    </script>
@endsection

