
@extends('default.admin.layouts.master')

@section('style')
    {!! Html::style('css/styles.css') !!}
@endsection

@section('content')

    <div class="container-fluid min_height_area">
        <div class="row">

            <div class="col-md-12">
                <div class="view-header">
                    <section class="content-header">
                        <ol class="breadcrumb">
                            <li>
                                <span class="fa fa-dashboard" aria-hidden="true"></span>
                                <a href="{{route('admin')}}">{{ trans('translate.dashboard') }}</a></li>
                            <li class="active text-capitalize">
                                <a>{{ trans('breadcrumb.student-waiver.view') }}</a>
{{--                                <a href="{{route('student-attendance-list')}}">{{ trans('breadcrumb.student-waiver.view') }}</a>--}}
                            </li>
                            <li class="active text-capitalize">{{ trans('breadcrumb.student-waiver.over_view') }}</li>
                        </ol>
                    </section>
                </div>
            </div>

        </div>

        <div class="inner-box">
            <div class="row">
                <div class="col-md-12 snt form-horizontal">
                    @if (count($errors) > 0)
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    @if (session()->has('success'))
                        <div class="alert alert-success">
                            <ul>
                                <li>{{ session()->get('success') }}</li>
                            </ul>
                        </div>
                    @endif
                    {{--<a href="{{ route('add-student-attendance-form') }}"><i class="fa fa-plus"></i>  {{ trans('sidebar.add-student-attendance') }}</a>--}}
                </div>
            </div>
        </div>
        <div class="col-md-12 no-padding">
            <div class="nav-tabs-custom">
                <ul class="nav nav-tabs">
                    {{-- <li class="header">
                         <i class="fa fa-th"></i> Student Attendance
                     </li>--}}

                    <li class="active">
                        <a href="#tab_1" data-toggle="tab" aria-expanded="true" style="color:#3c8dbc;">Waiver</a>
                    </li>
                    <li class>
                        <a href="#tab_2" data-toggle="tab" aria-expanded="false" style="color:#3c8dbc;">Offer</a>
                    </li>

                </ul>
                <div class="tab-content">

                    <div class="tab-pane active" id="tab_1">
                        <student-waiver-history-view-component>

                        </student-waiver-history-view-component>
                    </div>
                    <!-- /.tab-pane -->
                    <div class="tab-pane" id="tab_2">
                        <student-fee-offer-detail-view-component>

                        </student-fee-offer-detail-view-component>
                    </div>

                    <!-- /.tab-pane -->



                    <!-- /.tab-pane -->
                </div>
                <!-- /.tab-content -->
            </div>
        </div>
        {{--<div class="row">--}}
            {{--<student-waiver-history-view-component>--}}

            {{--</student-waiver-history-view-component>--}}
        {{--</div>--}}
    </div>

@endsection


@section('scripts')

    @parent

    {!! Html::script('select/js/select2.min.js') !!}



@endsection
