@extends('default.admin.layouts.master')
@section('style')
    {!! Html::style('css/styles.css') !!}
@endsection
@section('content')
    <div class="container-fluid min_height_area">
        <div class="row">
            <div class="col-md-12">
                <div class="view-header">
                    <section class="content-header">
                        <a class="float-left" href="{!! route('student_add_form') !!}">
                            <i class="fa fa-plus"></i> {{ trans('sidebar.create_student') }}
                        </a>
                        <ol class="breadcrumb">
                            <li>
                                <span class="fa fa-dashboard" aria-hidden="true"></span>
                                <a href="{{route('admin')}}">{{ trans('translate.dashboard') }}</a>
                            </li>
                            <li class="active text-capitalize">{{ request()->route()->getName() }}</li>
                        </ol>
                    </section>
                </div>
            </div>

        </div> <!--row--> <!--row-->

        <div class="inner-box-1">

            <div id="datatable">
                <div class="row last">
                    <div class="col-sm-12 col-xs-12">


                        @if (count($errors) > 0)
                            <div class="alert alert-danger">
                                <ul>
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif
                        @if(session()->has('success'))
                            <div class="alert alert-success">
                                <ul>

                                    <li>{{ session()->get('success') }}</li>

                                </ul>
                            </div>
                        @endif
                        <div class="box">
                            <div class="box-body auto_scroll table-responsive">
                                <table id="example1" class="table table-bordered table-striped">
                                    <thead>
                                    <tr>
                                        <th>{{ trans('translate.sl') }}</th>
                                        <th class="text-center">{{ trans('translate.photo') }}</th>
                                        <th class="text-center">{{ trans('translate.name') }}</th>
                                        <th class="text-center">{{ trans('translate.class') }}</th>
                                        <th class="text-center">{{ trans('translate.roll_no') }}</th>
                                        <th class="text-center">{{ trans('translate.department') }}</th>
                                        <th class="text-center">{{ trans('translate.address') }}</th>
                                        <th class="text-center">{{ trans('translate.phone') }}</th>
                                        <th class="text-center">{{ trans('translate.gender') }}</th>
                                        <th class="text-center">{{ trans('translate.religion') }}</th>
                                        <th class="text-center th_width_100">{{ trans('translate.action') }}</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @set('sl',1)
                                    @if(isset($studentList) && !empty($studentList))
                                        @foreach($studentList as $key => $user)
                                            <tr>
                                                <td>
                                                    {{ ($key + 1) + (($studentList->currentPage() - 1) *$studentList->perPage()) }}
                                                </td>

                                                <td class="text-center">
                                                    @if( count($user->photos)>0)
                                                        {!!  Html::image('uploads/'.$user->photos->last()->name, 'alt', array( 'width' => 70, 'height' => 70,'class' => 'img-rounded' )) !!}
                                                    @else
                                                        {!!  Html::image('uploads/image-not.png', 'alt', array( 'width' => 70, 'height' => 70,'class' => 'img-rounded' )) !!}
                                                    @endif

                                                </td>


                                                <td class="text-center text-uppercase">
                                                    {{($user->first_name ?? 'Not ') .' '. ($user->last_name ?? 'Availabale' )}}

                                                </td>

                                                <td class="text-center">

                                                    {{ $user->stClass->class_name ?? 'No Class'}}

                                                </td>

                                                <td class="text-center">{{ $user->student_roll_number}}</td>

                                                <td class="text-center">
                                                    {{ $user->department->name ?? 'N/A' }}
                                                </td>

                                                <td class="text-center">
                                                    {{ $user->address ?? 'N/A' }}
                                                </td>
                                                <td class="text-center">{{ $user->phone}}</td>

                                                <td class="text-center">
                                                    {{$user->gender->gender_name ?? 'N/A' }}
                                                </td>

                                                <td class="text-center">
                                                    {{ $user->religion->name ??  'Not Found' }}
                                                </td>
                                                <td>
                                                    <a class="btn btn-info btn-xs mrg"
                                                       data-original-title="{{ trans('translate.view') }}"
                                                       data-toggle="tooltip"
                                                       href="{{ route('student-view',[$user->id]) }}">
                                                        <i class="fa fa-check-square"></i></a>
                                                    {{--<a class="btn btn-success btn-xs mrg"
                                                       data-original-title="{{ trans('translate.edit') }}"
                                                       data-toggle="tooltip"
                                                       href="{{ route('student-edit-form',[$user->id]) }}"><i
                                                                class="fa fa-edit"></i></a>--}}

                                                    <a class="btn btn-danger btn-xs mrg"
                                                       onclick="return confirm('are you sure?')"
                                                       data-original-title="{{ trans('translate.delete') }}"
                                                       data-toggle="tooltip"
                                                       href="{{ route('student-delete',[$user->id]) }}"><i
                                                                class="fa fa-trash-o"></i></a>
                                                </td>

                                            </tr>
                                        @endforeach

                                    @else
                                        <tr>
                                            <td>
                                                Sorry !!! No Students Found........
                                            </td>
                                        </tr>


                                    @endif
                                    </tbody>
                                    <tfoot>

                                    </tfoot>
                                </table>
                                <div class="pagination">{!!   str_replace('/?','?',$studentList->render() ) !!} </div>
                            </div><!-- /.box-body -->
                        </div><!-- /.box -->
                    </div>
                </div> <!--row last-->

            </div>
        </div>
    </div>
@endsection


{{--@section('scripts')--}}

{{--@parent--}}


{{--@endsection--}}
