<h4>Date : {{ $attDate ?? 'Not Available'}}</h4>
<h4>Class : {{ $studentClass->class_name ?? 'Not Available'}}</h4>

@if(isset($studentClass->class_name))
    @set('present_type',$studentClass->class_name)
    @set('present_type_id',$studentClass->id)
@endif

@if(isset($studentSection))
    <h4>Section : {{ $studentSection->section_name ?? 'Not Available'}}</h4>
    @set('present_type',$studentSection->section_name)
    @set('present_type_id',$studentSection->id)
@endif

@if(isset($studentSubject))
    <h4>Subject : {{ $studentSubject->subject_name ?? 'Not Available'}}</h4>
    @set('present_type',$studentSubject->subject_name)
    @set('present_type_id',$studentSubject->id)
@endif

@if(count($studentAttendanceExist)>0)
    <h4>Total Present : {{count($studentAttendanceExist)}}</h4>

@endif



<table id="studentList" class="table table-bordered table-striped" style="text-align: center">
    <thead>
    <tr>
        <th>SL</th>
        <th>Roll No</th>
        <th>Present</th>
        <th>Name</th>
        <th>Photo</th>
        <th>Class</th>
        <th>Section</th>
        <th class="text-center">In Time</th>
        <th class="text-center">Out Time</th>
    </tr>
    </thead>
    <tbody>
    @set('sl',1)
    {{--
        'in_time'=>$todaysAttendance->in_time?$todaysAttendance->in_time:null,
        'out_time'=>$todaysAttendance->out_time?$todaysAttendance->out_time:null,--}}

    @if(isset($studentList) && count($studentList)>0)

        @foreach($studentList as $key => $student)


            @php
                $existId= $student->studentAttendance->id ?? null;
                $inTime= $student->studentAttendance->in_time ?? null;
                $outTime= $student->studentAttendance->out_time ?? null;
            @endphp

            @set('stInfo', [
                  'userId'=>$student->id?$student->id:null,
                  'userRoll'=>$student->roll_no?$student->roll_no:null,
                  'stClass'=> $student->stClass->class_name?$student->stClass->class_name:null ,
                  'stClassId'=> $student->stClass->id?$student->stClass->id:null ,
                  'section'=> $student->section->section_name?$student->section->section_name:null,
                  'sectionId'=> $student->section->id?$student->section->id:null,
                  'stSection'=> isset($studentSection)?$studentSection->section_name:null,
                  'stSectionId'=> isset($studentSection)?$studentSection->id:null,
                  'subject'=> isset($studentSubject)?$studentSubject->subject_name:null,
                  'subjectId'=> isset($studentSubject)?$studentSubject->id:null,
                  'attDate'=> isset($attDate)?$attDate:null,
                  'existId'=> isset($existId)?$existId : null
                  ])
            @php
                       $stInfo['inTime']=$inTime;
                       $stInfo['outTime']=$outTime;
            @endphp


            <tr>
                           <td>{{$sl++}}</td>
                           <td>
                               {{ $student->id ?? 'NA' }} <br>
                               {{ $student->roll_no ?? 'NA' }}
                           </td>
                           <td>
                               <input value="{{$student->id}}" title="" type="checkbox"

                                      @if(count($studentAttendanceExist)<=0)
                                      checked="checked"
                                      @else
                                      @if($student->studentAttendance)
                                      checked="checked" data-exist-id="{{$student->studentAttendance->id}}"
                                      @endif
                                      @endif class="action-normal" data-stinfo="{{ json_encode($stInfo) }}" />
                           </td>

                           <td>
                               @if(!is_null($student->translate($locale)))
                                   {{$student->translate($locale)->first_name.' '.$student->translate($locale)->last_name }}
                               @else
                                   Not available
                               @endif
                           </td>
                           <td>
                               @if( count($student->photos)>0)
                                   {{--{!!  Html::image('imagecache/dummy/'.$student->photos->last()->name) !!}--}}
                                   {!!  Html::image('uploads/'.$student->photos->last()->name, 'alt', array( 'width' => 40, 'height' => 30,'class' => 'img-rounded' )) !!}
                               @else
                                   {!!  Html::image('uploads/image-not.png', 'alt', array( 'width' => 40, 'height' => 30,'class' => 'img-rounded')) !!}
                               @endif

                           </td>
                           {{--<td><span class="glyphicon glyphicon-user fa-man" aria-hidden="true"></span></td>--}}

                           <td>
                               {{ $student->section->studentClass->class_name ?? 'NA' }}
                           </td>

                           <td>
                               {{ $student->section->section_name ?? 'NA' }}
                           </td>


                           <td>
                               <input type="text" name="in_time" value="{{ $student->studentAttendance->in_time ?? date('H:i:s', time()) }}"
                                      class="attendance-time att-in" id="{{ 'att-in-'.$student->id }}" data-stinfo="{{ json_encode($stInfo)}}"
                                      placeholder="In Time"/>
                           </td>
                           <td>
                               <input type="text" name="out_time" value="{{ $student->studentAttendance->out_time ?? date('H:i:s', time())}}"
                                      class="attendance-time att-out" id="{{ 'att-out-'.$student->id }}" data-stinfo="{{ json_encode($stInfo) }}"
                                      placeholder="Out Time"/>
                           </td>

                       </tr>
                   @endforeach
               @endif

               </tbody>

           </table>


           <a class="btn btn-primary action-btn" href="#">Submit</a>

           @section('scripts')

               @parent




           @endsection