{{-- dd($student_history) --}}
@extends('default.admin.layouts.master')


@section('style')
    {!! Html::style('css/styles.css') !!}
@endsection



@section('content')
    <div class="container-fluid min_height_area">

        <div class="row">
            <div class="col-md-12">
                <div class="view-header">
                    <section class="content-header">
                        <ol class="breadcrumb">
                            <li>
                                <span class="fa fa-dashboard" aria-hidden="true"></span>
                                <a href="{{route('admin')}}">{{ trans('translate.dashboard') }}</a>
                            </li>
                            <li class="active text-capitalize">{{ request()->route()->getName() }}</li>
                        </ol>
                    </section>
                </div>
            </div>
        </div>

        <div class="inner-box-1">
            <div class="row">

                <div class="col-md-8 col-md-offset-2">


                    <div class="view-table-holder m_bottom_40">
                        <table class="table table-bordered table-hover table-responsive">
                            <thead>
                            <tr class="th-bg">
                                <th colspan="4" class="text-center">
                                    <div class="view-picture">
                                        @if($student_history->student)
                                            {!!  Html::image('uploads/'.$student_history->student->latestPhoto->name) !!}
                                        @endif
                                        {{--<span class="glyphicon glyphicon-user fa-man img-circle" aria-hidden="true"></span>--}}
                                    </div>
                                </th>
                            </tr>
                            <tr class="th-bg">
                                <th colspan="4" class="text-center">
                                    <div
                                        class="view-name">
                                        <a target="_blank" href="{{route('site-student-report-details-pdf-report') .'?history_id='.$student_history->id}}">{{ $student_history->student->full_name ?? ''}}</a>
                                      </div>
                                </th>
                            </tr>

                            <tr class="th-bg">
                                <th colspan="4" class="text-center">
                                    <div class="view-name">
                                        {{ trans('translate.fathers_name') }} :
                                        {{ $student_history->student->father_name ?? 'Not Found' }}
                                    </div>
                                </th>
                            </tr>

                            <tr class="th-bg">
                                <th colspan="4" class="text-center">
                                    <div class="view-name">
                                        {{ trans('translate.class_name') }}
                                        : {{ $student_history->stClass->class_name ?? 'Not Found' }}

                                    </div>
                                </th>
                            </tr>

                            <tr class="th-bg">
                                <th colspan="4" class="text-center">
                                    <div class="view-name">
                                        {{ trans('translate.email') }}
                                        : {{ $student_history->email }}
                                    </div>
                                </th>
                            </tr>

                            <tr>
                                <th colspan="4" class="text-center">
                                    {{ trans('translate.subject') }} :

                                    @if(count($student_history->academic_subject_ids[0]))
                                        @foreach($student_history->academic_subject_ids[0] as $k=>$subject)
                                            <label class="label label-info"  style="margin:1px">
                                                 {{ $subject->subject_name }}
                                             {{--   @if($k!=(count($subjects)-1))
                                                    ,
                                                @endif--}}
                                            </label>
                                        @endforeach
                                    @endif

                                </th>
                            </tr>

                            </thead>
                        </table>

                        <fieldset>
                            <legend>{{ trans('translate.student_login') }}</legend>
                            <table class="table table-bordered  table-striped">

                                <tbody>
                                <tr>
                                    <td>{{ trans('translate.user_name') }}</td>
                                    <td>{{ $student_history->student->username }}</td>
                                </tr>
                                </tbody>
                            </table>

                        </fieldset>
                        <fieldset>
                            <legend>{{ trans('translate.student_information') }}</legend>
                            <table class="table table-bordered table-striped">
                                <tbody>


                                @if($student_history->department)
                                    <tr>
                                        <td>{{ trans('translate.department') }}</td>
                                        <td> {{ $student_history->department->name ?? 'n/a' }}</td>
                                    </tr>
                                @endif

                                <tr>
                                    <td>{{ trans('translate.class_name') }}</td>
                                    <td> {{ $student_history->stClass->class_name ?? 'n/a' }}</td>
                                </tr>

                                @if($student_history->section)

                                <tr>
                                    <td> {{ trans('translate.section_name') }}</td>
                                    <td> {{  $student_history->section->section_name ?? 'Not Found' }}</td>
                                </tr>
                                @endif


                                <tr>
                                    <td>{{ trans('translate.roll_number') }}</td>
                                    <td> {{ $student_history->student_roll_number }}</td>
                                </tr>

                                <tr>
                                    <td> {{ trans('translate.fathers_name') }}</td>
                                    <td> {{  $student_history->student->father_name ?? 'Not Found' }}</td>
                                </tr>


                                <tr>
                                    <td>{{ trans('translate.mothers_name') }} </td>
                                    <td> {{ $student_history->student->mother_name ?? 'Not Found' }}</td>

                                </tr>
                                <tr>
                                    <td>{{ trans('translate.admission_date') }}</td>
                                    <td> {{ $student_history->dept_join_date }}</td>
                                </tr>
                                <tr>
                                    <td> {{ trans('translate.address') }}</td>
                                    <td> {{ $student_history->student->address ?? 'Not Found'}}</td>

                                </tr>

                                <tr>
                                    <td>{{ trans('translate.gender') }}</td>
                                    <td> {{ $student_history->student->gender->gender_name ?? 'Not Found'  }}</td>
                                </tr>

                                <tr>
                                    <td> {{ trans('translate.religion') }}</td>
                                    <td> {{ $student_history->student->religion->name ?? 'Not Found' }}</td>
                                </tr>

                                <tr>
                                    <td>{{ trans('translate.nid_number') }}</td>
                                    <td> {{ $student_history->student->nid_number }}</td>
                                </tr>
                                <tr>
                                    <td>{{ trans('translate.passport_number') }}</td>
                                    <td> {{ $student_history->student->passport_no }}</td>
                                </tr>
                                <tr>
                                    <td>  {{ trans('translate.birth_certificate') }}</td>
                                    <td> {{ $student_history->student->birth_certificate_no }}</td>
                                </tr>

                                </tbody>
                            </table>


                        </fieldset>

                        <fieldset>
                            <legend>{{ trans('translate.contact') }}</legend>
                            <table class="table table-bordered table-striped">

                                <tbody>
                                <tr>
                                    <td> {{ trans('translate.phone') }}</td>
                                    <td> {{ $student_history->student->contact_number }}</td>

                                </tr>
                                <tr>
                                    <td>{{ trans('translate.emergency_contact') }}</td>
                                    <td> {{ $student_history->student->emergency_contact }}</td>
                                </tr>
                                <tr>
                                    <td> {{ trans('translate.email') }}</td>
                                    <td>{{ $student_history->student->email }}</td>
                                </tr>
                                </tbody>
                            </table>


                        </fieldset>


                        <fieldset>
                            <legend>{{ trans('translate.guardian') }}</legend>
                            <table class="table table-bordered table-striped">

                                <tbody>
                                <tr>
                                    <td> {{ trans('translate.phone') }}</td>
                                    <td> {{ $student_history->student->guardian->full_name ?? 'N/A' }}</td>

                                </tr>
                                <tr>
                                    <td>{{ trans('translate.emergency_contact') }}</td>
                                    <td> {{ $student_history->student->guardian->emergency_contact ?? 'N/A' }}</td>
                                </tr>
                                <tr>
                                    <td> {{ trans('translate.email') }}</td>
                                    <td>{{ $student_history->student->guardian->usename ?? 'N/A' }}</td>
                                </tr>
                                </tbody>
                            </table>


                        </fieldset>


                    </div>


                </div>
            </div>
        </div>
    </div>



@endsection


