@inject('createSubject','App\Forms\SubjectForm')

@extends('default.admin.layouts.master')

@section('style')
    {!! Html::style('css/styles.css') !!}
    {!! Html::style('select/css/select2.min.css') !!}
@endsection

@section('content')

    <div class="container-fluid min_height_area">
        <div class="row">
            <div class="col-md-12">
                <div class="student-box-header">
                    <div class="col-md-6 col-xs-5">
                        <span class="glyphicon glyphicon-user " aria-hidden="true"></span>{{ trans('sidebar.subject_create') }}
                    </div>
                    <div class="col-md-6 col-xs-7 snt">
                        <ul class="breadcrumb text-right">
                            <li>
                                <span class="glyphicon glyphicon-folder-close" aria-hidden="true"></span>
                                <a href="#">{{ trans('translate.dashboard') }}</a></li>
                            <li class="active">{{ trans('sidebar.subject_create') }}</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div> <!--row-->
        <div class="inner-view">
            <div class="row">
                <div class="col-md-12 snt form-horizontal">
                    <div class="col-md-12" id="successMe5ssage">
                        @if (count($errors) > 0)
                            <div class="alert alert-danger row">
                                <ul>
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif
                        @if(session()->has('success'))
                            <div class="alert alert-success row" >
                                <ul>
                                    <li>{{ session()->get('success') }}</li>
                                </ul>
                            </div>
                        @endif
                    </div>
                    
                    <div class="custom_row">                      
                        <h2 class="form_title">
                            {{ trans('sidebar.subject_enrole_form') }}
                        </h2>                                          
                    </div>



                    {!! Form::open(array('route' => 'subject-create', 'files' => true, 'id'=>'create-form','class'=>'form-create')) !!}

                    {!! formFields($createSubject) !!}

                    {!!  Form::close()   !!}
                </div>
            </div>
        </div>
    </div>



@endsection

@section('scripts')


    @parent
    <script src="{{ asset('jquery-validation/dist/jquery.validate.min.js') }}"></script>
    {!! Html::script('select/js/select2.min.js') !!}

    <script type="text/javascript">
        $(document).ready(function(){
            $('#student_class_id').select2();
            $('#user_id').select2();
            $('#combine_subject').select2();
            $('#result_system_id').select2();
            $('#combine_name').hide();

            if($('#combine_subject').val()!=0) {
                $('#combine_name').show()
                $('#combine_name_1').show()
            }else{
                $('#combine_name').hide()
                $('#combine_name_1').hide()
            }



            $('#combine_subject').on('change',function () {
                console.log($(this).val())
                $('#combine_name').hide()
                $('#combine_name_1').hide()

                if($(this).val()!=0) {
                    $('#combine_name').show()
                    $('#combine_name_1').show()
                }
            })

            $('#student_class_id').on('change',function () {

                var studentClassId = $('#student_class_id').find('option:selected').val();

                console.log(studentClassId);

                var host = window.location.origin ;

                $.ajax({
                    'url': host+'/subject/list-by-class/'+studentClassId,
                    'dataType': 'json',
                    success: function(data){
                        console.log(data);
                        var subjectList = "<option value='0' selected>Select Combine Subject </option>";
                        $(data).each(function(index,item){
                            subjectList += "<option value ="+ item.id +">"+item.subject_name+" </option>";
                        });
                        $('#combine_subject').html(subjectList);
                        $('#combine_subject').val('0').trigger('change.select2');
                    },
                    error:function (data) {

                        console.log(data)
                        if(data.status == 300||401){
                            $.growl.warning({ message: data.responseText});
                        }else{
                            $.growl.error({ message: "It has Some Error!" });
                        }
                        $('#tabulation-sheet-div').html('');

                    }
                });
            });


        });
    </script>



@endsection
