@extends('default.admin.layouts.master')

@section('style')
    {!! Html::style('css/styles.css') !!}


@endsection

@section('content')

    <div class="container-fluid min_height_area">
        <div class="row">
            <div class="col-md-12">
                <div class="student-box-header">
                    <div class="col-md-6 col-xs-5">
                        <span class="glyphicon glyphicon-user "
                              aria-hidden="true"></span>{{ trans('sidebar.class_timing_weekday') }}
                    </div>
                    <div class="col-md-6 col-xs-7 snt">
                      {{--  <ul class="breadcrumb text-right">
                            <li>
                                <span class="glyphicon glyphicon-folder-close" aria-hidden="true"></span>
                                <a href="#">{{ trans('sidebar.dashboard') }}</a></li>
                            <li class="active">{{ trans('sidebar.class_timing_weekday') }}</li>
                        </ul>--}}
                    </div>
                </div>
            </div>


            @if(session()->has('error'))
                <div  class="col-md-8 col-md-offset-2  text-center successOrErrorDiv">
                    <div class="alert alert-warning">
                        <p class="text-uppercase">
                            <i class="fa fa-warning fa-fw"></i>
                            <b>
                                {{ session()->get('error') }}
                            </b>
                        </p>
                    </div>
                </div>
            @endif


            @if(session()->has('success'))
                <div  class="col-md-8 col-md-offset-2 text-center successOrErrorDiv">
                    <div class="alert alert-success">
                        <p class="text-uppercase">
                            <button type="button" class="btn btn-info btn-circle"><i class="fa fa-check"></i>
                            </button>
                            <b>
                                {{ session()->get('success') }}
                            </b>
                        </p>
                    </div>
                </div>
            @endif






        </div> <!--row-->
        <div class="row">
            <div class="col-md-12">
                <div class="view-header">
                    <button onclick="javascript:window.print()" class="btn btn-primary"><span
                                class="fa fa-print"></span> {{ trans('translate.print') }} </button>
                    <button onclick="javascript:window.print()" class="btn btn-primary"><span
                                class="fa fa-file"></span> {{ trans('translate.print_preview') }} </button>
                    <button class="btn btn-primary"><span class="fa fa-file"></span> {{ trans('translate.edit') }}
                    </button>

                </div>
            </div>
        </div> <!--row-->


        <div class="inner-box">
            <div class="row">
                <div id="datatable">
                    <div class="row last">
                        <div class="col-sm-6 col-xs-12">

                            <table class="table table-bordered table-striped table-responsive">
                                <thead>

                                <thead>

                                <tr>
                                    <td>
                                        <label for="">Class Name: </label>
                                        <select class="form-control" title="" id="student_class_id">
                                            @foreach($class as $k=>$value)
                                                <option value="{{$value->id}}">{{$value->class_name}}</option>
                                            @endforeach
                                        </select>

                                        <span id="class_change_loading_image" style="display: none">
                                                {!! Html::image('image/select.gif') !!}
                                        </span>
                                    </td>

                                    <td>
                                        <label for="">Section Name: </label>
                                        <select class="form-control" title="" id="section_id">
                                            <option value="0">Section</option>
                                        </select>

                                        <span id="section_change_loading_image" style="display: none">
                                                {!! Html::image('image/select.gif') !!}
                                        </span>
                                    </td>
                                </tr>

                                </thead>
                            </table>
                        </div>
                        <div class="col-sm-12 col-xs-12">
                            <div class="box">
                                <div class="box-body auto_scroll" id="weekday_list_for_timing">


                                </div><!-- /.box-body -->
                            </div><!-- /.box -->
                        </div>
                    </div> <!--row last-->
                </div>
            </div>
        </div>
    </div>

@endsection



@section('scripts')


    @parent

    {{-- <script src="{{ asset('jquery-validation/dist/jquery.validate.min.js') }}"></script>--}}
    {!! Html::script('datepicker/js/bootstrap-datepicker.js') !!}
    {!! Html::script('select/js/select2.min.js') !!}




    <script type="text/javascript">
        $(document).ready(function () {

            $(".successOrErrorDiv").delay(5000).slideUp(3500);

            getSections();

            $('#student_class_id').change(function () {
                getSections();
            });

            function getSections() {

                $(".successOrErrorMsgDiv").css('display','none');

                $('#weekday_list_for_timing').html('');
                var host = window.location.origin;
                $("#class_change_loading_image").css('display', 'inline')
                var studentClassId = $('#student_class_id').find('option:selected').val();
                $.ajax({
                    'url': host + '/section/list-by-class/' + studentClassId,
                    'dataType': 'json'
                }).success(function (data) {
                    console.log(data);
                    var sectionForClass = "<option value=''>Select Section</option>";
                    $(data[0]).each(function (index, item) {
                        sectionForClass += "<option value =" + item.id + ">" + item.section_name + " </option>";
                    });
                    $('#section_id').html(sectionForClass);

                }).error(function () {

                }).complete(function () {
                    $("#class_change_loading_image").css('display', 'none')
                })
            }

            $('#section_id').change(function (e) {

                $(".successOrErrorMsgDiv").css('display','none');

                e.preventDefault();
                $('#weekday_list_for_timing').html('');
                var host = window.location.origin;
                $("#section_change_loading_image").css('display', 'inline');
                var studentClassId = $('#student_class_id').find('option:selected').val();
                var studentSectionId = $('#section_id').find('option:selected').val();

                console.log(studentClassId);
                console.log(studentSectionId);
                $.ajax({
                    type: "GET",
                    url: host + '/class-timing/weekday-list-for-section/' + studentClassId + '/' + studentSectionId,
                    // data: myusername,
                    cache: false
                }).done(function (data) {
                    $data = $(data);
                    $('#weekday_list_for_timing').html($data);

                }).fail(function () {
                }).always(function () {
                    $("#section_change_loading_image").css('display', 'none');
                });

            });



            $("#weekday_list_for_timing").on("click","#save_setting",function () {
                var studentClassId = $('#student_class_id').find('option:selected').val();
                var studentSectionId = $('#section_id').find('option:selected').val();


                var arrayWeekday=new Object();
                $(".weekday_cb:checkbox:checked").each(function () {
                    var sThisVal = $(this).val();
                    $('#class_timing_'+sThisVal+' option:selected').each(function() {
                        arrayWeekday[sThisVal] = $(this).val();
                    });
                });
                var size = Object.keys(arrayWeekday).length;

                if(size<=0){
                    $.growl.warning({ message: "Select at least one weekday to continue!" });
                    return
                }
                $("#save_setting_loading_image").css('display', 'inline');

                $.ajax({
                    type: "GET",
                    url:'{{route('save-weekday-list-for-section')}}',
                    data: {
                        data: arrayWeekday,
                        'classId':studentClassId,
                        'sectionId':studentSectionId
                    }
                }).done(function (data) {

                     console.log(data);
                    $.growl.notice({ message: 'Successfully Saved!' });

                }).fail(function (data) {

                    console.log(data);
                }).always(function () {
                    $("#save_setting_loading_image").css('display', 'none');
                });




            });



        });
    </script>



@endsection

