<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <style>
        body {
            font-family: 'Arial', sans-serif;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            page-break-inside: auto;
        }

        th, td {
            border: 1px solid black;
            padding: 1px;
            text-align: left;
        }

        th {
            background-color: #f2f2f2;
            position: -webkit-sticky;
            position: sticky;
            top: 0;
        }

        .table-title {
            text-align: center;
            font-size: 20px;
            font-weight: bold;
            margin-bottom: 20px;
        }

        thead {
            display: table-header-group; /* Ensure the header repeats on each page */
        }

        tr {
            page-break-inside: avoid; /* Avoid breaking rows across pages */
        }

        @page {
            margin: 10px; /* Adjust page margins if needed */
        }
    </style>
</head>
<body>
    <div class="table-title">
        Chart of Accounts
    </div>
    <table>
        <thead>
            <tr>
                <th>Accounts Head</th>
                <th>Accounts Group</th>
                <th>Accounts Sub-group</th>
                <th>Ledger Code</th>
                <th>Ledger Name</th>
                <th>Initial Amount</th>
            </tr>
        </thead>
        <tbody>
            @foreach($final_data as $key => $head)
                @if(isset($head['accounts_group']) && is_array($head['accounts_group']))
                    @foreach($head['accounts_group'] as $groupName => $groupData)
                        @php $firstRow = true; @endphp
                        @if(isset($groupData['accounts_sub_group']) && is_array($groupData['accounts_sub_group']))
                            @foreach($groupData['accounts_sub_group'] as $subGroupName => $ledgers)
                                @foreach($ledgers as $ledger)
                                    <tr>
                                        @if($firstRow)
                                            <td>{{ $head['accounts_head'] }}</td>
                                            @php $firstRow = false; @endphp
                                        @else
                                            <td></td> <!-- Empty cell to avoid rowspan issues -->
                                        @endif
                                        <td>{{ $groupName }}</td>
                                        <td>{{ $subGroupName }}</td>
                                        <td>{{ $ledger['ledger_code'] }}</td>
                                        <td>{{ $ledger['name'] }}</td>
                                        <td>{{ $ledger['initial_amount'] ?? 'N/A' }}</td>
                                    </tr>
                                @endforeach
                            @endforeach
                        @else
                            <tr>
                                <td>{{ $head['accounts_head'] }}</td>
                                <td>{{ $groupName }}</td>
                                <td colspan="4">No Sub-groups</td>
                            </tr>
                        @endif
                    @endforeach
                @else
                    <tr>
                        <td>{{ $head['accounts_head'] }}</td>
                        <td colspan="5">No Groups</td>
                    </tr>
                @endif
            @endforeach
        </tbody>
    </table>
</body>
</html>
