@extends('default.site.layout.master')

@section('content')

    <div class="container-fluid min_height_area">
        <div class="row">
            <div class="col-md-12">
                <div class="view-header">
                    <section class="content-header">
                        <ol class="breadcrumb">
                            <li>
                                <span class="fa fa-dashboard" aria-hidden="true"></span>
                                <a href="{{route('admin')}}">{{ trans('translate.dashboard') }}</a></li>
                            <li class="active text-capitalize">{{ request()->route()->getName() }}</li>
                        </ol>
                    </section>
                </div>
            </div>
        </div>

            <employee-attendance-master-component
            >
            </employee-attendance-master-component>
    </div>

@endsection


@section('hscripts')


    <script>


        window.routes = {
            'attendance_list_by_shift_date': '{{ route('all-employee-attendance-list-by-shift-date') }}',
            'route_attendance_get_shift_list': '{{ route('site-employee-get-shift-list-for-employee') }}',
            'route_employee_attendance_edit': '{{ route('employee-attendance-edit') }}',
            'route_take_access_time': '{{ route('employee-attendance-take-access-time') }}',
            'route_log_by_date_and_username': '{{ route('edu-device-log-get-device-log-by-date-and-username') }}',
            'route_send_sms': '{{ route('site-employee-attendance-send-sms') }}',
            'route_report_date_shift': '{{ route('site-employee-attendance-report-date-and-shift') }}',
            'route_open_pdf_file': '{{ route('open-pdf-file-storage',['']) }}',
            'route_report_month_shift': '{{ route('site-employee-attendance-report-month-and-shift') }}',
            'route_short_report_year_month_shift_wise': '{{ route('site-employee-attendance-short-report-year-month-and-shift') }}',
            'route_emp_list': '{{ route('site-employee-get-simple-active-list') }}',
            'route_emp_yearly_report': '{{ route('site-employee-attendance-employee-wise-yearly-report') }}',
            'route_site_year_list': '{{ route('get-all-type-academic-year-list') }}',
            'route_site_month_list': '{{ route('get-all-month-list') }}',




            'route_user_list': '{{ route('site-user-get-site-user-by-user-type') }}',
            'route_user_data_update': '{{ route('site-user-data-update',['']) }}',
        }
    </script>
@endsection

