<!DOCTYPE html>
<html>
<head>

    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no'
          name='viewport'>

    <title>{{$report_tittle}}</title>

    <style>

        @font-face {
            font-family: 'Verdana';
            font-weight: 100;
            font-style: normal;
            font-variant: normal;
            src: url("{{public_path()}}/fonts/Verdana.ttf") format("truetype");
        }

        body {
            font-family: "Verdana", sans-serif;
            font-size: 12px;
        }

        .tittle {
            background-color: #dcdcdc;
            border-radius: 10px;
            width: 100%;
            color: #000000;
            padding: 5px;
            font-weight: bold;
        }

        .data-table td {
            border: 1px solid #999999;
            text-align: center;
        }

        .image {
            width: 60px;
            height: 60px;
            border-radius: 10px;
        }

    </style>

</head>
<body>
<main>

    @include('default.site.layout.pdf-header')


    <table class="data-table" cellspacing="0" border="0" width="100%;" style="">

        <thead class="tittle">
        <tr>
            <td style="width: 2px">S/L</td>
            <td>Name</td>
            <td>Username</td>
            <td>Weekly Class</td>
            <td>Allocated Periods</td>
            <td>Allocated Hours</td>

        </tr>
        </thead>


        <tbody>
        @foreach($data as $key => $value)

            <tr>
                <td>{{$key+1}}</td>
                <td>
                    <nobr>  {{$value['full_name'] ?? 'N/A'}}</nobr>
                    <br>
                </td>
                <td>{{$value['username']}}</td>
                <td>
                    <span style="font-size: 9px">  ( {{$value['weekly_class'] ?? 'N/A'}} )</span>
                </td>
                <td>
                    <span style="font-size: 9px">  ( {{$value['allotted_periods'] ?? 'N/A'}} )</span>
                </td>
                <td>
                    <span style="font-size: 9px">  ( {{$value['allotted_hours'] ?? 'N/A'}} )</span>
                </td>
            </tr>


        @endforeach
        </tbody>


    </table>
</main>

<footer>
    @include('default.site.layout.pdf-footer')
</footer>


</body>


<style>

    @page {
        size: a4;
        margin: 0px;
    }

    body {
        margin: 10px 20px 50px 20px;
    }


</style>

</html>












