<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Member ID Card - {{ $member['member_id'] ?? 'N/A' }}</title>
    <style>
        @page {
            margin: 10px;
            size: A4;
        }

        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            color: #333;
            margin: 0;
            padding: 0;
        }

        .id-card-container {
            width: 320px;
            height: 200px;
            border: 2px solid #2d3748;
            padding: 10px;
            margin: 20px auto;
            border-radius: 10px;
            background-color: #f7fafc;
            box-shadow: 2px 2px 6px rgba(0,0,0,0.1);
            position: relative;
        }

        .header {
            background-color: #2d3748;
            color: white;
            text-align: center;
            padding: 5px;
            border-radius: 5px 5px 0 0;
            font-weight: bold;
            font-size: 14px;
        }

        .photo {
            width: 80px;
            height: 100px;
            border: 1px solid #cbd5e0;
            background-color: #e2e8f0;
            float: right;
            text-align: center;
            line-height: 100px;
            font-size: 10px;
            color: #718096;
        }

        .details {
            margin-top: 10px;
        }

        .details table {
            width: 100%;
            border-collapse: collapse;
            font-size: 12px;
        }

        .details td {
            padding: 3px 5px;
        }

        .details td:first-child {
            font-weight: bold;
            width: 40%;
            color: #2d3748;
        }

        .footer {
            position: absolute;
            bottom: 5px;
            left: 10px;
            right: 10px;
            font-size: 10px;
            color: #718096;
            text-align: center;
        }
    </style>
</head>
<body>
    <div class="id-card-container">
        <!-- Header -->
        <div class="header">MEMBER ID CARD</div>

        <!-- Photo (optional) -->
        <div class="photo">
            {{-- Optional Photo Placeholder --}}
            Photo
            {{-- If you have photo:
            <img src="{{ public_path($member['photo'] ?? '') }}" alt="Photo" style="width: 100%; height: 100%;">
            --}}
        </div>

        <!-- Member Info -->
        <div class="details">
            <table>
                <tr>
                    <td>Name</td>
                    <td>{!! $member['name'] ?? 'N/A' !!}</td>
                </tr>
                <tr>
                    <td>Member ID</td>
                    <td>{{ $member['member_id'] ?? 'N/A' }}</td>
                </tr>
                <tr>
                    <td>Phone</td>
                    <td>{{ $member['phone'] ?? 'N/A' }}</td>
                </tr>
                <tr>
                    <td>Type</td>
                    <td>{{ ucfirst($member['type'] ?? 'N/A') }}</td>
                </tr>
                <tr>
                    <td>Status</td>
                    <td style="color: green; font-weight: bold;">{{ ucfirst($member['status'] ?? 'Inactive') }}</td>
                </tr>
            </table>
        </div>

        <!-- Footer -->
        <div class="footer">
            Issued: {{ \Carbon\Carbon::parse($member['created_at'])->format('M d, Y') }} |
            ID: #{{ $member['id'] ?? '' }}
        </div>
    </div>
</body>
</html>
