<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <title>{{ $page_tittle }}</title>

    <style>
        @font-face {
            font-family: 'Verdana';
            font-style: normal;
            font-weight: normal;
            src: url("{{ public_path() }}/fonts/Verdana.ttf") format("truetype");
        }

        body {
            font-family: "Verdana", sans-serif;
            font-size: 12px;
            margin: 10px 20px 50px 20px;
        }

        .th-bg {
            background-color: #87adbd;
            color: #ffffff;
        }

        .data-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }

        .data-table th, .data-table td {
            border: 1px dotted #999999;
            padding: 5px;
            text-align: center;
        }

        .fine-breakdown {
            text-align: left;
            font-size: 10px;
            line-height: 1.2;
        }

        .text-red {
            color: red;
        }

    </style>
</head>
<body>

@include('default.site.layout.pdf-header')

<h3 style="text-align:center; margin-bottom:10px;">Overdue Borrowings</h3>

<table class="data-table">
    <thead class="th-bg">
        <tr>
            <th>S/L</th>
            <th>Member</th>
            <th>Book</th>
            <th>Due Date</th>
            <th>Days Overdue</th>
            <th>Fine Breakdown</th>
            <th>Total Fine (Tk)</th>
        </tr>
    </thead>
    <tbody>
        @forelse($BookBorrowing as $index => $borrowing)
            <tr>
                <td>{{ $index + 1 }}</td>
                <td>
                    <strong>{{ $borrowing['memberName'] ?? 'N/A' }}</strong><br>
                    <small>{{ $borrowing['memberPhone'] ?? 'N/A' }}</small>
                </td>
                <td>{{ $borrowing['bookTitle'] ?? 'N/A' }}</td>
                <td>{{ \Carbon\Carbon::parse($borrowing['due_date'])->format('d-m-Y') }}</td>
                <td><span class="text-red">{{ $borrowing['overdue_days'] ?? 0 }} days</span></td>
                <td>
                    <div class="fine-breakdown">
                        @foreach($borrowing['fine_breakdown'] ?? [] as $breakdown)
                            Days {{ $breakdown['day'] }} - {{ $breakdown['amount'] }}<br>
                        @endforeach
                    </div>
                </td>
                <td>
                    <strong class="text-red">{{ $borrowing['fine'] ?? 0 }}</strong>
                </td>
            </tr>
        @empty
            <tr>
                <td colspan="7" style="color: red;">Data Not Found</td>
            </tr>
        @endforelse
    </tbody>
</table>

</body>

<style>
    @page {
        size: a4;
        margin: 0;
    }
</style>

</html>
