<!DOCTYPE html>
<html>
<head>
    @set('site',getSiteInfoForPdf())
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no'
          name='viewport'>

    <title>{{$page_tittle}}</title>

    <style>

        @font-face {
            font-family: 'Verdana';
            font-weight: 100;
            font-style: normal;
            font-variant: normal;
            src: url("{{public_path()}}/fonts/Verdana.ttf") format("truetype");
        }

        body {
            font-family: "Verdana", sans-serif;
            font-size: 12px;
        }

        .tittle {

            border-radius: 10px;
            width: 100%;
            color: #000000;
            padding: 5px;
        }

        .data-table td, th {
            border: 1px dotted #999999;
            text-align: center;
        }

        .data-table th {
            border: 1px solid #999999;
            text-align: center;
        }

        .same-td-width {
            width: 130px;
            text-align: center;
        }


    </style>

</head>
<body>


@include('default.site.layout.pdf-header')


<div>
    <table class="data-table" cellspacing="0" border="0" width="100%;" style="">

        <thead class="tittle">
        <tr>
            <th>Class Timing Name</th>
            <th>Timing Details</th>
        </tr>
        </thead>


        <tbody>
        @foreach($data as $key => $value)

            <tr>
                <td>
                    <nobr> {{$key +1}}. {{$value->name}}</nobr>
                </td>

                <td>

                    @if(count($value->classTimingDetails))
                        <table class="data-table" cellspacing="0" border="0" width="100%;" style="">

                            <thead class="tittle">
                          {{--  <tr>
                                <td colspan="4">
                                    <nobr> <b> {{$key +1}}. {{$value->name}}</b></nobr>
                                </td>
                            </tr>--}}
                            @if($key==0)
                                <tr>
                                    <th class="same-td-width">Name</th>
                                    <th>Start - End</th>
                                    <th>Time</th>
                                    <th>Break</th>
                                </tr>
                            @endif


                            </thead>
                            @foreach($value->classTimingDetails as $key => $timingDetail)

                                <tbody>
                                <tr>
                                    <td class="same-td-width">{{$timingDetail->name}}</td>
                                    <td style="width: 190px">
                                        <nobr>
                                            {{date('h:i A', strtotime($timingDetail->start_time)) }}
                                            - {{date('h:i A', strtotime($timingDetail->end_time)) }}
                                        </nobr>
                                    </td>

                                    <td style="width: 190px">

                                        {{intval((strtotime(date($timingDetail->end_time))-strtotime($timingDetail->start_time))/60)<60
                                                  ? intval((strtotime(date($timingDetail->end_time))-strtotime($timingDetail->start_time))/60)
                                                  : floor(intval((strtotime(date($timingDetail->end_time))-strtotime($timingDetail->start_time))/60)/60).
                                                  ' : '.(intval((strtotime(date($timingDetail->end_time))-strtotime($timingDetail->start_time))/60)
                                                  - floor(intval((strtotime(date($timingDetail->end_time))-strtotime($timingDetail->start_time))/60) / 60) * 60)}}
                                        mins
                                    </td>


                                    <td>{{getYesNo($timingDetail->is_break)}}</td>
                                </tr>
                                </tbody>
                            @endforeach

                        </table>

                    @endif


                </td>
            </tr>

        @endforeach
        </tbody>


    </table>
</div>


</body>


<style>

    @page {
        size: Landscape;
        margin: 0px;
    }

    body {
        margin: 10px 20px 50px 20px;
    }


</style>

</html>












