<!DOCTYPE html>
<html>
<head>

    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no'
          name='viewport'>

    <title>{{$report_tittle}}</title>

    <style>

        .tittle {
            font-size: 11px;
        }

        .slot-table td {
            border: 1px solid #999999;
        }

        .slot-table th {
            border: 1px solid #999999;
        }

        .slot-table tr td {
            border: 1px dotted #999999;
        }

        .slot-table tr td.no-br-td {
            vertical-align: text-top;
        }

        .slot-table tr td:first-child {
            border: 1px solid #999999;
            vertical-align: middle;
        }

        .heading-slot-bg {
            background-color: #dcdcdc;
            color: #000000;
            text-align: center;
            width: 25px;
            vertical-align: text-top;
            padding-left: 20px;

        }

        .slot {
            min-height: 200px;
            padding: 0 3px;
        }

        .break {
            width: 45px;
            padding: 0 3px;
            font-size: 10px;
            vertical-align: middle !important;

        }

        .class_timings {
            font-size: 10px;

        }

        .subject-div {
            font-size: 11px;
            font-weight: bold;

        }

        .employee-div {
            font-size: 9px;

        }

        .room-div {
            font-size: 11px;

        }

        .vertical {
            /*   -ms-transform: rotate(270deg);
               -webkit-transform: rotate(270deg);
               transform: rotate(340deg);*/
            text-align: center;
            font-size: 12px;
            height: 60px;
        }

        .break_timings {
            font-size: 10px;
            font-weight: normal;
            transform: rotate(270deg);
            text-align: center;
        }

        .heading-slot-bg td {
            text-align: center;
        }

    </style>

</head>
<body>


<header>
</header>
<main>


    @if($week_array)

        @include('default.site.layout.pdf-header')
        <div>
            <table class="slot-table" width="100%" cellspacing="0" border="0">
                <thead>
                <tr class="heading-slot-bg">
                    <td>
                        D/P
                    </td>


                    @php
                        $head_ordinal_sl=0;
                    @endphp
                    @foreach($headingList as $k=>$h)
                        @if($h->is_break)
                            <th class="break">
                                <i> {{$h->name}}</i>
                            </th>
                        @else
                            <th>
                                <span style="display: none"> {{$head_ordinal_sl++}}</span>
                                <i> {{addOrdinalNumberSuffix($head_ordinal_sl)}}</i>

                            </th>
                        @endif
                    @endforeach

                    @if(count($headingList) < $max_col_count)
                        <th colspan="{{$max_col_count - count($headingList)}}">
                            <i> {{addOrdinalNumberSuffix($head_ordinal_sl+1)}}</i>
                        </th>

                    @endif
                </tr>


                </thead>


                @if(count($week_array)>0)
                    <tbody>

                    @foreach($week_array as $key=>$week)
                        <tr>

                            <td class="heading-slot-bg">
                                <div class="vertical">
                                    {{$key}}
                                </div>
                            </td>
                            @if(count($week)<1)
                                <td style="text-align: center" colspan="{{$max_col_count}}">No Routine</td>
                            @endif

                            @php
                                $week_nth_loop=0;
                                $total_weekday_loop=0;
                                $colspan_key=0;
                                $br_key=0;
                                $br_col= array_unique($br_col);
                                $break_col_hide= 0;
                            @endphp

                            @foreach($week as $key1 => $slot)

                                @php($week_nth_loop++)
                                @php($total_weekday_loop++)
                                @php($colspan_key++)

                                @if(!$slot->is_break)

                                    @if(in_array($br_key,$br_col))
                                        @php($colspan_key--)
                                        @php($total_weekday_loop++)
                                        @php($break_col_hide=1)
                                        <td></td>
                                    @endif

                                    <td class="no-br-td">
                                        <div class="slot">

                                            <div class="class_timings">
                                                {{date('h:i A', strtotime($slot->start_time)) }}
                                                - {{date('h:i A', strtotime($slot->end_time)) }}


                                                {{--                                            {{$br_col .'col-key'.$br_key}}--}}


                                            </div>

                                            @if(count($slot->routineAllocations))
                                                @foreach($slot->routineAllocations as $ks=>$routineAllocation)
                                                    <div class="subject-div">
                                                        @if($routineAllocation->subject)
                                                            {{$routineAllocation->subject->subject_name}}
                                                        @endif
                                                    </div>

                                                    <div class="employee-div">
                                                        @if($routineAllocation->employee)
                                                            {{$routineAllocation->employee->first_name  .' '. $routineAllocation->employee->last_name }}
                                                            <b> ({{$routineAllocation->employee->employee_id}})</b>
                                                        @endif
                                                    </div>

                                                    <div class="room-div">
                                                        @if($routineAllocation->room)
                                                            {{$routineAllocation->room->room_name}}

                                                            ({{($routineAllocation->room->building->building_name ?? '') .'- '. ($routineAllocation->room->floor->floor_name ?? '')}}
                                                            )
                                                        @endif
                                                    </div>
                                                @endforeach
                                            @endif
                                        </div>
                                        <br>
                                        {{--                                    {{$week_nth_loop ."<". $max_col_count ." ".count($week)."==".$week_nth_loop}}--}}
                                    </td>
                                @else

                                    @if($break_col_hide==0)

                                        <td>
                                            <div class="break_timings">

                                                @php($br_col[] = $br_key)
                                                @php($br_col= array_unique($br_col))


                                                <nobr>  {{$slot->name}}</nobr>
                                                <br>
                                                {{--                                        {{implode(',' ,$br_col)}}--}}
                                                <b>
                                                    {{intval((strtotime(date($slot->end_time))-strtotime($slot->start_time))/60)<60
                                                              ? intval((strtotime(date($slot->end_time))-strtotime($slot->start_time))/60)
                                                              : floor(intval((strtotime(date($slot->end_time))-strtotime($slot->start_time))/60)/60).
                                                              ' : '.(intval((strtotime(date($slot->end_time))-strtotime($slot->start_time))/60)
                                                              - floor(intval((strtotime(date($slot->end_time))-strtotime($slot->start_time))/60) / 60) * 60)}}
                                                    mins</b>

                                            </div>

                                        </td>
                                    @endif

                                @endif

                                {{--for last loop of the day and colspan to max col  && count($week)==$colspan_key $key1 --}}
                                @if($total_weekday_loop < $max_col_count && count($week)==$week_nth_loop)
                                    <td colspan="{{($max_col_count - $total_weekday_loop)}}">

                                    </td>
                                @endif

                                @php($br_key++)

                            @endforeach
                        </tr>
                    @endforeach


                    </tbody>
                @endif

            </table>
        </div>


    @endif


</main>
<footer>
    @include('default.site.layout.pdf-footer')
</footer>
</body>

<style>
    @page {
        size: a4 landscape;
        margin: 0;
    }
    body {
        margin: 5px 5px 0;
    }

</style>

</html>












